/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.rms.RecordStore;

public class SnakeCanvas
extends Canvas {
    private Display display;
    private boolean paused;
    private int fieldWidth = 19;
    private int fieldHeight = 21;
    private Image bufferImage = Image.createImage((int)(this.fieldWidth * 9), (int)(this.fieldHeight * 9 + 12));
    private Graphics buffer = this.bufferImage.getGraphics();
    private int WIDTH = this.fieldWidth * 9;
    private int HEIGHT = this.fieldHeight * 9 + 12;
    private Sprite s_head;
    private Sprite s_tail;
    private Sprite s_body;
    private Sprite s_body2;
    private Sprite s_food;
    private Sprite s_bonus;
    private Sprite s_dead;
    private Vector snake = new Vector();
    boolean DEBUG = false;
    private static int NONE = 78;
    private static final byte EMPTY = 0;
    private static final byte BODY = 1;
    private static final byte FOOD = 3;
    private static final byte BONUS = 4;
    private static final byte HEAD_UP = 100;
    private static final byte HEAD_RIGHT = 101;
    private static final byte HEAD_DOWN = 102;
    private static final byte HEAD_LEFT = 103;
    private static final byte D_UP = 1;
    private static final byte D_RIGHT = 2;
    private static final byte D_DOWN = 3;
    private static final byte D_LEFT = 4;
    private static final byte GAME = 0;
    private static final byte GAMEOVER = 1;
    private static final byte SCORES = 2;
    private static final byte MENU = 3;
    private static final byte HIGHSCORE = 4;
    private static final byte HELP = 5;
    private static final byte UNDEF = 6;
    private byte state;
    public static final byte CLASSIC = 0;
    public static final byte ARCADE = 1;
    private int[] keyBuffer = new int[]{NONE, NONE};
    private byte[][] field;
    private SnakeTicker ticker;
    private byte gameType;
    private int score = 0;
    private char[] initials = new char[]{'A', 'A', 'A'};
    private int selectedInitial = 0;
    private Random rand = new Random(System.currentTimeMillis());
    private int defaultfieldcolor = 13100543;
    private int gameoverfieldcolor = 0xFF0000;
    private int fieldcolor = this.defaultfieldcolor;
    private BitmapFont bmfont;
    private String[] strMenus = new String[]{"Play", "Highscores", "Speed", "Help", "Quit"};
    private int selectedMenu = 0;
    private Snake main;
    private int increaseLength;
    private int speed;
    private int reverses;
    private int specialPos;
    private int specialMoves;
    private int specialFoods;
    private boolean playingDemo = false;
    private String[] hsNames = new String[]{"AAA", "AAA", "AAA"};
    private int[] hsScores = new int[]{0, 0, 0};
    private int lastScore = 0;

    public SnakeCanvas(Display display, byte by, Snake snake) {
        this.main = snake;
        this.display = display;
        this.paused = true;
        this.gameType = by;
        this.state = (byte)6;
        this.speed = 5;
        this.ticker = new SnakeTicker(2000L, this);
        try {
            char[][] cArrayArray = new char[][]{{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'}, {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'}, {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ',', '.', ':', '!', '?', '(', ')', '+', '=', '*', '/', '#', '@', '&', '-', '_'}};
            Image image = Image.createImage((String)"/system_8x14.png");
            this.bmfont = new BitmapFont(image, 8, 14, cArrayArray);
            this.s_head = new Sprite(Image.createImage((String)"/snake_head.png"));
            this.s_head.defineReferencePixel(4, 4);
            this.s_tail = new Sprite(Image.createImage((String)"/snake_tail.png"));
            this.s_tail.defineReferencePixel(4, 4);
            this.s_body = new Sprite(Image.createImage((String)"/snake_body.png"));
            this.s_body.defineReferencePixel(4, 4);
            this.s_body2 = new Sprite(Image.createImage((String)"/snake_body2.png"));
            this.s_body2.defineReferencePixel(4, 4);
            this.s_food = new Sprite(Image.createImage((String)"/food.png"));
            this.s_food.defineReferencePixel(4, 4);
            this.s_bonus = new Sprite(Image.createImage((String)"/bonus.png"));
            this.s_bonus.defineReferencePixel(4, 4);
            this.s_dead = new Sprite(Image.createImage((String)"/snake_dead.png"));
            this.s_dead.defineReferencePixel(4, 4);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while loading sprites.");
        }
    }

    public void alert(String string) {
        this.display.setCurrent(new Alert("Alert", string, null, AlertType.INFO), (Displayable)this);
    }

    public void redraw() {
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.setColor(0);
        graphics.fillRect(n, n2, n3, n4);
        this.buffer.setColor(0);
        this.buffer.fillRect(0, this.fieldHeight * 9, this.fieldWidth * 9, this.HEIGHT - this.fieldHeight * 9);
        if (this.playingDemo) {
            this.buffer.setColor(this.fieldcolor);
            this.buffer.fillRect(0, 0, this.WIDTH, this.HEIGHT - 30);
            ((SnakeElem)((Object)this.snake.elementAt(0))).draw(this.buffer);
            ((SnakeElem)((Object)this.snake.elementAt(this.snake.size() - 2))).draw(this.buffer);
            ((SnakeElem)((Object)this.snake.lastElement())).draw(this.buffer);
            this.buffer.setColor(0xBBBBBB);
            this.buffer.fillRect(0, this.HEIGHT - 11, this.WIDTH, 11);
        }
        if (this.state == 1) {
            this.buffer.setColor(0xFF0000);
            this.buffer.fillRect(0, 0, this.fieldWidth * 9, this.fieldHeight * 9);
            this.drawCompleteSnake();
            this.buffer.setColor(0xBBBBBB);
            this.buffer.fillRect(0, this.HEIGHT - 11, this.WIDTH, 11);
            this.bmfont.drawString("" + this.score, 0, this.HEIGHT - 12, this.buffer);
        } else if (this.state == 5) {
            String string = "1,3:      pause\n4,LEFT:   move left\n6,RIGHT:  move right\n8,UP:     move up\n5,2,DOWN: move down\n*:        turn left\n#:        turn right\n0:        reverse\n        (score -50!)";
            this.bmfont.drawString(string, 4, 40, this.buffer);
        } else if (this.state == 0) {
            this.buffer.setColor(this.fieldcolor);
            ((SnakeElem)((Object)this.snake.elementAt(0))).draw(this.buffer);
            ((SnakeElem)((Object)this.snake.elementAt(this.snake.size() - 2))).draw(this.buffer);
            ((SnakeElem)((Object)this.snake.lastElement())).draw(this.buffer);
            int n5 = 0;
            while (n5 < this.fieldWidth) {
                int n6 = 0;
                while (n6 < this.fieldHeight) {
                    byte by = this.field[n5][n6];
                    if (by != 0) {
                        if (by == 3) {
                            this.s_food.setRefPixelPosition(4 + n5 * 9, 4 + n6 * 9);
                            this.s_food.paint(this.buffer);
                        } else if (by == 4) {
                            this.s_bonus.setRefPixelPosition(4 + n5 * 9, 4 + n6 * 9);
                            this.s_bonus.paint(this.buffer);
                        } else if (this.DEBUG) {
                            this.s_dead.setRefPixelPosition(4 + n5 * 9, 4 + n6 * 9);
                            this.s_dead.paint(this.buffer);
                        }
                    }
                    ++n6;
                }
                ++n5;
            }
            this.buffer.setColor(0xBBBBBB);
            this.buffer.fillRect(0, this.HEIGHT - 11, this.WIDTH, 11);
            this.bmfont.drawString("" + this.score, 0, this.HEIGHT - 12, this.buffer);
            if (this.paused) {
                this.bmfont.drawString("paused", this.WIDTH - 49, this.HEIGHT - 12, this.buffer);
            } else {
                String string = "" + Math.max(this.score, this.hsScores[0]);
                this.bmfont.drawString(string, this.WIDTH - (1 + string.length() * 8), this.HEIGHT - 12, this.buffer);
            }
        } else if (this.state == 4) {
            String string = "You got a new\nHighscore! Enter\nyour initials\n\n   Score: " + this.lastScore;
            this.bmfont.drawString(string, 21, 10, this.buffer);
            String string2 = this.selectedInitial == 0 ? "&  " : (this.selectedInitial == 1 ? " & " : "  &");
            this.bmfont.drawString(String.valueOf(this.initials) + "\n" + string2, 73, 100, this.buffer);
        } else if (this.state == 2) {
            String string = "Highscores\n\n";
            int n7 = 0;
            while (n7 < this.hsScores.length) {
                string = string + this.hsNames[n7] + "    " + this.hsScores[n7] + "\n";
                ++n7;
            }
            string = string + "\nLast score\n" + this.lastScore;
            this.bmfont.drawString(string, 45, 30, this.buffer);
        } else if (this.state == 3) {
            String string = "   Snake 0.91\nTriBall software";
            this.bmfont.drawString(string, 21, 20, this.buffer);
            this.buffer.setColor(255);
            String string3 = "";
            int n8 = 0;
            while (n8 < this.strMenus.length) {
                string3 = n8 == this.selectedMenu ? (this.strMenus[n8].equals("Speed") ? string3 + "& " + this.strMenus[n8] + ": " + this.speed + "\n" : string3 + "@ " + this.strMenus[n8] + "\n") : (this.strMenus[n8].equals("Speed") ? string3 + "  " + this.strMenus[n8] + ": " + this.speed + "\n" : string3 + "  " + this.strMenus[n8] + "\n");
                ++n8;
            }
            this.bmfont.drawString(string3, 34, 80, this.buffer);
        } else if (this.state == 6) {
            this.buffer.setColor(0);
            this.buffer.fillRect(0, 0, this.fieldWidth * 9, this.fieldHeight * 9);
        }
        if (this.DEBUG) {
            this.bmfont.drawString("" + SnakeTicker.nrThreads, 60, this.HEIGHT - 12, this.buffer);
        }
        graphics.drawImage(this.bufferImage, n + (n3 - this.WIDTH) / 2, n2 + (n4 - this.HEIGHT) / 2, 0);
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (this.state == 0) {
            if (this.paused) {
                this.resume();
            } else if (n == 49 || n == 51) {
                this.pause();
                this.repaint();
                return;
            }
            if (this.keyBuffer[0] == NONE) {
                this.keyBuffer[0] = n;
            } else if (this.keyBuffer[1] == NONE) {
                this.keyBuffer[1] = n;
            } else {
                this.keyBuffer[0] = this.keyBuffer[1];
                this.keyBuffer[1] = n;
            }
        } else if (this.state == 1) {
            boolean bl = false;
            int n3 = 0;
            while (n3 < this.hsScores.length) {
                if (this.hsScores[n3] < this.score) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (bl) {
                this.selectedInitial = 0;
                this.buffer.setColor(this.fieldcolor);
                this.buffer.fillRect(0, 0, this.fieldWidth * 9, this.fieldHeight * 9);
                this.startDemo();
                this.state = (byte)4;
                this.repaint();
            } else {
                this.buffer.setColor(this.fieldcolor);
                this.buffer.fillRect(0, 0, this.fieldWidth * 9, this.fieldHeight * 9);
                this.startDemo();
                this.state = (byte)2;
                this.repaint();
            }
        } else if (this.state == 2) {
            this.startDemo();
            this.state = (byte)3;
            this.repaint();
        } else if (this.state == 5) {
            this.state = (byte)3;
            this.repaint();
        } else if (this.state == 4) {
            if (n2 == 1) {
                int n4 = this.selectedInitial;
                this.initials[n4] = (char)(this.initials[n4] + '\u0001');
                if (this.initials[this.selectedInitial] > 'Z') {
                    this.initials[this.selectedInitial] = 65;
                }
            } else if (n2 == 6) {
                int n5 = this.selectedInitial;
                this.initials[n5] = (char)(this.initials[n5] - '\u0001');
                if (this.initials[this.selectedInitial] < 'A') {
                    this.initials[this.selectedInitial] = 90;
                }
            } else if (n2 == 2) {
                --this.selectedInitial;
                if (this.selectedInitial < 0) {
                    this.selectedInitial = 2;
                }
            } else if (n2 == 5) {
                ++this.selectedInitial;
                if (this.selectedInitial > 2) {
                    this.selectedInitial = 0;
                }
            } else if (n2 == 8) {
                this.hsScores[this.hsScores.length - 1] = this.lastScore;
                this.hsNames[this.hsNames.length - 1] = String.valueOf(this.initials);
                int n6 = this.hsNames.length - 2;
                while (n6 >= 0) {
                    if (this.hsScores[n6 + 1] > this.hsScores[n6]) {
                        int n7 = this.hsScores[n6];
                        String string = this.hsNames[n6];
                        this.hsScores[n6] = this.hsScores[n6 + 1];
                        this.hsNames[n6] = this.hsNames[n6 + 1];
                        this.hsScores[n6 + 1] = n7;
                        this.hsNames[n6 + 1] = string;
                    }
                    --n6;
                }
                this.state = (byte)2;
            }
            this.repaint();
        } else if (this.state == 3) {
            if (n2 == 1) {
                --this.selectedMenu;
                if (this.selectedMenu < 0) {
                    this.selectedMenu = this.strMenus.length - 1;
                }
            } else if (n2 == 6) {
                ++this.selectedMenu;
                if (this.selectedMenu >= this.strMenus.length) {
                    this.selectedMenu = 0;
                }
            }
            if (this.strMenus[this.selectedMenu].equals("Speed")) {
                if (n2 == 2) {
                    --this.speed;
                    if (this.speed < 1) {
                        this.speed = 9;
                    }
                } else if (n2 == 5) {
                    ++this.speed;
                    if (this.speed > 9) {
                        this.speed = 1;
                    }
                }
                this.setSpeed(this.speed);
            }
            if (n2 == 8) {
                String string = this.strMenus[this.selectedMenu];
                if (string.equals("Quit")) {
                    this.saveData();
                    this.destroy();
                    this.main.exit();
                } else if (string.equals("Highscores")) {
                    this.state = (byte)2;
                } else if (string.equals("Play")) {
                    this.stopDemo();
                    this.state = 0;
                    this.restart();
                } else if (string.equals("Help")) {
                    this.state = (byte)5;
                }
            }
            this.repaint();
        }
    }

    public void tick() {
        int n = this.keyBuffer[0];
        if (n == 1 || n == 50 || n == -1) {
            this.step((byte)1);
        } else if (n == 5 || n == 54 || n == -4) {
            this.step((byte)2);
        } else if (n == 6 || n == 56 || n == 53 || n == -2) {
            this.step((byte)3);
        } else if (n == 2 || n == 52 || n == -3) {
            this.step((byte)4);
        } else if (n == 48) {
            this.reverse();
        } else if (n == 35) {
            byte by = (byte)(((SnakeElem)((Object)this.snake.lastElement())).getDirection() + 1);
            if (by == 5) {
                by = 1;
            }
            this.step(by);
        } else if (n == 42) {
            byte by = (byte)(((SnakeElem)((Object)this.snake.lastElement())).getDirection() - 1);
            if (by == 0) {
                by = 4;
            }
            this.step(by);
        } else {
            this.step(((SnakeElem)((Object)this.snake.lastElement())).getDirection());
        }
        this.keyBuffer[0] = this.keyBuffer[1];
        this.keyBuffer[1] = NONE;
    }

    private void step(byte by) {
        if (this.state != 0 && !this.playingDemo) {
            return;
        }
        SnakeElem snakeElem = (SnakeElem)((Object)this.snake.lastElement());
        byte by2 = snakeElem.getDirection();
        if (by == 1 && by2 == 3 || by == 2 && by2 == 4 || by == 3 && by2 == 1 || by == 4 && by2 == 2) {
            by = by2;
        }
        SnakeElem snakeElem2 = (SnakeElem)((Object)this.snake.elementAt(this.snake.size() - 2));
        SnakeElem snakeElem3 = (SnakeElem)((Object)this.snake.elementAt(0));
        SnakeElem snakeElem4 = null;
        SnakeElem snakeElem5 = null;
        if (by == 1) {
            switch (by2) {
                case 1: {
                    snakeElem4 = new SnakeElem(this.s_body, snakeElem.getPosX(), snakeElem.getPosY(), 1, 0);
                    break;
                }
                case 2: {
                    snakeElem4 = new SnakeElem(this.s_body2, snakeElem.getPosX(), snakeElem.getPosY(), 1, 3);
                    break;
                }
                case 4: {
                    snakeElem4 = new SnakeElem(this.s_body2, snakeElem.getPosX(), snakeElem.getPosY(), 1, 6);
                }
            }
            snakeElem5 = new SnakeElem(this.s_head, snakeElem.getPosX(), (snakeElem.getPosY() - 1 + this.fieldHeight) % this.fieldHeight, 1, 0);
        } else if (by == 2) {
            switch (by2) {
                case 1: {
                    snakeElem4 = new SnakeElem(this.s_body2, snakeElem.getPosX(), snakeElem.getPosY(), 2, 0);
                    break;
                }
                case 2: {
                    snakeElem4 = new SnakeElem(this.s_body, snakeElem.getPosX(), snakeElem.getPosY(), 2, 5);
                    break;
                }
                case 3: {
                    snakeElem4 = new SnakeElem(this.s_body2, snakeElem.getPosX(), snakeElem.getPosY(), 2, 6);
                }
            }
            snakeElem5 = new SnakeElem(this.s_head, (snakeElem.getPosX() + 1) % this.fieldWidth, snakeElem.getPosY(), 2, 5);
        } else if (by == 3) {
            switch (by2) {
                case 2: {
                    snakeElem4 = new SnakeElem(this.s_body2, snakeElem.getPosX(), snakeElem.getPosY(), 3, 5);
                    break;
                }
                case 3: {
                    snakeElem4 = new SnakeElem(this.s_body, snakeElem.getPosX(), snakeElem.getPosY(), 3, 0);
                    break;
                }
                case 4: {
                    snakeElem4 = new SnakeElem(this.s_body2, snakeElem.getPosX(), snakeElem.getPosY(), 3, 0);
                }
            }
            snakeElem5 = new SnakeElem(this.s_head, snakeElem.getPosX(), (snakeElem.getPosY() + 1) % this.fieldHeight, 3, 3);
        } else {
            switch (by2) {
                case 1: {
                    snakeElem4 = new SnakeElem(this.s_body2, snakeElem.getPosX(), snakeElem.getPosY(), 4, 5);
                    break;
                }
                case 3: {
                    snakeElem4 = new SnakeElem(this.s_body2, snakeElem.getPosX(), snakeElem.getPosY(), 4, 3);
                    break;
                }
                case 4: {
                    snakeElem4 = new SnakeElem(this.s_body, snakeElem.getPosX(), snakeElem.getPosY(), 4, 5);
                }
            }
            snakeElem5 = new SnakeElem(this.s_head, (snakeElem.getPosX() - 1 + this.fieldWidth) % this.fieldWidth, snakeElem.getPosY(), 4, 6);
        }
        this.field[snakeElem3.getPosX()][snakeElem3.getPosY()] = 0;
        byte by3 = this.field[snakeElem5.getPosX()][snakeElem5.getPosY()];
        if (by3 == 1) {
            this.state = 1;
            this.fieldcolor = this.gameoverfieldcolor;
            this.ticker.stop();
            SnakeElem snakeElem6 = new SnakeElem(this.s_dead, snakeElem.getPosX(), snakeElem.getPosY(), snakeElem.getDirection(), snakeElem.getTransform());
            this.snake.removeElement((Object)snakeElem);
            this.snake.addElement(snakeElem6);
            this.lastScore = this.score;
            this.repaint();
            return;
        }
        this.snake.addElement(snakeElem4);
        if (this.specialMoves < 25) {
            ++this.specialMoves;
            if (this.specialMoves >= 25 && this.specialPos != -1) {
                this.field[this.specialPos % this.fieldWidth][this.specialPos / this.fieldWidth] = 0;
                this.buffer.setColor(this.fieldcolor);
                this.buffer.fillRect(this.specialPos % this.fieldWidth * 9, this.specialPos / this.fieldWidth * 9, 9, 9);
                this.specialPos = -1;
                this.specialFoods = 0;
            }
        }
        if (by3 == 3) {
            this.score += this.speed;
            ++this.increaseLength;
            this.field[snakeElem3.getPosX()][snakeElem3.getPosY()] = 1;
            this.putInRandomCell((byte)3);
            ++this.specialFoods;
            if (this.specialFoods >= 5 && this.specialPos == -1) {
                this.specialPos = this.putInRandomCell((byte)4);
                this.specialMoves = 0;
            }
        } else if (by3 == 4 && this.specialMoves < 25) {
            this.score += (24 - this.specialMoves) * this.speed;
            this.specialPos = -1;
            this.specialFoods = 0;
        }
        if (this.increaseLength == 0) {
            this.snake.removeElementAt(0);
            SnakeElem snakeElem7 = (SnakeElem)((Object)this.snake.elementAt(0));
            SnakeElem snakeElem8 = null;
            by2 = snakeElem7.getDirection();
            switch (by2) {
                case 1: {
                    snakeElem8 = new SnakeElem(this.s_tail, snakeElem7.getPosX(), snakeElem7.getPosY(), snakeElem7.getDirection(), 0);
                    break;
                }
                case 2: {
                    snakeElem8 = new SnakeElem(this.s_tail, snakeElem7.getPosX(), snakeElem7.getPosY(), snakeElem7.getDirection(), 5);
                    break;
                }
                case 3: {
                    snakeElem8 = new SnakeElem(this.s_tail, snakeElem7.getPosX(), snakeElem7.getPosY(), snakeElem7.getDirection(), 3);
                    break;
                }
                case 4: {
                    snakeElem8 = new SnakeElem(this.s_tail, snakeElem7.getPosX(), snakeElem7.getPosY(), snakeElem7.getDirection(), 6);
                }
            }
            this.snake.removeElementAt(0);
            this.snake.insertElementAt(snakeElem8, 0);
            this.buffer.setColor(this.fieldcolor);
            snakeElem3.erase(this.buffer);
        } else {
            --this.increaseLength;
        }
        this.snake.removeElement((Object)snakeElem);
        this.snake.addElement(snakeElem5);
        this.field[snakeElem5.getPosX()][snakeElem5.getPosY()] = 1;
        this.repaint();
    }

    private void reverse() {
        Vector<SnakeElem> vector = new Vector<SnakeElem>();
        while (this.snake.size() > 0) {
            SnakeElem snakeElem = (SnakeElem)((Object)this.snake.lastElement());
            int n = this.snake.size() > 1 ? (int)((SnakeElem)((Object)this.snake.elementAt(this.snake.size() - 2))).getDirection() : snakeElem.getDirection();
            n = n == 1 ? 3 : (n == 2 ? 4 : (n == 3 ? 1 : 2));
            snakeElem.setDirection((byte)n);
            vector.addElement(snakeElem);
            this.snake.removeElement((Object)snakeElem);
        }
        this.snake = vector;
        this.score -= 50;
        if (this.score < 0) {
            this.score = 0;
        }
    }

    private int putInRandomCell(byte by) {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        int n2 = 0;
        while (n2 < this.fieldWidth) {
            n = 0;
            while (n < this.fieldHeight) {
                if (this.field[n2][n] == 0) {
                    vector.addElement(new Integer(n2 + n * this.fieldWidth));
                }
                ++n;
            }
            ++n2;
        }
        n = (Integer)vector.elementAt(Math.abs(this.rand.nextInt()) % vector.size());
        this.field[n % this.fieldWidth][n / this.fieldWidth] = by;
        return n;
    }

    public void destroy() {
        this.snake.removeAllElements();
        this.ticker.stop();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause() {
        this.paused = true;
        this.ticker.stop();
    }

    public void resume() {
        if (this.state == 0 || this.playingDemo) {
            this.ticker.start();
            this.repaint();
            this.paused = false;
        }
    }

    private void drawCompleteSnake() {
        this.buffer.setColor(this.fieldcolor);
        int n = 0;
        while (n < this.snake.size()) {
            ((SnakeElem)((Object)this.snake.elementAt(n))).draw(this.buffer);
            ++n;
        }
    }

    private void initField() {
        this.field = new byte[this.fieldWidth][this.fieldHeight];
        int n = this.fieldHeight - 1;
        this.snake.removeAllElements();
        this.snake.addElement(new SnakeElem(this.s_tail, 1, n, 2, 5));
        this.snake.addElement(new SnakeElem(this.s_body, 2, n, 2, 5));
        this.snake.addElement(new SnakeElem(this.s_body, 3, n, 2, 5));
        this.snake.addElement(new SnakeElem(this.s_body, 4, n, 2, 5));
        this.snake.addElement(new SnakeElem(this.s_head, 5, n, 2, 5));
        this.field[1][n] = 1;
        this.field[2][n] = 1;
        this.field[3][n] = 1;
        this.field[4][n] = 1;
        this.field[5][n] = 1;
        if (this.state == 0) {
            this.putInRandomCell((byte)3);
        }
        this.score = 0;
        this.reverses = 0;
        this.fieldcolor = this.defaultfieldcolor;
        this.specialPos = -1;
    }

    public void restart() {
        this.destroy();
        this.pause();
        this.initField();
        this.start();
    }

    private void setSpeed(int n) {
        this.ticker.setDelay((10 - n) * 30 + 80);
    }

    public void showmenu() {
        this.loadData();
        this.state = (byte)3;
        this.startDemo();
        this.repaint();
    }

    public void startDemo() {
        if (!this.playingDemo) {
            this.playingDemo = true;
            this.restart();
        }
    }

    public void stopDemo() {
        if (this.playingDemo) {
            this.destroy();
            this.playingDemo = false;
        }
    }

    public void start() {
        if (this.paused) {
            this.specialPos = -1;
            this.specialFoods = 0;
            this.keyBuffer[0] = NONE;
            this.keyBuffer[1] = NONE;
            this.increaseLength = 0;
            this.buffer.setColor(0);
            this.buffer.fillRect(0, 0, this.WIDTH, this.HEIGHT);
            this.buffer.setColor(this.fieldcolor);
            this.buffer.fillRect(0, 0, this.fieldWidth * 9, this.fieldHeight * 9);
            this.initField();
            this.drawCompleteSnake();
            this.repaint();
            this.setSpeed(this.speed);
            this.ticker.start();
            this.paused = false;
        }
    }

    private String bytesToString(byte[] byArray) {
        String string = "";
        int n = 0;
        while (n < byArray.length) {
            string = string + (char)byArray[n];
            ++n;
        }
        return string;
    }

    public void loadData() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"Snake", (boolean)true);
            if (recordStore.getNumRecords() == 3 + this.hsNames.length * 2) {
                byte[] byArray = recordStore.getRecord(1);
                this.speed = byArray[0];
                byArray = recordStore.getRecord(2);
                this.lastScore = byArray[0];
                this.lastScore += byArray[1] << 8;
                byArray = recordStore.getRecord(3);
                this.initials[0] = (char)byArray[0];
                this.initials[1] = (char)byArray[1];
                this.initials[2] = (char)byArray[2];
                int n = 0;
                while (n < this.hsNames.length) {
                    this.hsNames[n] = this.bytesToString(recordStore.getRecord(4 + 2 * n));
                    byArray = recordStore.getRecord(5 + 2 * n);
                    this.hsScores[n] = byArray[0];
                    int n2 = n++;
                    this.hsScores[n2] = this.hsScores[n2] + (byArray[1] << 8);
                }
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            this.alert("Cannot load data: " + exception.toString());
        }
    }

    public void saveData() {
        try {
            byte[] byArray;
            RecordStore recordStore = RecordStore.openRecordStore((String)"Snake", (boolean)true);
            while (recordStore.getNumRecords() < 3 + this.hsNames.length * 2) {
                byArray = new byte[1];
                recordStore.addRecord(byArray, 0, 1);
            }
            byArray = new byte[]{(byte)this.speed};
            recordStore.setRecord(1, byArray, 0, 1);
            byte[] byArray2 = new byte[]{(byte)this.lastScore, (byte)(this.lastScore >> 8)};
            recordStore.setRecord(2, byArray2, 0, 2);
            byte[] byArray3 = new byte[]{(byte)this.initials[0], (byte)this.initials[1], (byte)this.initials[2]};
            recordStore.setRecord(3, byArray3, 0, 3);
            int n = 0;
            while (n < this.hsNames.length) {
                recordStore.setRecord(4 + 2 * n, this.hsNames[n].getBytes(), 0, 3);
                byte[] byArray4 = new byte[]{(byte)this.hsScores[n], (byte)(this.hsScores[n] >> 8)};
                recordStore.setRecord(5 + 2 * n, byArray4, 0, 2);
                ++n;
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            this.alert("Cannot sava data: " + exception.toString());
        }
    }
}

