/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class CFrontend
extends Canvas {
    public final int FRONTEND_QUIT;
    public final int FRONTEND_IFONE;
    public final int FRONTEND_ATARI;
    public final int FRONTEND_MAIN;
    public final int FRONTEND_NAME;
    public final int FRONTEND_RANK;
    public final int FRONTEND_SPLASH;
    public int iFrontendState = 3;
    public Image m_ifone = null;
    public Image m_atari = null;
    public Image m_splash = null;
    public Image m_logo = null;
    public Image m_menu = null;
    public Image m_play = null;
    public Image m_selector = null;
    public Image m_Select = null;
    public Image m_Quit = null;
    public int m_iOption = 0;
    public boolean bDebounce = false;
    public boolean bDrawFrontend = true;
    public boolean bStart = true;
    public boolean bPaint = true;
    public final int IFONE_TIME;
    public final int ATARI_TIME;
    public final int SPLASH_TIME;
    public long IntroTimer;
    public byte[] gScoreTable = null;
    public static final int NAME_SIZE = 3;
    public static final int SCORE_SIZE = 7;
    public static final int ENTRY_SIZE = 10;
    public static final int NUM_ENTRY = 10;
    public static final int TABLE_SIZE = 100;
    public static final String FILE_NAME = "_BREAKOUT_HS";
    public int iSERow = 0;
    public int iSECol = 0;
    public char[] cNameEntry = new char[3];
    public int iNumLetters = 0;
    boolean bNameFull = false;
    private Font gameFont = Font.getFont((int)64, (int)0, (int)8);
    public int iBorderL = 5;
    public int iBorderR = 5;
    public int iBorderT = 22;
    public int iScreenW = 120;
    public int iScreenH = 160;

    public CFrontend() {
        this.FRONTEND_QUIT = 0;
        this.FRONTEND_IFONE = 1;
        this.FRONTEND_ATARI = 2;
        this.FRONTEND_MAIN = 3;
        this.FRONTEND_NAME = 4;
        this.FRONTEND_RANK = 5;
        this.FRONTEND_SPLASH = 6;
        this.IFONE_TIME = 2000;
        this.ATARI_TIME = 4000;
        this.SPLASH_TIME = 8000;
        this.LoadSplash();
        this.LoadFrontendArt();
    }

    public void LoadSplash() {
        try {
            this.m_ifone = Image.createImage((String)"/iFone.png");
            this.m_atari = Image.createImage((String)"/atari.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void UnloadLoadSplash() {
        this.m_ifone = null;
        this.m_atari = null;
    }

    public void LoadFrontendArt() {
        try {
            this.m_logo = Image.createImage((String)"/logo.png");
            this.m_menu = Image.createImage((String)"/menu.png");
            this.m_play = Image.createImage((String)"/play.png");
            this.m_selector = Image.createImage((String)"/selector.png");
            this.m_Select = Image.createImage((String)"/select.png");
            this.m_Quit = Image.createImage((String)"/quit.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void RunFrontend() {
        Breakout.display.setCurrent((Displayable)this);
        this.bDrawFrontend = true;
        this.IntroTimer = System.currentTimeMillis();
        if (this.bStart) {
            this.iFrontendState = 1;
            this.bStart = false;
        } else if (this.iFrontendState != 4 && this.iFrontendState != 6) {
            this.iFrontendState = 3;
        }
        while (this.iFrontendState != 0) {
            long l;
            if (this.iFrontendState == 1) {
                l = System.currentTimeMillis();
                if (l - this.IntroTimer > 2000L) {
                    this.IntroTimer = System.currentTimeMillis();
                    this.iFrontendState = 2;
                    this.LoadData();
                }
            } else if (this.iFrontendState == 2) {
                l = System.currentTimeMillis();
                if (l - this.IntroTimer > 4000L) {
                    this.IntroTimer = System.currentTimeMillis();
                    this.iFrontendState = 3;
                }
            } else if (this.iFrontendState == 6 && (l = System.currentTimeMillis()) - this.IntroTimer > 8000L) {
                this.IntroTimer = System.currentTimeMillis();
                this.iFrontendState = 3;
            }
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.iFrontendState == 1) {
            graphics.fillRect(0, 0, 120, 160);
            graphics.drawImage(this.m_ifone, 0, 0, 20);
        } else if (this.iFrontendState == 2) {
            graphics.fillRect(0, 0, 120, 160);
            graphics.drawImage(this.m_atari, 0, 0, 20);
        } else if (this.iFrontendState == 3) {
            if (this.bDrawFrontend) {
                graphics.setColor(0);
                graphics.fillRect(0, 0, 120, 160);
                graphics.drawImage(this.m_logo, 12, 13, 20);
                if (this.m_iOption == 0) {
                    graphics.drawImage(this.m_selector, 30, 87, 20);
                } else {
                    graphics.drawImage(this.m_selector, 30, 112, 20);
                }
                graphics.drawImage(this.m_play, 45, 92, 20);
                graphics.drawImage(this.m_menu, 42, 118, 20);
                graphics.drawImage(this.m_Quit, 2, 146, 20);
                graphics.drawImage(this.m_Select, 103, 146, 20);
                this.bDrawFrontend = false;
            }
        } else if (this.iFrontendState == 4) {
            if (this.bPaint) {
                this.DrawNameEntry(graphics);
                this.bPaint = false;
            }
        } else if (this.iFrontendState == 5) {
            this.DrawRanking(graphics);
        } else if (this.iFrontendState == 6) {
            graphics.fillRect(0, 0, 120, 160);
            graphics.drawImage(this.m_splash, 0, 0, 20);
        }
    }

    private void draw(String string, int n, int n2, Graphics graphics) {
        graphics.drawString(string, n, n2, 20);
    }

    public void DrawRanking(Graphics graphics) {
        int n;
        graphics.setFont(this.gameFont);
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.iScreenW, this.iScreenH);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("OK", this.iScreenW - 26, this.iScreenH - 12, 20);
        graphics.drawString("RANKING", this.iScreenW / 2 - this.gameFont.stringWidth("RANKING") / 2, 5, 20);
        if (Breakout.Game.bComplete) {
            graphics.drawString("CONGRATULATIONS", this.iScreenW / 2 - this.gameFont.stringWidth("CONGRATULATIONS") / 2, 20, 20);
        }
        if ((n = Breakout.Game.iRank) == 0) {
            graphics.drawString("1st", 5, this.iScreenH / 2 - 5, 20);
        } else if (n == 1) {
            graphics.drawString("2nd", 5, this.iScreenH / 2 - 5, 20);
        } else if (n == 2) {
            graphics.drawString("3rd", 5, this.iScreenH / 2 - 5, 20);
        } else if (n == 3) {
            graphics.drawString("4th", 5, this.iScreenH / 2 - 5, 20);
        } else if (n == 4) {
            graphics.drawString("5th", 5, this.iScreenH / 2 - 5, 20);
        } else if (n == 5) {
            graphics.drawString("6th", 5, this.iScreenH / 2 - 5, 20);
        } else if (n == 6) {
            graphics.drawString("7th", 5, this.iScreenH / 2 - 5, 20);
        } else if (n == 7) {
            graphics.drawString("8th", 5, this.iScreenH / 2 - 5, 20);
        } else if (n == 8) {
            graphics.drawString("9th", 5, this.iScreenH / 2 - 5, 20);
        } else if (n == 9) {
            graphics.drawString("10th", 5, this.iScreenH / 2 - 5, 20);
        }
        String string = new String(this.cNameEntry, 0, 3);
        graphics.drawString(string, 33, this.iScreenH / 2 - 5, 20);
        String string2 = Integer.toString(Breakout.Game.iScore);
        graphics.drawString(string2, 60, this.iScreenH / 2 - 5, 20);
    }

    public void DrawNameEntry(Graphics graphics) {
        graphics.setFont(this.gameFont);
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.iScreenW, this.iScreenH);
        graphics.setColor(0xFFFFFF);
        int n = 30;
        int n2 = 30;
        int n3 = 4;
        int n4 = 30 + n2;
        int n5 = 14;
        int n6 = this.iScreenW / 9;
        int n7 = this.gameFont.stringWidth("Enter Your Name");
        graphics.drawString("Enter Your Name", this.iScreenW / 2 - n7 / 2 - 5, 10, 20);
        String string = new String(this.cNameEntry, 0, this.iNumLetters);
        graphics.drawString(string, this.iScreenW / 2 - n / 2 + 5, n2 + 5, 20);
        graphics.drawRect(n3 + n6 / 2, n4 - 5, n6 * 7 + n6 / 2, n5 * 4 + 5 + 20);
        this.draw("A", n3 + n6 + n6 * 0, n4, graphics);
        this.draw("B", n3 + n6 + n6 * 1, n4, graphics);
        this.draw("C", n3 + n6 + n6 * 2, n4, graphics);
        this.draw("D", n3 + n6 + n6 * 3, n4, graphics);
        this.draw("E", n3 + n6 + n6 * 4, n4, graphics);
        this.draw("F", n3 + n6 + n6 * 5, n4, graphics);
        this.draw("G", n3 + n6 + n6 * 6, n4, graphics);
        this.draw("H", n3 + n6 + n6 * 0, n4 + n5, graphics);
        this.draw("I", n3 + n6 + n6 * 1, n4 + n5, graphics);
        this.draw("J", n3 + n6 + n6 * 2, n4 + n5, graphics);
        this.draw("K", n3 + n6 + n6 * 3, n4 + n5, graphics);
        this.draw("L", n3 + n6 + n6 * 4, n4 + n5, graphics);
        this.draw("M", n3 + n6 + n6 * 5, n4 + n5, graphics);
        this.draw("N", n3 + n6 + n6 * 6, n4 + n5, graphics);
        this.draw("O", n3 + n6 + n6 * 0, n4 + n5 * 2, graphics);
        this.draw("P", n3 + n6 + n6 * 1, n4 + n5 * 2, graphics);
        this.draw("Q", n3 + n6 + n6 * 2, n4 + n5 * 2, graphics);
        this.draw("R", n3 + n6 + n6 * 3, n4 + n5 * 2, graphics);
        this.draw("S", n3 + n6 + n6 * 4, n4 + n5 * 2, graphics);
        this.draw("T", n3 + n6 + n6 * 5, n4 + n5 * 2, graphics);
        this.draw("U", n3 + n6 + n6 * 6, n4 + n5 * 2, graphics);
        this.draw("V", n3 + n6 + n6 * 0, n4 + n5 * 3, graphics);
        this.draw("W", n3 + n6 + n6 * 1, n4 + n5 * 3, graphics);
        this.draw("X", n3 + n6 + n6 * 2, n4 + n5 * 3, graphics);
        this.draw("Y", n3 + n6 + n6 * 3, n4 + n5 * 3, graphics);
        this.draw("Z", n3 + n6 + n6 * 4, n4 + n5 * 3, graphics);
        this.draw(",", n3 + n6 + n6 * 5, n4 + n5 * 3, graphics);
        this.draw(".", n3 + n6 + n6 * 6, n4 + n5 * 3, graphics);
        this.draw("!", n3 + n6 + n6 * 0, n4 + n5 * 4, graphics);
        this.draw("*", n3 + n6 + n6 * 1, n4 + n5 * 4, graphics);
        this.draw("&", n3 + n6 + n6 * 2, n4 + n5 * 4, graphics);
        this.draw("@", n3 + n6 + n6 * 3, n4 + n5 * 4, graphics);
        this.draw("#", n3 + n6 + n6 * 4, n4 + n5 * 4, graphics);
        this.draw("END", n3 + n6 + n6 * 5, n4 + n5 * 4, graphics);
        int n8 = n3 + n6 + n6 * this.iSERow;
        int n9 = n4 + n5 * this.iSECol;
        if (this.iSECol == 4 && this.iSERow == 5) {
            graphics.drawRect(n8 - 2, n9 - 2, 24, 13);
        } else {
            graphics.drawRect(n8 - 2, n9 - 2, 10, 13);
        }
        graphics.drawString("DEL", 2, this.iScreenH - 12, 20);
        graphics.drawString("OK", this.iScreenW - (this.gameFont.stringWidth("OK") + 1), this.iScreenH - 12, 20);
    }

    public void keyPressed(int n) {
        if (this.bDebounce) {
            return;
        }
        int n2 = 0;
        try {
            n2 = this.getGameAction(n);
            if (this.iFrontendState == 3) {
                if (n2 == 1) {
                    if (this.m_iOption == 0) {
                        this.m_iOption = 1;
                    } else if (this.m_iOption == 1) {
                        this.m_iOption = 0;
                    }
                    this.bDrawFrontend = true;
                    this.bDebounce = true;
                } else if (n2 == 6) {
                    if (this.m_iOption == 0) {
                        this.m_iOption = 1;
                    } else if (this.m_iOption == 1) {
                        this.m_iOption = 0;
                    }
                    this.bDrawFrontend = true;
                    this.bDebounce = true;
                } else if (n == -21) {
                    if (this.m_iOption == 0) {
                        this.iFrontendState = 0;
                        Breakout.iAppState = 2;
                    } else {
                        this.iFrontendState = 0;
                        Breakout.iAppState = 3;
                    }
                } else if (n == -20) {
                    this.iFrontendState = 0;
                    Breakout.iAppState = 0;
                }
            } else if (this.iFrontendState == 4) {
                this.DoNameInput(n, n2);
            } else if (this.iFrontendState == 5 && n == -21) {
                this.cNameEntry[0] = 32;
                this.cNameEntry[1] = 32;
                this.cNameEntry[2] = 32;
                this.iNumLetters = 0;
                this.bNameFull = false;
                this.iSERow = 0;
                this.iSECol = 0;
                this.bDebounce = true;
                this.iFrontendState = 3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyReleased(int n) {
        this.bDebounce = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void LoadData() {
        RecordStore recordStore = null;
        try {
            try {
                this.gScoreTable = new byte[100];
                recordStore = RecordStore.openRecordStore((String)FILE_NAME, (boolean)false);
                recordStore.getRecord(1, this.gScoreTable, 0);
                recordStore.closeRecordStore();
                return;
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                try {
                    recordStore = RecordStore.openRecordStore((String)FILE_NAME, (boolean)true);
                    this.populateTable();
                    recordStore.addRecord(this.gScoreTable, 0, 100);
                    recordStore.closeRecordStore();
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
                return;
            }
        }
        catch (Throwable throwable) {
            recordStore = null;
            throw throwable;
        }
    }

    private boolean save() {
        RecordStore recordStore = null;
        boolean bl = false;
        try {
            try {
                recordStore = RecordStore.openRecordStore((String)FILE_NAME, (boolean)false);
                recordStore.setRecord(1, this.gScoreTable, 0, 100);
                recordStore.closeRecordStore();
                bl = true;
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                try {
                    recordStore = RecordStore.openRecordStore((String)FILE_NAME, (boolean)true);
                    int n = recordStore.addRecord(this.gScoreTable, 0, 100);
                    recordStore.setRecord(1, this.gScoreTable, 0, 100);
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreNotFoundException recordStoreNotFoundException2) {
                    recordStoreNotFoundException.printStackTrace();
                }
                catch (RecordStoreFullException recordStoreFullException) {
                    recordStoreNotFoundException.printStackTrace();
                }
                catch (RecordStoreException recordStoreException) {
                    recordStoreNotFoundException.printStackTrace();
                }
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        recordStore = null;
        System.gc();
        return bl;
    }

    public void SaveScore() {
        String string = new String(this.cNameEntry, 0, this.iNumLetters);
        this.insertEntry(Breakout.Game.iRank, Breakout.Game.iScore, string);
    }

    private void populateTable() {
        int n = 0;
        int n2 = 0;
        while (n2 < 10) {
            byte[] byArray = "             ".getBytes();
            if (n2 == 0) {
                byArray = "P H           ".getBytes();
            } else if (n2 == 1) {
                byArray = "GHL           ".getBytes();
            } else if (n2 == 2) {
                byArray = "ADE           ".getBytes();
            } else if (n2 == 3) {
                byArray = "HIP           ".getBytes();
            } else if (n2 == 4) {
                byArray = "HOP           ".getBytes();
            } else if (n2 == 5) {
                byArray = "DOL           ".getBytes();
            } else if (n2 == 6) {
                byArray = "END           ".getBytes();
            } else if (n2 == 7) {
                byArray = "TIM           ".getBytes();
            } else if (n2 == 8) {
                byArray = "MOR           ".getBytes();
            } else if (n2 == 9) {
                byArray = "PET           ".getBytes();
            }
            System.arraycopy(byArray, 0, this.gScoreTable, n, 3);
            this.putScore(n2, 200 - n2 * 20);
            n += 10;
            ++n2;
        }
    }

    private void putScore(int n, int n2) {
        int n3 = n * 10 + 3;
        int n4 = n3 + 7 - 1;
        while (n4 >= n3) {
            this.gScoreTable[n4--] = (byte)(48 + n2 % 10);
            n2 /= 10;
        }
    }

    public int getScore(int n) {
        int n2 = n * 10 + 3;
        int n3 = 7;
        int n4 = 0;
        while (n3-- > 0) {
            n4 = n4 * 10 + (this.gScoreTable[n2++] - 48);
        }
        return n4;
    }

    private void insertEntry(int n, int n2, String string) {
        int n3 = n * 10;
        if (n < 10) {
            int n4 = (10 - n) * 10 - 10;
            System.arraycopy(this.gScoreTable, n3, this.gScoreTable, n3 + 10, n4);
        }
        byte[] byArray = (string + "           ").getBytes();
        System.arraycopy(byArray, 0, this.gScoreTable, n3, 3);
        this.putScore(n, n2);
        this.save();
    }

    public void DoNameInput(int n, int n2) {
        if (!this.bNameFull) {
            if (n == 54 || n2 == 5) {
                if (this.iSERow == 5 && this.iSECol == 4) {
                    this.iSERow = 0;
                } else {
                    ++this.iSERow;
                    if (this.iSERow >= 7) {
                        this.iSERow = 0;
                    }
                }
                this.bPaint = true;
                this.bDebounce = true;
            } else if (n == 52 || n2 == 2) {
                if (this.iSERow == 0 && this.iSECol == 4) {
                    this.iSERow = 5;
                } else {
                    --this.iSERow;
                    if (this.iSERow < 0) {
                        this.iSERow = 6;
                    }
                }
                this.bPaint = true;
                this.bDebounce = true;
            } else if (n == 56 || n2 == 6) {
                if (this.iSERow == 5 && this.iSECol == 3 || this.iSERow == 6 && this.iSECol == 3) {
                    this.iSERow = 5;
                    this.iSECol = 4;
                } else {
                    ++this.iSECol;
                    if (this.iSECol >= 5) {
                        this.iSECol = 0;
                    }
                }
                this.bPaint = true;
                this.bDebounce = true;
            } else if (n == 50 || n2 == 1) {
                if (this.iSERow == 6 && this.iSECol == 0) {
                    this.iSERow = 5;
                    this.iSECol = 4;
                } else {
                    --this.iSECol;
                    if (this.iSECol < 0) {
                        this.iSECol = 4;
                    }
                }
                this.bPaint = true;
                this.bDebounce = true;
            }
            if (n == -20) {
                this.cNameEntry[this.iNumLetters - 1] = 32;
                --this.iNumLetters;
                if (this.iNumLetters < 0) {
                    this.iNumLetters = 0;
                }
                this.bPaint = true;
                this.bDebounce = true;
            } else if (n == -21) {
                if (!this.bNameFull) {
                    ++this.iNumLetters;
                    if (this.iSECol == 0) {
                        if (this.iSERow == 0) {
                            this.cNameEntry[this.iNumLetters - 1] = 65;
                        } else if (this.iSERow == 1) {
                            this.cNameEntry[this.iNumLetters - 1] = 66;
                        } else if (this.iSERow == 2) {
                            this.cNameEntry[this.iNumLetters - 1] = 67;
                        } else if (this.iSERow == 3) {
                            this.cNameEntry[this.iNumLetters - 1] = 68;
                        } else if (this.iSERow == 4) {
                            this.cNameEntry[this.iNumLetters - 1] = 69;
                        } else if (this.iSERow == 5) {
                            this.cNameEntry[this.iNumLetters - 1] = 70;
                        } else if (this.iSERow == 6) {
                            this.cNameEntry[this.iNumLetters - 1] = 71;
                        }
                    } else if (this.iSECol == 1) {
                        if (this.iSERow == 0) {
                            this.cNameEntry[this.iNumLetters - 1] = 72;
                        } else if (this.iSERow == 1) {
                            this.cNameEntry[this.iNumLetters - 1] = 73;
                        } else if (this.iSERow == 2) {
                            this.cNameEntry[this.iNumLetters - 1] = 74;
                        } else if (this.iSERow == 3) {
                            this.cNameEntry[this.iNumLetters - 1] = 75;
                        } else if (this.iSERow == 4) {
                            this.cNameEntry[this.iNumLetters - 1] = 76;
                        } else if (this.iSERow == 5) {
                            this.cNameEntry[this.iNumLetters - 1] = 77;
                        } else if (this.iSERow == 6) {
                            this.cNameEntry[this.iNumLetters - 1] = 78;
                        }
                    } else if (this.iSECol == 2) {
                        if (this.iSERow == 0) {
                            this.cNameEntry[this.iNumLetters - 1] = 79;
                        } else if (this.iSERow == 1) {
                            this.cNameEntry[this.iNumLetters - 1] = 80;
                        } else if (this.iSERow == 2) {
                            this.cNameEntry[this.iNumLetters - 1] = 81;
                        } else if (this.iSERow == 3) {
                            this.cNameEntry[this.iNumLetters - 1] = 82;
                        } else if (this.iSERow == 4) {
                            this.cNameEntry[this.iNumLetters - 1] = 83;
                        } else if (this.iSERow == 5) {
                            this.cNameEntry[this.iNumLetters - 1] = 84;
                        } else if (this.iSERow == 6) {
                            this.cNameEntry[this.iNumLetters - 1] = 85;
                        }
                    } else if (this.iSECol == 3) {
                        if (this.iSERow == 0) {
                            this.cNameEntry[this.iNumLetters - 1] = 86;
                        } else if (this.iSERow == 1) {
                            this.cNameEntry[this.iNumLetters - 1] = 87;
                        } else if (this.iSERow == 2) {
                            this.cNameEntry[this.iNumLetters - 1] = 88;
                        } else if (this.iSERow == 3) {
                            this.cNameEntry[this.iNumLetters - 1] = 89;
                        } else if (this.iSERow == 4) {
                            this.cNameEntry[this.iNumLetters - 1] = 90;
                        } else if (this.iSERow == 5) {
                            this.cNameEntry[this.iNumLetters - 1] = 44;
                        } else if (this.iSERow == 6) {
                            this.cNameEntry[this.iNumLetters - 1] = 46;
                        }
                    } else if (this.iSECol == 4) {
                        if (this.iSERow == 0) {
                            this.cNameEntry[this.iNumLetters - 1] = 33;
                        } else if (this.iSERow == 1) {
                            this.cNameEntry[this.iNumLetters - 1] = 42;
                        } else if (this.iSERow == 2) {
                            this.cNameEntry[this.iNumLetters - 1] = 38;
                        } else if (this.iSERow == 3) {
                            this.cNameEntry[this.iNumLetters - 1] = 64;
                        } else if (this.iSERow == 4) {
                            this.cNameEntry[this.iNumLetters - 1] = 35;
                        } else if (this.iSERow == 5) {
                            this.bPaint = true;
                            this.iFrontendState = 5;
                            this.SaveScore();
                            this.bDebounce = true;
                            return;
                        }
                    }
                    if (this.iNumLetters >= 3) {
                        this.bNameFull = true;
                        this.iSECol = 4;
                        this.iSERow = 5;
                    }
                }
                this.bDebounce = true;
                this.bPaint = true;
            }
        } else {
            if (n == -20) {
                this.cNameEntry[this.iNumLetters - 1] = 32;
                --this.iNumLetters;
                this.bNameFull = false;
                this.bPaint = true;
                this.bDebounce = true;
            }
            if (n == -21) {
                this.iFrontendState = 5;
                this.SaveScore();
                this.bPaint = true;
                this.bDebounce = true;
                return;
            }
        }
    }
}

