/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class Blackjack
extends MIDlet
implements CommandListener {
    private Command againCommand;
    private Command dealCommand;
    private Command standCommand;
    private Command hitCommand;
    private Command quitCommand;
    private Command yesCommand;
    private Command noCommand;
    private Command exitCommand;
    private Command startCommand;
    private Display display;
    private MainScreen mainscreen;
    private ScoreScreen scorescreen;
    private TitleScreen titlescreen;
    private Image heart;
    private Image diamond;
    private Image spade;
    private Image club;
    private Image back;
    private Image title;
    private final int fwidth;
    private final int fheight;
    private static int width;
    private static int height;
    private static int ox;
    private static int oy;
    private static int hcenter;
    private final Font fp = Font.getFont((int)64, (int)0, (int)0);
    private final Font fb = Font.getFont((int)64, (int)1, (int)0);
    private final Font fs = Font.getFont((int)64, (int)0, (int)8);
    private final int BET;
    private final int INSURANCE;
    private final int PLAYERTURN;
    private final int DEALERTURN;
    private final int WIN;
    private final int LOSE;
    private final int PUSHM;
    private final int BUSTED;
    private final int SPADES;
    private final int DIAMONDS;
    private final int CLUBS;
    private final int HEARTS;
    private final String[] cardRank = new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "J", "Q", "K", "A"};
    private final int[] cardVal = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 10, 10, 10, 11};
    private final int BLACKJACK;
    private final int HIGH;
    private final int PUSH;
    private final int LGREEN;
    private final int DGREEN;
    private final int RED;
    private final int ORANGE;
    private final int YELLOW;
    private final int WHITE;
    private final int BLACK;
    private int bank;
    private int bet;
    private int insbet;
    private int[][] dealerHand = new int[5][2];
    private int[][] playerHand = new int[5][2];
    private int dealerHandLen = 0;
    private int playerHandLen = 0;
    private int[] dealerScore = new int[2];
    private int[] playerScore = new int[2];
    private String dealerScoreStr = "";
    private String playerScoreStr = "";
    private int finalDealerScore = 0;
    private int finalPlayerScore = 0;
    private int[][] deck = new int[52][2];
    private int[][] currentDeck = new int[10][2];
    private Random shuffle = new Random();
    private Pauser pauser;
    private boolean[] dealerShown = new boolean[5];
    private boolean[] playerShown = new boolean[5];
    private int dealno;
    private boolean dealing;
    private boolean ins;
    private int mode;
    private int modifier;
    private String message;
    private int hpos;
    private int[] tempcard;
    private int card;
    private int[][] temphand;
    private Image cardimg;
    private int tempscore;
    private int aces;

    public Blackjack() {
        this.fwidth = 96;
        this.fheight = 100;
        this.BET = 0;
        this.INSURANCE = 1;
        this.PLAYERTURN = 2;
        this.DEALERTURN = 3;
        this.WIN = 4;
        this.LOSE = 5;
        this.PUSHM = 6;
        this.BUSTED = 7;
        this.SPADES = 0;
        this.DIAMONDS = 1;
        this.CLUBS = 2;
        this.HEARTS = 3;
        this.BLACKJACK = 10;
        this.HIGH = 2;
        this.PUSH = 1;
        this.LGREEN = 47872;
        this.DGREEN = 25600;
        this.RED = 0xFF0000;
        this.ORANGE = 16748800;
        this.YELLOW = 0xFFFF00;
        this.WHITE = 0xFFFFFF;
        this.BLACK = 0;
        this.display = Display.getDisplay((MIDlet)this);
        this.mainscreen = new MainScreen();
        this.scorescreen = new ScoreScreen();
        this.titlescreen = new TitleScreen();
        width = this.mainscreen.getWidth();
        height = this.mainscreen.getHeight();
        ox = (width - 96) / 2;
        oy = (height - 100) / 2;
        hcenter = width / 2;
        try {
            this.heart = Image.createImage((String)"/heart.png");
            this.spade = Image.createImage((String)"/spade.png");
            this.club = Image.createImage((String)"/club.png");
            this.diamond = Image.createImage((String)"/diamond.png");
            this.back = Image.createImage((String)"/back.png");
            this.title = Image.createImage((String)"/blackjacktitle.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.againCommand = new Command("Again", 1, 1);
        this.dealCommand = new Command("Deal", 1, 1);
        this.standCommand = new Command("Stand", 1, 1);
        this.hitCommand = new Command("Hit", 1, 1);
        this.exitCommand = new Command("Exit", 7, 1);
        this.yesCommand = new Command("Yes", 1, 1);
        this.noCommand = new Command("No", 1, 1);
        this.startCommand = new Command("Start", 1, 1);
        this.quitCommand = new Command("Quit", 1, 1);
        this.initGame();
    }

    public void startApp() throws MIDletStateChangeException {
        this.display.setCurrent((Displayable)this.titlescreen);
        this.addBeginCommands();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean bl) {
    }

    public void rp() {
        this.mainscreen.repaint();
    }

    private void initGame() {
        this.bank = 20;
        this.bet = 1;
        this.initDeck();
        this.initRound();
    }

    private void initDeck() {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < 13) {
                this.deck[n][0] = n2;
                this.deck[n][1] = n3++;
                ++n;
            }
            ++n2;
        }
    }

    private void initRound() {
        this.shuffleDeck();
        int n = 0;
        while (n < 4) {
            this.playerHand[n][0] = -1;
            this.playerHand[n][1] = -1;
            this.dealerHand[n][0] = -1;
            this.dealerHand[n][1] = -1;
            this.playerShown[n] = false;
            this.dealerShown[n] = false;
            ++n;
        }
        this.dealerScore[1] = 0;
        this.dealerScore[0] = 0;
        this.playerScore[1] = 0;
        this.playerScore[0] = 0;
        this.dealerScoreStr = "";
        this.playerScoreStr = "";
        this.playerHandLen = 0;
        this.dealerHandLen = 0;
        this.dealing = false;
        this.modifier = 0;
        this.mode = 0;
        this.bet = 1;
        this.insbet = 0;
        this.ins = false;
        this.message = "";
    }

    private void endGame() {
        this.updateCash();
        this.removePlayCommands();
        this.addEndCommands();
        this.rp();
    }

    private int[][] dealCards(int n) {
        this.temphand = new int[n][2];
        int n2 = 0;
        while (n2 < n) {
            this.temphand[n2][0] = this.currentDeck[0][0];
            this.temphand[n2][1] = this.currentDeck[0][1];
            int n3 = 1;
            while (n3 < 10) {
                this.currentDeck[n3 - 1] = this.currentDeck[n3];
                ++n3;
            }
            ++n2;
        }
        return this.temphand;
    }

    private void shuffleDeck() {
        int n = this.deck.length;
        this.currentDeck = new int[10][2];
        int[] nArray = new int[10];
        int n2 = 0;
        while (n2 < 10) {
            do {
                this.card = Math.abs(this.shuffle.nextInt()) % n;
            } while (this.getOcc(nArray, this.card) > 0);
            this.currentDeck[n2][0] = this.deck[this.card][0];
            this.currentDeck[n2][1] = this.deck[this.card][1];
            nArray[n2] = this.card;
            ++n2;
        }
    }

    private int getOcc(int[] nArray, int n) {
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            if (nArray[n4] == n) {
                ++n2;
            }
            ++n4;
        }
        return n2;
    }

    private void deal() {
        this.mode = 2;
        try {
            this.removeStartCommands();
            this.addPlayCommands();
            this.temphand = this.dealCards(4);
            int n = 0;
            int n2 = this.playerHandLen;
            while (n2 < 5) {
                if (n < this.temphand.length) {
                    this.dealerHand[n2][0] = this.temphand[n][0];
                    this.dealerHand[n2][1] = this.temphand[n][1];
                    this.playerHand[n2][0] = this.temphand[n + 1][0];
                    this.playerHand[n2][1] = this.temphand[n + 1][1];
                    n += 2;
                } else {
                    this.dealerHand[n2][0] = -1;
                    this.dealerHand[n2][1] = -1;
                    this.playerHand[n2][0] = -1;
                    this.playerHand[n2][1] = -1;
                }
                ++n2;
            }
            this.dealerShown[0] = true;
            this.dealerShown[1] = false;
            this.playerShown[0] = false;
            this.playerShown[1] = false;
            this.playerHandLen = 2;
            this.dealerHandLen = 2;
            this.dealing = true;
            this.pauser = new Pauser(1);
            this.pauser.start();
            this.rp();
        }
        catch (Exception exception) {
            this.db("ex: deal command\n" + exception);
        }
    }

    private void hit() {
        this.mode = 2;
        try {
            this.temphand = this.dealCards(1);
            this.playerHand[this.playerHandLen][0] = this.temphand[0][0];
            this.playerHand[this.playerHandLen][1] = this.temphand[0][1];
            ++this.playerHandLen;
        }
        catch (Exception exception) {
            this.db("ex: hit command\n" + exception);
        }
        this.dealing = true;
        this.pauser = new Pauser(1);
        this.pauser.start();
        this.rp();
    }

    private void stand() {
        this.doDealerTurn();
    }

    private void yes() {
        this.mode = 2;
        this.insbet = this.bet / 2;
        this.insbet = this.insbet < 1 ? 1 : this.insbet;
        this.removeConfirmCommands();
        this.addPlayCommands();
        this.rp();
    }

    private void no() {
        this.mode = 2;
        this.insbet = 0;
        this.removeConfirmCommands();
        this.addPlayCommands();
        this.rp();
    }

    private void again() {
        if (this.mode == 7) {
            this.initGame();
        } else {
            this.initRound();
            if (this.bank - this.bet < 0) {
                this.bet = this.bank;
                this.bank = 0;
            } else {
                this.bank -= this.bet;
            }
        }
        this.removeEndCommands();
        this.addStartCommands();
        this.rp();
    }

    private void start() {
        this.removeBeginCommands();
        this.initGame();
        this.display.setCurrent((Displayable)this.mainscreen);
        this.addStartCommands();
    }

    private void quit() {
        this.display.setCurrent((Displayable)this.titlescreen);
        this.removeEndCommands();
        this.addBeginCommands();
    }

    private void exit() {
        this.pauser = null;
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    private void checkPlayerScore() {
        this.playerScore = this.calcScore(this.playerHand, this.playerHandLen);
        this.playerScoreStr = this.getScoreStr(this.playerScore);
        if ((this.playerScore[0] == 21 || this.playerScore[1] == 21) && this.playerHandLen == 2) {
            this.mode = 4;
            this.modifier = 10;
            this.message = "Blackjack!";
            this.endGame();
        } else if ((this.playerScore[0] == 21 || this.playerScore[1] == 21) && this.playerHandLen > 2) {
            this.playerScoreStr = this.playerScore[2] + "";
            this.doDealerTurn();
        } else if (this.playerScore[0] == 0 && this.playerScore[1] == 0) {
            this.playerScoreStr = this.playerScore[2] + "";
            this.mode = 5;
            this.message = "Busted!";
            this.endGame();
        } else if (this.playerHandLen == 5) {
            this.playerScoreStr = this.playerScore[2] + "";
            this.doDealerTurn();
        }
        this.rp();
    }

    private void checkDealerScore() {
        this.dealerScore = this.calcScore(this.dealerHand, this.dealerHandLen);
        this.dealerScoreStr = this.getScoreStr(this.dealerScore);
        if ((this.dealerScore[0] == 21 || this.dealerScore[1] == 21) && this.dealerHandLen == 2 && this.finalPlayerScore != 21) {
            this.mode = 5;
            this.message = "Blackjack!";
            if (this.insbet > 0) {
                this.bank += this.bet - this.bet / 2;
                this.checkForSkint();
            }
            this.endGame();
        } else if ((this.dealerScore[0] == 21 || this.dealerScore[1] == 21) && this.dealerHandLen > 2) {
            this.dealerScoreStr = this.dealerScore[2] + "";
            this.checkForWinner();
        } else if (this.dealerScore[0] == 0 && this.dealerScore[1] == 0) {
            this.dealerScoreStr = this.dealerScore[2] + "";
            this.mode = 4;
            this.modifier = 2;
            this.message = "Dealer Bust!";
            this.endGame();
        } else if (this.dealerScore[0] > this.finalPlayerScore && this.dealerScore[0] < 21 || this.dealerScore[1] > this.finalPlayerScore && this.dealerScore[1] < 21) {
            this.dealerScoreStr = this.dealerScore[2] + "";
            this.mode = 5;
            this.message = "You Lose!";
            this.endGame();
        } else if (this.dealerScore[0] >= 17 || this.dealerScore[1] >= 17) {
            this.dealerScoreStr = this.dealerScore[2] + "";
            this.checkForWinner();
        } else if (this.dealerHandLen == 5) {
            this.dealerScoreStr = this.dealerScore[2] + "";
            this.checkForWinner();
        }
        this.rp();
    }

    private void checkForWinner() {
        this.finalDealerScore = this.getFScore(this.dealerScore);
        this.dealerScoreStr = this.finalDealerScore + "";
        if (this.finalPlayerScore > this.finalDealerScore) {
            this.mode = 4;
            this.modifier = 2;
            this.message = "Win!";
        } else if (this.finalDealerScore > this.finalPlayerScore) {
            this.mode = 5;
            this.message = "You Lose!";
        } else {
            this.mode = 6;
            this.modifier = 1;
            this.message = "Push!";
        }
        this.endGame();
    }

    private int[] calcScore(int[][] nArray, int n) {
        this.tempscore = 0;
        int[] nArray2 = new int[3];
        nArray2[2] = 0;
        nArray2[1] = 0;
        nArray2[0] = 0;
        this.aces = 0;
        int n2 = 0;
        while (n2 < n) {
            if (this.cardVal[nArray[n2][1]] == 11) {
                ++this.aces;
            } else {
                this.tempscore += this.cardVal[nArray[n2][1]];
            }
            ++n2;
        }
        if (this.aces == 0) {
            nArray2[0] = this.tempscore;
            nArray2[1] = 0;
        } else {
            nArray2[0] = this.tempscore + 11 + (this.aces - 1);
            int n3 = 0;
            while (n3 < this.aces) {
                nArray2[1] = this.tempscore + n3 + 1;
                ++n3;
            }
        }
        nArray2[2] = nArray2[0] >= nArray2[1] && (nArray2[0] < 22 || nArray2[1] == 0) ? nArray2[0] : nArray2[1];
        nArray2[0] = this.checkValidScore(nArray2[0]);
        nArray2[1] = this.checkValidScore(nArray2[1]);
        if (nArray2[0] == 21) {
            nArray2[1] = 0;
        } else if (nArray2[1] == 21) {
            nArray2[0] = 0;
        }
        return nArray2;
    }

    private String getScoreStr(int[] nArray) {
        if (nArray[0] != 0 && nArray[1] != 0) {
            return nArray[0] + " or " + nArray[1];
        }
        return nArray[2] + "";
    }

    private int getFScore(int[] nArray) {
        if (nArray[0] != 0) {
            if (nArray[0] > nArray[1]) {
                return nArray[0];
            }
            return nArray[1];
        }
        return nArray[1];
    }

    private int checkValidScore(int n) {
        if (n > 21) {
            return 0;
        }
        return n;
    }

    private void updateCash() {
        this.bank += this.bet * this.modifier;
        this.checkForSkint();
    }

    private void checkForSkint() {
        if (this.bank < 1) {
            this.bank = 0;
            this.bet = 0;
            this.mode = 7;
            this.mainscreen.addCommand(this.againCommand);
        }
        this.rp();
    }

    private void doDealerTurn() {
        this.mode = 3;
        this.removePlayCommands();
        this.finalPlayerScore = this.getFScore(this.playerScore);
        this.playerScoreStr = this.finalPlayerScore + "";
        this.dealing = true;
        this.pauser = new Pauser(4);
        this.pauser.start();
        this.rp();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.againCommand) {
            this.again();
        } else if (command == this.dealCommand) {
            this.deal();
        } else if (command == this.hitCommand) {
            this.hit();
        } else if (command == this.standCommand) {
            this.stand();
        } else if (command == this.yesCommand) {
            this.yes();
        } else if (command == this.noCommand) {
            this.no();
        } else if (command == this.quitCommand) {
            this.quit();
        } else if (command == this.startCommand) {
            this.start();
        } else if (command == this.exitCommand) {
            this.exit();
        }
    }

    private void removeConfirmCommands() {
        this.mainscreen.removeCommand(this.yesCommand);
        this.mainscreen.removeCommand(this.noCommand);
    }

    private void addConfirmCommands() {
        this.mainscreen.addCommand(this.yesCommand);
        this.mainscreen.addCommand(this.noCommand);
    }

    private void removePlayCommands() {
        this.mainscreen.removeCommand(this.hitCommand);
        this.mainscreen.removeCommand(this.standCommand);
    }

    private void addPlayCommands() {
        this.mainscreen.addCommand(this.hitCommand);
        this.mainscreen.addCommand(this.standCommand);
    }

    private void removeStartCommands() {
        this.mainscreen.removeCommand(this.quitCommand);
        this.mainscreen.removeCommand(this.dealCommand);
    }

    private void addStartCommands() {
        this.mainscreen.addCommand(this.dealCommand);
        this.mainscreen.addCommand(this.quitCommand);
        this.mainscreen.setCommandListener(this);
    }

    private void removeEndCommands() {
        this.mainscreen.removeCommand(this.quitCommand);
        this.mainscreen.removeCommand(this.againCommand);
    }

    private void addEndCommands() {
        this.mainscreen.addCommand(this.againCommand);
        this.mainscreen.addCommand(this.quitCommand);
    }

    private void removeBeginCommands() {
        this.titlescreen.removeCommand(this.exitCommand);
        this.titlescreen.removeCommand(this.startCommand);
    }

    private void addBeginCommands() {
        this.titlescreen.addCommand(this.startCommand);
        this.titlescreen.addCommand(this.exitCommand);
        this.titlescreen.setCommandListener(this);
    }

    private void dbCards(int[][] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.db(n + ": " + nArray[n][0] + "," + nArray[n][1]);
            ++n;
        }
    }

    private void dbScore() {
        this.db("playerHandLen: " + this.playerHandLen + "\tdealerHandLen: " + this.dealerHandLen);
        int n = 0;
        while (n < 5) {
            this.db(n + "\t " + this.playerShown[n] + "\t" + this.dealerShown[n]);
            ++n;
        }
    }

    public void db(String string) {
        System.out.println(string);
    }

    static /* synthetic */ int[][] access$302(Blackjack blackjack, int[][] nArray) {
        blackjack.temphand = nArray;
        return nArray;
    }

    static /* synthetic */ boolean[] access$202(Blackjack blackjack, boolean[] blArray) {
        blackjack.playerShown = blArray;
        return blArray;
    }

    static /* synthetic */ boolean[] access$702(Blackjack blackjack, boolean[] blArray) {
        blackjack.dealerShown = blArray;
        return blArray;
    }

    class TitleScreen
    extends Canvas {
        private final int width = this.getWidth();
        private final int height = this.getHeight();
        private int hcenter;
        private int x;

        TitleScreen() {
        }

        public void paint(Graphics graphics) {
            graphics.setColor(25600);
            graphics.fillRect(0, 0, this.width, this.height);
            graphics.setFont(Blackjack.this.fs);
            this.hcenter = this.width / 2;
            graphics.drawImage(Blackjack.this.title, ox, oy + 5, 20);
            graphics.setColor(0xFFFFFF);
            graphics.fillRoundRect(ox + 12, oy + 22, 72, 19, 3, 3);
            this.x = ox + 16;
            graphics.drawImage(Blackjack.this.heart, this.x, oy + 24, 20);
            graphics.drawImage(Blackjack.this.spade, this.x + 16, oy + 24, 20);
            graphics.drawImage(Blackjack.this.diamond, this.x + 32, oy + 24, 20);
            graphics.drawImage(Blackjack.this.club, this.x + 48, oy + 24, 20);
            graphics.setColor(47872);
            graphics.fillRoundRect(ox + 2, oy + 81, 92, 16, 3, 3);
            graphics.setColor(0xFFFF00);
            graphics.drawString("Press Fire to", this.hcenter, oy + 50, 17);
            graphics.drawString("view scoring", this.hcenter, oy + 60, 17);
            graphics.drawString("www.zeroindex.co.uk", this.hcenter, oy + 81, 17);
        }

        public void keyPressed(int n) {
            int n2 = this.getGameAction(n);
            if (n2 == 8) {
                Blackjack.this.display.setCurrent((Displayable)Blackjack.this.scorescreen);
            }
        }
    }

    class ScoreScreen
    extends Canvas {
        private int x1;
        private int x2;
        private int y;

        ScoreScreen() {
        }

        public void paint(Graphics graphics) {
            graphics.setColor(25600);
            graphics.fillRect(0, 0, width, height);
            graphics.setColor(47872);
            graphics.fillRoundRect(ox + 2, oy + 2, 92, 96, 8, 8);
            graphics.setColor(0xFFFFFF);
            this.x1 = ox + 6;
            this.x2 = ox + 96 - 4;
            this.y = oy + 1;
            graphics.drawString("Blackjack", this.x1, this.y, 20);
            graphics.drawString("High", this.x1, this.y + 10, 20);
            graphics.drawString("Push", this.x1, this.y + 20, 20);
            graphics.drawString("A", this.x1, this.y + 35, 20);
            graphics.drawString("K,Q,J,10", this.x1, this.y + 45, 20);
            graphics.drawString("9-2", this.x1, this.y + 55, 20);
            graphics.drawString("Insurance", this.x1, this.y + 70, 20);
            graphics.drawString("Dealer stand", this.x1, this.y + 80, 20);
            graphics.setColor(0xFFFF00);
            graphics.drawString("x10", this.x2, this.y, 24);
            graphics.drawString("x2", this.x2, this.y + 10, 24);
            graphics.drawString("x1", this.x2, this.y + 20, 24);
            graphics.drawString("11 or 1", this.x2, this.y + 35, 24);
            graphics.drawString("10", this.x2, this.y + 45, 24);
            graphics.drawString("9-2", this.x2, this.y + 55, 24);
            graphics.drawString("2:1", this.x2, this.y + 70, 24);
            graphics.drawString("17", this.x2, this.y + 80, 24);
            graphics.setColor(25600);
            graphics.drawLine(this.x1, this.y + 35, this.x2, this.y + 35);
            graphics.drawLine(this.x1, this.y + 70, this.x2, this.y + 70);
        }

        public void keyPressed(int n) {
            int n2 = this.getGameAction(n);
            if (n2 == 8) {
                Blackjack.this.display.setCurrent((Displayable)Blackjack.this.titlescreen);
            }
        }
    }

    class MainScreen
    extends Canvas {
        MainScreen() {
        }

        public void paint(Graphics graphics) {
            try {
                graphics.setColor(25600);
                graphics.fillRect(0, 0, width, height);
                graphics.setColor(47872);
                graphics.fillRoundRect(ox + 2, oy + 3, 92, 36, 3, 3);
                graphics.fillRoundRect(ox + 2, oy + 42, 92, 36, 3, 3);
                graphics.fillRoundRect(ox + 2, oy + 81, 92, 16, 3, 3);
                graphics.setFont(Blackjack.this.fp);
                graphics.setColor(39168);
                graphics.drawString("Dealer", hcenter, oy + 14, 17);
                graphics.drawString("You", hcenter, oy + 53, 17);
                this.drawHand(graphics, Blackjack.this.dealerHand, Blackjack.this.dealerHandLen, Blackjack.this.dealerShown, oy + 6);
                this.drawHand(graphics, Blackjack.this.playerHand, Blackjack.this.playerHandLen, Blackjack.this.playerShown, oy + 45);
                if (Blackjack.this.dealing) {
                    this.paintMessage(graphics, 0xFFFFFF, 47872, "");
                } else if (Blackjack.this.mode == 0) {
                    graphics.setFont(Blackjack.this.fp);
                    this.paintMessage(graphics, 0xFFFFFF, 47872, "Place Bet");
                    graphics.setFont(Blackjack.this.fp);
                    graphics.setColor(0xFFFF00);
                    graphics.drawString("$" + Blackjack.this.bank, ox + 3, oy + 81, 20);
                    graphics.setColor(0xFF0000);
                    graphics.drawString("$" + Blackjack.this.bet, ox + 96 - 3, oy + 81, 24);
                } else if (Blackjack.this.mode == 2 || Blackjack.this.mode == 3) {
                    this.paintScores(graphics, 0xFFFFFF, 0xFFFFFF);
                } else if (Blackjack.this.mode == 1) {
                    this.paintMessage(graphics, 0, 0xFFFF00, Blackjack.this.message);
                } else if (Blackjack.this.mode == 4) {
                    this.paintMessage(graphics, 0, 0xFFFF00, Blackjack.this.message);
                    this.paintScores(graphics, 0xFF0000, 0);
                } else if (Blackjack.this.mode == 5) {
                    this.paintMessage(graphics, 0, 16748800, Blackjack.this.message);
                    this.paintScores(graphics, 0, 0xFF0000);
                } else if (Blackjack.this.mode == 6) {
                    this.paintMessage(graphics, 0, 16748800, Blackjack.this.message);
                    this.paintScores(graphics, 0xFFFFFF, 0xFFFFFF);
                } else if (Blackjack.this.mode == 7) {
                    this.paintMessage(graphics, 0xFFFFFF, 0xFF0000, "Busted!");
                    this.paintScores(graphics, 0xFF0000, 0xFFFFFF);
                }
            }
            catch (Exception exception) {
                Blackjack.this.db("Exception in mainscreen paint:\n" + exception);
            }
        }

        private void drawHand(Graphics graphics, int[][] nArray, int n, boolean[] blArray, int n2) {
            graphics.setFont(Blackjack.this.fp);
            Blackjack.this.hpos = ox + 4;
            int n3 = 0;
            while (n3 < n) {
                if (nArray != null) {
                    graphics.setColor(0xFFFFFF);
                    Blackjack.this.cardimg = this.getCardImage(nArray, n3);
                    if (Blackjack.this.cardimg != null) {
                        if (blArray[n3]) {
                            this.drawCard(graphics, Blackjack.this.cardimg, Blackjack.this.hpos, n2);
                            graphics.setColor(0);
                            graphics.drawString(Blackjack.this.cardRank[nArray[n3][1]], Blackjack.this.hpos + 8, n2 + 16, 17);
                        } else {
                            this.drawCard(graphics, Blackjack.this.back, Blackjack.this.hpos, n2);
                        }
                    }
                }
                Blackjack.this.hpos += 18;
                ++n3;
            }
        }

        private void drawCard(Graphics graphics, Image image, int n, int n2) {
            graphics.fillRoundRect(n, n2, 16, 30, 3, 3);
            graphics.drawImage(image, n + 1, n2 + 1, 20);
        }

        private void paintScores(Graphics graphics, int n, int n2) {
            graphics.setColor(n);
            graphics.drawString(Blackjack.this.playerScoreStr, ox + 96 - 4, oy + 81, 24);
            graphics.setColor(n2);
            graphics.drawString(Blackjack.this.dealerScoreStr, ox + 4, oy + 81, 20);
        }

        private void paintMessage(Graphics graphics, int n, int n2, String string) {
            graphics.setColor(n2);
            graphics.fillRoundRect(ox + 2, oy + 81, 92, 16, 3, 3);
            graphics.setColor(n);
            graphics.drawString(string, hcenter, oy + 81, 17);
        }

        public void keyPressed(int n) {
            int n2 = this.getGameAction(n);
            if (n2 == 1 && Blackjack.this.mode == 0) {
                if (Blackjack.this.bet + 1 < 51 && Blackjack.this.bank - 1 > -1) {
                    Blackjack.this.bet += 1;
                    Blackjack.this.bank -= 1;
                    this.repaint();
                }
            } else if (n2 == 6 && Blackjack.this.mode == 0 && Blackjack.this.bet - 1 > 0) {
                Blackjack.this.bet -= 1;
                Blackjack.this.bank += 1;
                this.repaint();
            }
        }

        private Image getCardImage(int[][] nArray, int n) {
            Blackjack.this.cardimg = null;
            if (nArray[n][0] == 3) {
                Blackjack.this.cardimg = Blackjack.this.heart;
            } else if (nArray[n][0] == 0) {
                Blackjack.this.cardimg = Blackjack.this.spade;
            } else if (nArray[n][0] == 1) {
                Blackjack.this.cardimg = Blackjack.this.diamond;
            } else if (nArray[n][0] == 2) {
                Blackjack.this.cardimg = Blackjack.this.club;
            }
            return Blackjack.this.cardimg;
        }
    }

    class Pauser
    extends Thread {
        private int iterations;
        private int handLen;
        private boolean[] shown;

        public Pauser(int n) {
            this.iterations = n;
        }

        public void run() {
            int n = 0;
            while (n < this.iterations) {
                if (Blackjack.this.mode == 2 || Blackjack.this.mode == 0 || Blackjack.this.mode == 5) {
                    this.handLen = Blackjack.this.playerHandLen;
                    this.shown = Blackjack.this.playerShown;
                } else if (Blackjack.this.mode == 3) {
                    if (n > 0) {
                        Blackjack.access$302(Blackjack.this, Blackjack.this.dealCards(1));
                        ((Blackjack)Blackjack.this).dealerHand[((Blackjack)Blackjack.this).dealerHandLen][0] = Blackjack.this.temphand[0][0];
                        ((Blackjack)Blackjack.this).dealerHand[((Blackjack)Blackjack.this).dealerHandLen][1] = Blackjack.this.temphand[0][1];
                        Blackjack.this.dealerHandLen++;
                        this.pause(500L);
                    }
                    this.handLen = Blackjack.this.dealerHandLen;
                    this.shown = Blackjack.this.dealerShown;
                }
                int n2 = 0;
                while (n2 < this.handLen) {
                    Blackjack.this.rp();
                    if (!this.shown[n2]) {
                        this.pause(350L);
                    }
                    this.shown[n2] = true;
                    Blackjack.this.rp();
                    ++n2;
                }
                Blackjack.this.dealing = false;
                if (Blackjack.this.mode == 0) {
                    Blackjack.access$202(Blackjack.this, this.shown);
                    Blackjack.this.mainscreen.addCommand(Blackjack.this.dealCommand);
                    Blackjack.this.rp();
                } else if (Blackjack.this.mode == 2) {
                    Blackjack.access$202(Blackjack.this, this.shown);
                    Blackjack.this.checkPlayerScore();
                    Blackjack.this.rp();
                } else if (Blackjack.this.mode == 3) {
                    this.pause(500L);
                    Blackjack.access$702(Blackjack.this, this.shown);
                    Blackjack.this.checkDealerScore();
                    Blackjack.this.rp();
                }
                ++n;
            }
            if (Blackjack.this.dealerHand[0][1] == 12 && !Blackjack.this.ins) {
                Blackjack.this.mode = 1;
                Blackjack.this.message = "Insurance?";
                Blackjack.this.removePlayCommands();
                Blackjack.this.addConfirmCommands();
                Blackjack.this.ins = true;
            }
        }

        private void pause(long l) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

