// Video Poker v1.0 by Marcel Timm (mantillo), 14oct2001

// Parts of source code of the following programs were
// used to build this Rex 6000 addin:
// - Schnauz for Rex 6000 B0.7 by Alex Poplawski -
// - poker.java by Anthony F. Ortiz -
// Many thanks to you for your help ;-)

#include <rex/rex.h>
#include <stdlib.h>

#define NO_CARDS 52
#define CARD_LENGTH 29
#define CARD_WIDTH 21
#define MESSAGE_TIME 60
#define ROUNDS 99	// not over 99!!!
#define CASH_START 50	// in US-Doller ;----)

#include "bmps.h"

char cards[NO_CARDS];
char faceup[5];
char cardname[]={"23456789TJQKA"};
int a;
int round;
int cash;
int bet;
int win;

int get_result(void){
	int i,result,c;
	int cardsuit[5];
	int facecount[13];
	int suitcount[4];
	int flags2[7];

	for(i=0;i<13;i++)
		facecount[i]=0;

	for(i=0;i<4;i++)
		suitcount[i]=0;

	for(i=0;i<7;i++)
		flags2[i]=0;

	for(i=0;i<5;i++)	//gets suits of the 5 cards (0,1,2,or 3)
		cardsuit[i]=cards[i]/13;


	for(i=0;i<5;i++){	//counts faces and suit of the 5 cards
		switch(cards[i]%13){
			case 0:
				facecount[0]=facecount[0]+1;
				break;
			case 1:
				facecount[1]=facecount[1]+1;
				break;
			case 2:
				facecount[2]=facecount[2]+1;
				break;
			case 3:
				facecount[3]=facecount[3]+1;
				break;
			case 4:
				facecount[4]=facecount[4]+1;
				break;			
			case 5:
				facecount[5]=facecount[5]+1;
				break;
			case 6:
				facecount[6]=facecount[6]+1;
				break;
			case 7:
				facecount[7]=facecount[7]+1;
				break;
			case 8:
				facecount[8]=facecount[8]+1;
				break;			
			case 9:
				facecount[9]=facecount[9]+1;
				break;
			case 10:
				facecount[10]=facecount[10]+1;
				break;
			case 11:
				facecount[11]=facecount[11]+1;
				break;
			case 12:
				facecount[12]=facecount[12]+1;
				break;
		}

		switch(cardsuit[i]){
			case 0:
				suitcount[0]=suitcount[0]+1;
				break;
			case 1:
				suitcount[1]=suitcount[1]+1;
				break;
			case 2:
				suitcount[2]=suitcount[2]+1;
				break;
			case 3:
				suitcount[3]=suitcount[3]+1;
				break;
		}
	}

	for(i=0;i<13;i++){	//2,3,4 of a kind and pairs
		if(facecount[i]==2)	//any 2 of a kind or 2 pairs
			flags2[0]=flags2[0]+1;

		if(facecount[i]==2 && i>=9)	//jacks or better, 3 of a kind, or 4 of a kind
			flags2[1]=flags2[1]+1;
		else{
			if(facecount[i]==3)
				flags2[2]=flags2[2]+1;
			else
				if(facecount[i]==4)
					flags2[3]=flags2[3]+1;
		}
	}

	for(i=0;i<9;i++){	//straight or part of a straight flush
		if(facecount[i+0]==1 && facecount[i+1]==1 && facecount[i+2]==1 && facecount[i+3]==1 && facecount[i+4]==1 && i==8)
			flags2[4]=flags2[4]+1;
		else
			if(facecount[i+0]==1 && facecount[i+1]==1 && facecount[i+2]==1 && facecount[i+3]==1 && facecount[i+4]==1 && i<8)
				flags2[5]=flags2[5]+1;
	}
	if(facecount[0]==1 && facecount[1]==1 && facecount[2]==1 && facecount[3]==1 && facecount[12]==1)
		flags2[5]=flags2[5]+1;

	for(i=0;i<4;i++)	// a flush
		if(suitcount[i]==5)
			flags2[6]=flags2[6]+1;

	// result
	if(flags2[6]==1 && flags2[4]==1)	// royal flush
		result=100;
	else{
		if(flags2[6]==1 && flags2[5]==1)	// straight flush
			result=50;
		else{
			if(flags2[3]==1)	// 4 of a kind
				result=25;
			else{
				if(flags2[0]==1 && flags2[2]==1)	// full house
					result=8;
				else{
					if(flags2[6]==1)	// flush
						result=7;
					else{
						if(flags2[4]==1 || flags2[5]==1)	// straight
							result=6;
						else{
							if(flags2[2]==1)	// 3 of a kind
								result=3;
							else{
								if(flags2[0]==2)	// 2 pairs
									result=2;
								else{
									if(flags2[1]==1)	// jacks or better
										result=1;
									else
										result=0; // nothing
								}
							}
						}
					}
				}
			}
		}
	}

	return result;
}

void show_result(int result){
	char str[7];

	switch(result){
		case 0:
			DsPrintf(20,90,16,":-( Nothing,..");
			break;
		case 1:
			DsPrintf(20,90,16,":( Jacks or better.");
			break;
		case 2:
			DsPrintf(20,90,16,":-| Two Pairs.");
			break;
		case 3:
			DsPrintf(20,90,16,":() Three of a Kind!");
			break;
		case 6:
			DsPrintf(20,90,16,":-() Straight!");
			break;
		case 7:
			DsPrintf(20,90,16,":) Flush!");
			break;
		case 8:
			DsPrintf(20,90,16,":-) Full House!!");
			break;
		case 25:
			DsPrintf(20,90,16,":--) Four of a Kind!!");
			break;
		case 50:
			DsPrintf(20,90,16,";-) Straight Flush!!!");
			break;
		case 100:
			DsPrintf(20,90,16,";--) ROYAL FLUSH!!!");
			break;
	}

	win=bet*result;
	itoa(str,win);
	DsPrintf(30,105,32,str);

	cash=cash+win;
	itoa(str,cash);
	DsDisplayBlockClear(55,105,105,120);
	DsPrintf(55,105,32,str);
}

void draw_cardlines(int x,int y){
	DsDisplayLine(x,y,CARD_WIDTH,0,0xff);
	DsDisplayLine(x,y+CARD_LENGTH,CARD_WIDTH,0,0xff);
	DsDisplayLine(x,y,0,CARD_LENGTH,0xff);
	DsDisplayLine(x+CARD_WIDTH,y,0,CARD_LENGTH,0xff);
}

void print_cface(int card,int x,int y){
	char msg[2];
	int c;
	char *cp;

	DsDisplayBlockClear(x+1,y+1,CARD_WIDTH-2,CARD_LENGTH-2);

	c=card%13;
	msg[0]=cardname[c];
	msg[1]=0;

	c=card / 13;
	switch(c){
		case 0:
			cp=bkaro;
			break;
		case 1:
			cp=bherz;
			break;
		case 2:
			cp=bpik;
			break;
		case 3:
			cp=bkreuz;
			break;
	}

	DsDisplayBitmapDraw(x+4,y+15,cp,0);
	DsPrintf(x+5,y+5,32,msg);
}

void flip_card(int x,int card){
	switch(faceup[card]){
		case 1:
			if(a<3){
				DsDisplayBlockClear(x+1,20+1,CARD_WIDTH-2,CARD_LENGTH-2);
				a++;
				faceup[card]=0;
			}
			else{
				DsPrintf(20,90,16,"Card change limit reached.");
				DsSleep(MESSAGE_TIME);
				DsDisplayBlockClear(20,90,150,12);
			}
			break;
		case 0:
			print_cface(cards[card],x,20);
			a--;
			faceup[card]=1;
			break;
	}
}

void draw_all(void){
	int i,j;

	j=20;
	for(i=0;i<5;i++){
		draw_cardlines(j,20);
		print_cface(cards[i],j,20);
		j=j+23;
	}
}

void shuffle(int n){
	int i,j,r,tmp;

	for(i=0;i<52;i++)
		cards[i]=i;

	for(j=0;j<n;j++)
		for(i=0;i<NO_CARDS;i++){
			r=abs(randRex()) % NO_CARDS;
			tmp=cards[r];
			cards[r]=cards[i];
			cards[i]=tmp;
		}
}

void draw_cashnround(void){
	char str[7];

	itoa(str,round);
	DsPrintf(5,105,32,str);

	itoa(str,cash);
	DsPrintf(55,105,32,str);
}

void draw_start(void){
	DsDialogTextButton(180,20,40,20,61,"Go!");
	DsDialogTextButton(180,50,40,20,62,"All");
	DsDialogTextButton(180,80,40,20,65,"Help");

	draw_cashnround();

	DsEventAdd(20,20,CARD_WIDTH,CARD_LENGTH,71,1);
	DsEventAdd(43,20,CARD_WIDTH,CARD_LENGTH,72,1);
	DsEventAdd(66,20,CARD_WIDTH,CARD_LENGTH,73,1);
	DsEventAdd(89,20,CARD_WIDTH,CARD_LENGTH,74,1);
	DsEventAdd(112,20,CARD_WIDTH,CARD_LENGTH,75,1);
}

void show_help(void){
	int flag,i,j;
	MSG msg;

	a=0;
	faceup[0]=faceup[1]=faceup[2]=faceup[3]=faceup[4]=1;

	DsEventClear();
	DsClearScreen();

	DsPrintf(5,5,32,"1. Royal Flush");
	DsPrintf(5,15,32,"2. Straight Flush");
	DsPrintf(5,25,32,"3. Four of a Kind");
	DsPrintf(5,35,32,"4. Full House");
	DsPrintf(5,45,32,"5. Flush");
	DsPrintf(5,55,32,"6. Straight");
	DsPrintf(5,65,32,"7. Three of a Kind");
	DsPrintf(5,75,32,"8. 2 Pairs");
	DsPrintf(5,85,32,"9. Jacks or better");

	DsPrintf(5,100,32,"Press Screen to Play...");

	DsEventAdd(0,0,240,120,66,1);

	flag=1;
	while(flag){
		DsEventMessageGet(msg);
		switch(msg.message){
			case MSG_DS_CLOSE:
			case MSG_DS_KEY_DOWN:
				flag=0;
				DsEventClear();
				DsClearScreen();
				DsAddinTerminate();
				break;
			case MSG_DS_COMMAND:
				flag=0;
				break;
		}
	}

	DsEventClear();
	DsClearScreen();
	draw_start();
	draw_all();
}

void get_bet(void){
	int flag;
	MSG msg;

	draw_all();
	draw_cashnround();

	DsDialogTextButton(180,8,40,20,67,"Bet 1$");
	DsDialogTextButton(180,30,40,20,68,"Bet 2$");
	DsDialogTextButton(180,52,40,20,69,"Bet 3$");
	DsDialogTextButton(180,74,40,20,70,"Bet 4$");
	DsDialogTextButton(180,96,40,20,76,"Bet 5$");

	flag=1;
	while(flag){
		DsEventMessageGet(msg);
		switch(msg.message){
			case MSG_DS_CLOSE:
			case MSG_DS_KEY_DOWN:
				flag=0;
				DsEventClear();
				DsClearScreen();
				DsAddinTerminate();
				break;
			case MSG_DS_COMMAND:
				switch(msg.bCode){
					case 67:
						bet=1;
						break;
					case 68:
						bet=2;
						break;
					case 69:
						bet=3;
						break;
					case 70:
						bet=4;
						break;
					case 76:
						bet=5;
						break;
				}
				if(bet>cash){
					DsPrintf(20,90,16,"Not enough money :-(");
					DsSleep(MESSAGE_TIME);
					DsDisplayBlockClear(20,90,150,12);
				}
				else
					flag=0;
		}
	}
}

void init_round(void){
	DsEventClear();
	DsClearScreen();

	faceup[0]=faceup[1]=faceup[2]=faceup[3]=faceup[4]=1;
	shuffle(20);
	a=0;

	get_bet();

	cash=cash-bet;

	DsEventClear();
	DsClearScreen();

	draw_start();
	draw_all();
}

void init_game(void){
	cash=CASH_START;
	round=1;
	init_round();
}

void show_new(void){
	int i,x;
	// int tmp;

	for(i=0;i<5;i++)
		if(faceup[i]==0){
			// tmp=cards[i];
			cards[i]=cards[i+5];
			// cards[i+5]=tmp;
			switch(i){
				case 0:
					x=20;
					break;
				case 1:
					x=43;
					break;
				case 2:
					x=66;
					break;	
				case 3:
					x=89;
					break;
				case 4:
					x=112;
					break;
			}
			// faceup[i]=1;
			print_cface(cards[i],x,20);
		}
}

void new_buttons(void){
	DsEventClear();
	DsDisplayBlockClear(180,20,40,80);

	if(round<ROUNDS && cash>0)
		DsDialogTextButton(180,20,40,20,63,"Play");
	else{
		DsPrintf(180,20,16,"GAME");
		DsPrintf(180,32,16,"OVER");

		DsPrintf(20,55,32,"Video Poker v1.0 for Rex 6000");
		DsPrintf(20,65,32,"by Marcel Timm, 14oct2001");
		DsPrintf(20,75,32,"http://www.onkelfuzzy.de/");
	}

	DsDialogTextButton(180,50,40,20,66,"New!");
        	DsDialogTextButton(180,80,40,20,64,"Exit");
}

void main(void){
	int flag,result;
	MSG msg;
	
	init_game();

	flag=1;
	while(flag){
		DsEventMessageGet(msg);
		switch(msg.message){
			case MSG_DS_CLOSE:
			case MSG_DS_KEY_DOWN:
				flag=0;
				break;
			case MSG_DS_COMMAND:
				switch(msg.bCode){
					case 61: // Go!
						show_new();
						result=get_result();
						show_result(result);
						new_buttons();
						break;
					case 62: // All
						faceup[0]=faceup[1]=faceup[2]=faceup[3]=faceup[4]=0;
						show_new();
						result=get_result();
						show_result(result);
						new_buttons();
						break;
					case 63: // Play
						round=round+1;
						init_round();
						break;
					case 64: // Exit
						flag=0;
						break;
					case 65:	// Help
						show_help();
						break;
					case 66: // New
						init_game();
						break;
					case 71:
						flip_card(20,0);	
						break;
					case 72:
						flip_card(43,1);
						break;
					case 73:
						flip_card(66,2);
						break;
					case 74:
						flip_card(89,3);
						break;
					case 75:
						flip_card(112,4);
						break;
				}
		}
	}

	DsEventClear();
	DsClearScreen();
	DsAddinTerminate();
}
