
// BlackRex v0.9 addin for Xircom Rex 6000
// by Marcel Timm (mantillo), 17oct2001
// Parts of source code of Video Poker v1.0 (for Rex 6000)
// and of Anthony F. Ortiz's blackjack.java game were
// used to build BlackRex - many thanks to Mr. Ortiz!
// Thanks to Alex Paplowski for his addin 
// 'Schnauz for Rex 6000 B0.7', because I used parts
// of source code from his game for Video Poker :-)

#include <rex/rex.h>
#include <stdlib.h>

#define NO_CARDS 52
#define CARD_LENGTH 29
#define CARD_WIDTH 21
#define MESSAGE_TIME 60
#define ROUNDS 99	// not over 99!!!
#define CASH_START 50	// in US-Doller ;----)

#include "bmps.h"

char cards[NO_CARDS];
char cardname[]={"23456789TJQKA"};
int round,cash,bet,win,nextcard,k,l,result,result2;

void draw_cashnround(void){
	char str[5];

	itoa(str,round);
	DsPrintf(5,105,32,str);

	itoa(str,cash);
	DsPrintf(55,105,32,str);
}

void draw_start(void){
	DsDialogTextButton(180,20,40,20,65,"Stay");
	DsDialogTextButton(180,50,40,20,62,"Hit");
	DsDialogTextButton(180,80,40,20,64,"Exit");

	draw_cashnround();
}

void print_cface(int card,int x,int y){
	char msg[2];
	int c;
	char *cp;

	DsDisplayBlockClear(x+1,y+1,CARD_WIDTH-2,CARD_LENGTH-2);

	c=card%13;
	msg[0]=cardname[c];
	msg[1]=0;

	c=card / 13;
	switch(c){
		case 0:
			cp=bkaro;
			break;
		case 1:
			cp=bherz;
			break;
		case 2:
			cp=bpik;
			break;
		case 3:
			cp=bkreuz;
			break;
	}

	DsDisplayBitmapDraw(x+4,y+15,cp,0);
	DsPrintf(x+5,y+5,32,msg);
}

void draw_cardlines(int x,int y){
	DsDisplayLine(x,y,CARD_WIDTH,0,0xff);
	DsDisplayLine(x,y+CARD_LENGTH,CARD_WIDTH,0,0xff);
	DsDisplayLine(x,y,0,CARD_LENGTH,0xff);
	DsDisplayLine(x+CARD_WIDTH,y,0,CARD_LENGTH,0xff);
}

void draw_all(void){
	int i;

	l=k=20;
	for(i=0;i<2;i++){
		draw_cardlines(k,l);
		print_cface(cards[i],k,l);
		k=k+23;
	}
}

int get_result(int startcard){
                int i,aces,aces2,resulti;

	aces=aces2=resulti=0;

	for (i=startcard;i<nextcard;i++){
		switch (cards[i]%13){
			case 0:
				resulti=resulti+2;
				break;
			case 1:
				resulti=resulti+3;
				break;
			case 2:
				resulti=resulti+4;
				break;
			case 3:
				resulti=resulti+5;
				break;
			case 4:
				resulti=resulti+6;
				break;
			case 5:
				resulti=resulti+7;
				break;
			case 6:
				resulti=resulti+8;
				break;
			case 7:
				resulti=resulti+9;
				break;
			case 8:
				resulti=resulti+10;
				break;
			case 9:
				resulti=resulti+10;
				break;
			case 10:
				resulti=resulti+10;
				break;
			case 11:
				resulti=resulti+10;
				break;
			case 12:
				resulti=resulti+11;
				aces++;
				break;
		}
	}
	aces2=aces;
	for (i=0;i<aces2;i++)
		if(aces>0 && resulti > 21){
			resulti=resulti-10;
			aces=aces-1;
		}
	return resulti;
}

int dealer(void){
	int startcard,flag;

	startcard=nextcard;
	nextcard=nextcard+2;

	flag=0;
	while(flag==0){
		result2=get_result(startcard);

		if(result2>21)
			flag=2;	// Dealer busted, Player wins
		else{
			if(result<result2 || result > 21)
				flag=1; // Dealer wins
			else{
				if(result==21 && result2==21)
					flag=3;	// Player gets bet back
				else
					nextcard++;	// Dealer takes one more card
			}
		}
	}
	return flag;
}

void show_result(int x){
	char str[5];
	int flag;

	switch(x){
		case 0:	// Players hand is < 21
			itoa(str,result);
			DsDisplayBlockClear(20,90,150,12);
			DsPrintf(20,90,16,str);

			break;
		case 1:	// Players hand == 21 or Stay button has been touched
			itoa(str,result);
			DsDisplayBlockClear(20,90,150,12);
			DsPrintf(20,90,16,str);

			flag=dealer();
			switch(flag){
				case 1:	// Dealer wins
					win=0;
					DsPrintf(50,90,16,":-( Dealer wins...");

					break;
				case 2:	// Dealer busted
					win=2 * bet;
					DsPrintf(50,90,16,":-) Dealer busted!");

					break;
				case 3:	// Dealer got 21, too
					win=bet;
					DsPrintf(50,90,16,":-| Dealer got same.");

					break;
			}

			itoa(str,win);
			DsPrintf(30,105,32,str);

			cash=cash+win;

			itoa(str,result2);
			DsPrintf(110,105,32,str);

			break;
		case 2:	// Player busted
			flag=dealer();

			itoa(str,result);
			DsDisplayBlockClear(20,90,150,12);
			DsPrintf(20,90,16,str);

			DsPrintf(50,90,16,":( You busted..");

			win=0;
			itoa(str,win);
			DsPrintf(30,105,32,str);

			itoa(str,result2);
			DsPrintf(110,105,32,str);

			break;
	}

	itoa(str,cash);
	DsDisplayBlockClear(55,105,50,12);
	DsPrintf(55,105,32,str);
}

void get_bet(void){
	int flag;
	MSG msg;

	draw_all();
	draw_cashnround();

	result=get_result(0);
	show_result(0);

	DsDialogTextButton(180,8,40,20,67,"Bet 1$");
	DsDialogTextButton(180,30,40,20,68,"Bet 2$");
	DsDialogTextButton(180,52,40,20,69,"Bet 3$");
	DsDialogTextButton(180,74,40,20,70,"Bet 4$");
	DsDialogTextButton(180,96,40,20,76,"Bet 5$");

	flag=1;
	while(flag){
		DsEventMessageGet(msg);
		switch(msg.message){
			case MSG_DS_CLOSE:
			case MSG_DS_KEY_DOWN:
				flag=0;
				DsEventClear();
				DsClearScreen();
				DsAddinTerminate();
				break;
			case MSG_DS_COMMAND:
				switch(msg.bCode){
					case 67:
						bet=1;
						break;
					case 68:
						bet=2;
						break;
					case 69:
						bet=3;
						break;
					case 70:
						bet=4;
						break;
					case 76:
						bet=5;
						break;
				}
				if(bet>cash){
					DsPrintf(20,90,16,"Not enough money :-(");
					DsSleep(MESSAGE_TIME);
					DsDisplayBlockClear(20,90,150,12);
				}
				else
					flag=0;
		}
	}
}

void shuffle(int n){
	int i,j,r,tmp;

	for(i=0;i<52;i++)
		cards[i]=i;

	for(j=0;j<n;j++)
		for(i=0;i<NO_CARDS;i++){
			r=abs(randRex()) % NO_CARDS;
			tmp=cards[r];
			cards[r]=cards[i];
			cards[i]=tmp;
		}
}

void get_card(void){
	draw_cardlines(k,l);
	print_cface(cards[nextcard],k,l);
	if(k<135)
		k=k+23;
	else{
		k=20;
		l=52;
	}
	nextcard++;
}

void new_buttons(void){
	DsEventClear();
	DsDisplayBlockClear(180,20,40,80);

	if(round<ROUNDS && cash>0)
		DsDialogTextButton(180,20,40,20,63,"Play");
	else{
		DsPrintf(180,20,16,"GAME");
		DsPrintf(180,32,16,"OVER");

		DsPrintf(20,55,32,"Black Rex v0.9 for Rex 6000");
		DsPrintf(20,65,32,"by Marcel Timm, 17oct2001");
		DsPrintf(20,75,32,"http://www.onkelfuzzy.de/");
	}

	DsDialogTextButton(180,50,40,20,66,"New!");
        	DsDialogTextButton(180,80,40,20,64,"Exit");
}

void init_round(void){
	DsEventClear();
	DsClearScreen();

	shuffle(20);

	nextcard=2;

	get_bet();

	cash=cash-bet;

	DsEventClear();
	DsClearScreen();

	draw_start();
	draw_all();

	result=get_result(0);
	if(result==21){
		show_result(1);
		new_buttons();
	}
	else
		show_result(0);
}

void init_game(void){
	cash=CASH_START;
	round=1;
	init_round();
}

void main(void){
	int flag;
	MSG msg;

	init_game();

	flag=1;
	while(flag){
		DsEventMessageGet(msg);
		switch(msg.message){
			case MSG_DS_CLOSE:
			case MSG_DS_KEY_DOWN:
				flag=0;
				break;
			case MSG_DS_COMMAND:
				switch(msg.bCode){
					case 62: // Hit
						get_card();
						result=get_result(0);
						if(result>21){
							show_result(2);
							new_buttons();
						}
						else{
							if(result==21){
								show_result(1);
								new_buttons();
							}
							else
								show_result(0);
						}

						break;
					case 63: // Play
						round++;
						init_round();

						break;
					case 64: // Exit
						flag=0;

						break;
					case 65: // Stay
						show_result(1);
						new_buttons();

						break;
					case 66: // New
						init_game();

						break;
				}
		}
	}

	DsEventClear();
	DsClearScreen();
	DsAddinTerminate();
}
