/*
 * Decompiled with CFR 0.152.
 */
package jasper;

import jasper.Attribute_Collection;
import jasper.ClassFile;
import jasper.Pool_Collection;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;

class Method {
    private Pool_Collection pool;
    private int accessFlags;
    private int nameIndex;
    private int descriptorIndex;
    private Attribute_Collection attributes;

    Method(DataInputStream ios, Pool_Collection pool) throws IOException {
        this.pool = pool;
        this.accessFlags = ios.readShort();
        this.nameIndex = ios.readShort();
        this.descriptorIndex = ios.readShort();
        this.attributes = new Attribute_Collection(ios, pool);
    }

    private String accessString() {
        String s = "";
        if ((this.accessFlags & 1) > 0) {
            s = String.valueOf(s) + "public ";
        }
        if ((this.accessFlags & 2) > 0) {
            s = String.valueOf(s) + "private ";
        }
        if ((this.accessFlags & 4) > 0) {
            s = String.valueOf(s) + "protected ";
        }
        if ((this.accessFlags & 8) > 0) {
            s = String.valueOf(s) + "static ";
        }
        if ((this.accessFlags & 0x10) > 0) {
            s = String.valueOf(s) + "final ";
        }
        if ((this.accessFlags & 0x20) > 0) {
            s = String.valueOf(s) + "synchronized ";
        }
        if ((this.accessFlags & 0x100) > 0) {
            s = String.valueOf(s) + "native ";
        }
        if ((this.accessFlags & 0x400) > 0) {
            s = String.valueOf(s) + "abstract ";
        }
        return s;
    }

    String[] browseFieldrefs() {
        return this.attributes.browseFieldrefs();
    }

    String[] browseInterfaceMethodrefs() {
        return this.attributes.browseInterfaceMethodrefs();
    }

    String browseMethod(String thisClass) {
        String s = this.pool.browseDescriptor(this.descriptorIndex);
        String returnType = s.substring(0, s.indexOf(40));
        String functionParams = s.substring(s.indexOf(40));
        String functionName = this.pool.browseString(this.nameIndex);
        String retVal = String.valueOf(this.attributes.browseDeprecated()) + this.attributes.browseSynthetic() + this.accessString() + returnType + thisClass + "." + functionName + functionParams;
        String[] excVal = this.attributes.browseExceptions();
        if (excVal != null && excVal.length > 0) {
            retVal = String.valueOf(retVal) + " throws " + excVal[0];
            int i = 1;
            while (i < excVal.length) {
                retVal = String.valueOf(retVal) + ", " + excVal[i];
                ++i;
            }
        }
        return retVal;
    }

    String[] browseMethodrefs() {
        return this.attributes.browseMethodrefs();
    }

    void jasmin(PrintStream out) throws IOException {
        out.println(String.valueOf(ClassFile.pad(".method", 25)) + this.accessString() + this.pool.toString(this.nameIndex) + this.pool.toString(this.descriptorIndex));
        this.attributes.jasmin(out);
        out.println(ClassFile.pad(".end method", 25));
        out.println("");
    }
}

