/*
 * Decompiled with CFR 0.152.
 */
package jasper;

import jasper.ClassFile;
import java.util.Vector;

public class Jasper {
    public static final String version = "v1.00";
    static String[][] accessStrings = new String[][]{{"public ", "0"}, {"private ", "0"}, {"protected ", "0"}, {"static ", "0"}, {"final ", "0"}, {"synchronized ", "0"}, {"volatile ", "0"}, {"transient ", "0"}, {"native ", "0"}, {"abstract ", "0"}, {"#deprecated# ", "0"}, {"#synthetic# ", "1"}};

    static void addClassFile(String name, Vector classList) {
        String fileName = String.valueOf(ClassFile.parseFileDir(name)) + ClassFile.parseFileName(name) + "." + ClassFile.parseFileExt(name);
        if (fileName.equals(".class")) {
            return;
        }
        if (fileName.equals("byte.class")) {
            return;
        }
        if (fileName.equals("short.class")) {
            return;
        }
        if (fileName.equals("int.class")) {
            return;
        }
        if (fileName.equals("long.class")) {
            return;
        }
        if (fileName.equals("boolean.class")) {
            return;
        }
        if (fileName.equals("float.class")) {
            return;
        }
        if (fileName.equals("double.class")) {
            return;
        }
        if (fileName.equals("char.class")) {
            return;
        }
        if (fileName.equals("void.class")) {
            return;
        }
        int i = 0;
        while (i < classList.size()) {
            if (((String)classList.elementAt(i)).equals(fileName)) {
                return;
            }
            ++i;
        }
        classList.add(fileName);
    }

    static void browseDump(ClassFile cls) {
        String[] ix = cls.browseInterfaces();
        String[] fx = cls.browseFields();
        String[] mx = cls.browseMethods();
        String[][] mf = cls.browseFieldrefs();
        String[][] mm = cls.browseMethodrefs();
        String[][] mi = cls.browseInterfaceMethodrefs();
        String[][] ic = cls.browseInnerClasses();
        System.out.println("+++++++++++++++++++++++");
        System.out.println("   SourceFile = " + cls.browseSourceFile());
        System.out.println("   class      = " + cls.browseClass());
        System.out.println("   extends    = " + cls.browseSuper());
        int i = 0;
        while (i < ix.length) {
            System.out.println("   implements = " + ix[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < fx.length) {
            System.out.println("   field      = " + fx[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < mx.length) {
            System.out.println("   method     = " + mx[i3]);
            int j = 0;
            while (j < mf[i3].length) {
                System.out.println("      fields     = " + mf[i3][j]);
                ++j;
            }
            int j2 = 0;
            while (j2 < mm[i3].length) {
                System.out.println("      methods    = " + mm[i3][j2]);
                ++j2;
            }
            int j3 = 0;
            while (j3 < mi[i3].length) {
                System.out.println("      interfaces = " + mi[i3][j3]);
                ++j3;
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < ic.length) {
            System.out.println("innerClass[" + i4 + "] = " + ic[i4][0]);
            System.out.println("outerClass[" + i4 + "] = " + ic[i4][1]);
            System.out.println("innerName[" + i4 + "]  = " + ic[i4][2]);
            ++i4;
        }
    }

    public static void main(String[] args) {
        boolean jasmin = true;
        boolean browse = false;
        boolean recurse = false;
        Vector classList = new Vector();
        int i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) != '-') {
                Jasper.addClassFile(args[i], classList);
            } else if (args[i].equals("--jasmin")) {
                jasmin = false;
            } else if (args[i].equals("-jasmin")) {
                jasmin = true;
            } else if (args[i].equals("-browse")) {
                browse = true;
            } else if (args[i].equals("-recurse")) {
                recurse = true;
            } else if (args[i].equals("-version")) {
                Jasper.printVersion();
                System.exit(0);
            } else if (args[i].equals("--version")) {
                Jasper.printVersion();
                Jasper.printLicense();
                System.exit(0);
            } else if (args[i].equals("-?") || args[i].equals("-help")) {
                Jasper.printVersion();
                Jasper.printOptions();
                System.exit(0);
            } else {
                System.out.println("Unrecognized option: " + args[i]);
                System.out.println("Could not run jasper.");
                Jasper.printVersion();
                Jasper.printOptions();
                System.exit(0);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < classList.size()) {
            String fileName = (String)classList.elementAt(i2);
            ClassFile cls = new ClassFile(fileName);
            if (jasmin) {
                cls.jasmin();
            }
            if (browse) {
                Jasper.browseDump(cls);
            }
            if (recurse) {
                Jasper.recurseClasses(cls, classList);
            }
            ++i2;
        }
    }

    static void printLicense() {
        System.out.println("");
        System.out.println("Redistribution and use in source and binary forms, with or without");
        System.out.println("modification, are permitted provided that the following conditions");
        System.out.println("are met:");
        System.out.println("");
        System.out.println("  1. Redistributions of source code must retain the above copyright");
        System.out.println("     notice, this list of conditions and the following disclaimer.");
        System.out.println("  2. Redistributions in binary form must reproduce the above copyright");
        System.out.println("     notice, this list of conditions and the following disclaimer in the");
        System.out.println("     documentation and/or other materials provided with the distribution.");
        System.out.println("  3. All advertising materials mentioning features or use of this software");
        System.out.println("     must display the following acknowledgement:");
        System.out.println("       This product includes software developed by Chris Rathman and");
        System.out.println("       its contributors.");
        System.out.println("  4. Neither the name of Chris Rathman nor the names of its contributors");
        System.out.println("     may be used to endorse or promote products derived from this software");
        System.out.println("     without specific prior written permission.");
        System.out.println("");
        System.out.println("THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''");
        System.out.println("AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE");
        System.out.println("IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE");
        System.out.println("ARE DISCLAIMED. IN NO EVENT SHALL CHRIS RATHMAN OR CONTRIBUTORS BE LIABLE FOR");
        System.out.println("ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES");
        System.out.println("(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;");
        System.out.println("LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND");
        System.out.println("ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT");
        System.out.println("(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS");
        System.out.println("SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.");
        System.out.println("");
    }

    private static void printOptions() {
        System.out.println("Jasper recognizes the following options:");
        System.out.println("   --jasmin   Disable jasmin file output");
        System.out.println("   -jasmin    Enable jasmin file output (default)");
        System.out.println("   -browse    Enable output to the browse files");
        System.out.println("   -recurse   Recurse through the inheritance and composition for the class");
        System.out.println("   -help      View Jasper help");
        System.out.println("   -version   View Jasper version number");
        System.out.println("   --version  View Jasper license");
        System.out.println("");
    }

    private static void printVersion() {
        System.out.println("Jasper Version v1.00  Copyright (c) Chris Rathman 1999. All rights reserved.");
        System.out.println("Syntax:  java [java-options] jasper/Jasper [jasper-options] files.class");
        System.out.println("");
    }

    static void recurseClasses(ClassFile cls, Vector classList) {
        String newClass = cls.browseSuper();
        if (!newClass.equals("")) {
            Jasper.addClassFile(String.valueOf(newClass) + ".class", classList);
        }
        String[] newClassArray = cls.browseInterfaces();
        int j = 0;
        while (j < newClassArray.length) {
            newClass = newClassArray[j];
            Jasper.addClassFile(String.valueOf(newClass) + ".class", classList);
            ++j;
        }
        newClassArray = cls.browseFields();
        int j2 = 0;
        while (j2 < newClassArray.length) {
            newClass = Jasper.stripAccess(newClassArray[j2]);
            if (newClass.indexOf(32) > 0) {
                newClass = newClass.substring(0, newClass.indexOf(32));
            }
            if (newClass.indexOf(91) > 0) {
                newClass = newClass.substring(0, newClass.indexOf(91));
            }
            Jasper.addClassFile(String.valueOf(newClass) + ".class", classList);
            ++j2;
        }
        newClassArray = cls.browseMethods();
        int j3 = 0;
        while (j3 < newClassArray.length) {
            newClass = Jasper.stripAccess(newClassArray[j3]);
            if (newClass.indexOf(32) > 0) {
                newClass = newClass.substring(0, newClass.indexOf(32));
            }
            if (newClass.indexOf(91) > 0) {
                newClass = newClass.substring(0, newClass.indexOf(91));
            }
            Jasper.addClassFile(String.valueOf(newClass) + ".class", classList);
            String params = newClassArray[j3];
            params = params.substring(params.indexOf(40) + 1);
            params = params.substring(0, params.indexOf(41) + 1);
            while (params.length() > 1) {
                int n = params.indexOf(44);
                if (n > 0) {
                    newClass = params.substring(0, n);
                    params = params.substring(n + 2);
                } else {
                    newClass = params.substring(0, params.indexOf(41));
                    params = "";
                }
                if (newClass.indexOf(91) > 0) {
                    newClass = newClass.substring(0, newClass.indexOf(91));
                }
                Jasper.addClassFile(String.valueOf(newClass) + ".class", classList);
            }
            ++j3;
        }
        String[][] newClassRef = cls.browseFieldrefs();
        int j4 = 0;
        while (j4 < newClassRef.length) {
            int k = 0;
            while (k < newClassRef[j4].length) {
                newClass = Jasper.stripAccess(newClassRef[j4][k]);
                if (newClass.indexOf(32) > 0) {
                    newClass = newClass.substring(0, newClass.indexOf(32));
                }
                if (newClass.indexOf(91) > 0) {
                    newClass = newClass.substring(0, newClass.indexOf(91));
                }
                Jasper.addClassFile(String.valueOf(newClass) + ".class", classList);
                newClass = Jasper.stripAccess(newClassRef[j4][k]);
                if (newClass.lastIndexOf(32) > 0) {
                    newClass = newClass.substring(newClass.lastIndexOf(32) + 1);
                }
                if (newClass.lastIndexOf(46) > 0) {
                    newClass = newClass.substring(0, newClass.lastIndexOf(46));
                }
                Jasper.addClassFile(String.valueOf(newClass) + ".class", classList);
                ++k;
            }
            ++j4;
        }
        newClassRef = cls.browseMethodrefs();
        int j5 = 0;
        while (j5 < newClassRef.length) {
            int k = 0;
            while (k < newClassRef[j5].length) {
                newClass = Jasper.stripAccess(newClassRef[j5][k]);
                if (newClass.indexOf(32) > 0) {
                    newClass = newClass.substring(0, newClass.indexOf(32));
                }
                if (newClass.indexOf(91) > 0) {
                    newClass = newClass.substring(0, newClass.indexOf(91));
                }
                if (!newClass.equals("new")) {
                    Jasper.addClassFile(String.valueOf(newClass) + ".class", classList);
                    newClass = Jasper.stripAccess(newClassRef[j5][k]);
                    if (newClass.indexOf(40) > 0) {
                        newClass = newClass.substring(0, newClass.indexOf(40));
                    }
                    if (newClass.lastIndexOf(32) > 0) {
                        newClass = newClass.substring(newClass.lastIndexOf(32) + 1);
                    }
                    if (newClass.lastIndexOf(46) > 0) {
                        newClass = newClass.substring(0, newClass.lastIndexOf(46));
                    }
                    Jasper.addClassFile(String.valueOf(newClass) + ".class", classList);
                }
                String params = newClassRef[j5][k];
                params = params.substring(params.indexOf(40) + 1);
                params = params.substring(0, params.indexOf(41) + 1);
                while (params.length() > 1) {
                    int n = params.indexOf(44);
                    if (n > 0) {
                        newClass = params.substring(0, n);
                        params = params.substring(n + 2);
                    } else {
                        newClass = params.substring(0, params.indexOf(41));
                        params = "";
                    }
                    if (newClass.indexOf(91) > 0) {
                        newClass = newClass.substring(0, newClass.indexOf(91));
                    }
                    Jasper.addClassFile(String.valueOf(newClass) + ".class", classList);
                }
                ++k;
            }
            ++j5;
        }
        newClassRef = cls.browseMethodrefs();
        int j6 = 0;
        while (j6 < newClassRef.length) {
            int k = 0;
            while (k < newClassRef[j6].length) {
                newClass = Jasper.stripAccess(newClassRef[j6][k]);
                if (newClass.indexOf(32) > 0) {
                    newClass = newClass.substring(0, newClass.indexOf(32));
                }
                if (newClass.indexOf(91) > 0) {
                    newClass = newClass.substring(0, newClass.indexOf(91));
                }
                if (!newClass.equals("new")) {
                    Jasper.addClassFile(String.valueOf(newClass) + ".class", classList);
                    newClass = Jasper.stripAccess(newClassRef[j6][k]);
                    if (newClass.indexOf(40) > 0) {
                        newClass = newClass.substring(0, newClass.indexOf(40));
                    }
                    if (newClass.lastIndexOf(32) > 0) {
                        newClass = newClass.substring(newClass.lastIndexOf(32) + 1);
                    }
                    if (newClass.lastIndexOf(46) > 0) {
                        newClass = newClass.substring(0, newClass.lastIndexOf(46));
                    }
                    Jasper.addClassFile(String.valueOf(newClass) + ".class", classList);
                }
                String params = newClassRef[j6][k];
                params = params.substring(params.indexOf(40) + 1);
                params = params.substring(0, params.indexOf(41) + 1);
                while (params.length() > 1) {
                    int n = params.indexOf(44);
                    if (n > 0) {
                        newClass = params.substring(0, n);
                        params = params.substring(n + 2);
                    } else {
                        newClass = params.substring(0, params.indexOf(41));
                        params = "";
                    }
                    if (newClass.indexOf(91) > 0) {
                        newClass = newClass.substring(0, newClass.indexOf(91));
                    }
                    Jasper.addClassFile(String.valueOf(newClass) + ".class", classList);
                }
                ++k;
            }
            ++j6;
        }
    }

    static String stripAccess(String newClass) {
        boolean flag = true;
        while (flag) {
            flag = false;
            int i = 0;
            while (i < accessStrings.length) {
                String s = accessStrings[i][0];
                if (newClass.substring(0, s.length()).equals(s)) {
                    newClass = newClass.substring(s.length());
                    flag = true;
                    boolean synthetic = accessStrings[i][1].equals("1");
                    if (synthetic) {
                        return "";
                    }
                }
                ++i;
            }
        }
        return newClass;
    }
}

