/*
 * Decompiled with CFR 0.152.
 */
package jasper;

import jasper.Code;
import jasper.Code_Collection;
import jasper.Pool_Collection;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;

class Code_tableswitch
extends Code {
    private int tableSkip;
    private int tableDefault;
    private int tableLow;
    private int tableHigh;
    private int count;
    private int[] branch;

    Code_tableswitch(DataInputStream ios, Pool_Collection pool, int opcode, int pc) throws IOException {
        super(ios, pool, opcode, pc);
        this.tableSkip = 4 - (pc + 1) % 4;
        if (this.tableSkip == 4) {
            this.tableSkip = 0;
        }
        if (this.tableSkip > 0) {
            ios.skip(this.tableSkip);
        }
        this.tableDefault = ios.readInt();
        this.tableLow = ios.readInt();
        this.tableHigh = ios.readInt();
        this.count = this.tableHigh - this.tableLow + 1;
        this.branch = new int[this.count];
        int i = 0;
        while (i < this.count) {
            this.branch[i] = ios.readInt();
            ++i;
        }
        this.opbytes = 13 + this.tableSkip + this.count * 4;
    }

    void getLabel(Code_Collection code) {
        int i = 0;
        while (i < this.count) {
            code.setLabel(this.pc + this.branch[i]);
            ++i;
        }
    }

    void jasmin(PrintStream out) {
        super.jasmin(out);
        out.println(String.valueOf(this.tableLow) + " " + this.tableHigh);
        int i = 0;
        while (i < this.count) {
            out.println(String.valueOf(Code.pad("", 25)) + Code_Collection.toLabel(this.pc + this.branch[i]));
            ++i;
        }
        out.println(String.valueOf(Code.pad("       default :", 25)) + Code_Collection.toLabel(this.pc + this.tableDefault));
    }
}

