/*
 * Decompiled with CFR 0.152.
 */
package jasper;

import jasper.Code;
import jasper.Code_Collection;
import jasper.Pool_Collection;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;

class Code_lookupswitch
extends Code {
    private int lookupSkip;
    private int lookupDefault;
    private int count;
    private int[] match;
    private int[] branch;

    Code_lookupswitch(DataInputStream ios, Pool_Collection pool, int opcode, int pc) throws IOException {
        super(ios, pool, opcode, pc);
        this.lookupSkip = 4 - (pc + 1) % 4;
        if (this.lookupSkip == 4) {
            this.lookupSkip = 0;
        }
        if (this.lookupSkip > 0) {
            ios.skip(this.lookupSkip);
        }
        this.lookupDefault = ios.readInt();
        this.count = ios.readInt();
        this.match = new int[this.count];
        this.branch = new int[this.count];
        int i = 0;
        while (i < this.count) {
            this.match[i] = ios.readInt();
            this.branch[i] = ios.readInt();
            ++i;
        }
        this.opbytes = 9 + this.lookupSkip + this.count * 8;
    }

    void getLabel(Code_Collection code) {
        int i = 0;
        while (i < this.count) {
            code.setLabel(this.pc + this.branch[i]);
            ++i;
        }
    }

    void jasmin(PrintStream out) {
        super.jasmin(out);
        out.println("");
        int i = 0;
        while (i < this.count) {
            out.println(String.valueOf(Code.pad("        " + this.match[i] + " :", 25)) + Code_Collection.toLabel(this.pc + this.branch[i]));
            ++i;
        }
        out.println(String.valueOf(Code.pad("        default :", 25)) + Code_Collection.toLabel(this.pc + this.lookupDefault));
    }
}

