/*
 * Decompiled with CFR 0.152.
 */
package jasper;

import jasper.Attribute_Collection;
import jasper.Field_Collection;
import jasper.Interface_Collection;
import jasper.Method_Collection;
import jasper.Pool_Collection;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ClassFile
implements Serializable {
    static final int SPACER = 25;
    private int magic;
    private int minorVersion;
    private int majorVersion;
    private Pool_Collection pool;
    private int accessFlags;
    private int thisClass;
    private int superClass;
    private Interface_Collection interfaces;
    private Field_Collection fields;
    private Method_Collection methods;
    private Attribute_Collection attributes;

    public ClassFile(String name) {
        DataInputStream ios = null;
        ZipInputStream zip = null;
        ZipEntry zin = null;
        String fileName = String.valueOf(ClassFile.parseFileDir(name)) + ClassFile.parseFileName(name) + "." + ClassFile.parseFileExt(name);
        String className = fileName.replace(File.separatorChar, '/');
        System.out.println("Reading:   " + fileName);
        try {
            block14: {
                File f = new File(fileName);
                if (f.exists()) {
                    ios = new DataInputStream(new FileInputStream(fileName));
                } else {
                    String[] classPath = this.getClassPath();
                    int i = 0;
                    while (i < classPath.length) {
                        f = new File(classPath[i]);
                        if (f.exists()) {
                            if (f.isFile()) {
                                zip = new ZipInputStream(new FileInputStream(classPath[i]));
                                zin = zip.getNextEntry();
                                while (zin != null) {
                                    if (zin.getName().equals(className)) {
                                        ios = new DataInputStream(zip);
                                        break block14;
                                    }
                                    zin = zip.getNextEntry();
                                }
                            } else if (f.isDirectory() && (f = new File(String.valueOf(classPath[i]) + File.separatorChar + fileName)).isFile()) {
                                ios = new DataInputStream(new FileInputStream(f));
                                break block14;
                            }
                        }
                        ++i;
                    }
                    if (ios == null) {
                        throw new FileNotFoundException(fileName);
                    }
                }
            }
            this.magic = ios.readInt();
            if (this.magic != -889275714) {
                throw new IOException("File is not a java class file.");
            }
            this.minorVersion = ios.readShort();
            this.majorVersion = ios.readShort();
            this.pool = new Pool_Collection(ios);
            this.accessFlags = ios.readShort();
            this.thisClass = ios.readShort();
            this.superClass = ios.readShort();
            this.interfaces = new Interface_Collection(ios, this.pool);
            this.fields = new Field_Collection(ios, this.pool);
            this.methods = new Method_Collection(ios, this.pool);
            this.attributes = new Attribute_Collection(ios, this.pool);
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
            ClassFile.dump(ios, Integer.MAX_VALUE);
        }
    }

    private String accessString() {
        String retVal = "";
        if ((this.accessFlags & 1) > 0) {
            retVal = String.valueOf(retVal) + "public ";
        }
        if ((this.accessFlags & 0x10) > 0) {
            retVal = String.valueOf(retVal) + "final ";
        }
        if ((this.accessFlags & 0x400) > 0) {
            retVal = String.valueOf(retVal) + "abstract ";
        }
        return retVal;
    }

    public String browseClass() {
        return this.pool.browseString(this.thisClass);
    }

    public String[][] browseFieldrefs() {
        return this.methods.browseFieldrefs();
    }

    public String[] browseFields() {
        return this.fields.browseFields(this.browseClass());
    }

    public String[][] browseInnerClasses() {
        return this.attributes.browseInnerClasses();
    }

    public String[][] browseInterfaceMethodrefs() {
        return this.methods.browseInterfaceMethodrefs();
    }

    public String[] browseInterfaces() {
        return this.interfaces.browseInterfaces();
    }

    public String[][] browseMethodrefs() {
        return this.methods.browseMethodrefs();
    }

    public String[] browseMethods() {
        return this.methods.browseMethods(this.browseClass());
    }

    public String browseSourceFile() {
        return String.valueOf(this.attributes.browseDeprecated()) + this.attributes.browseSynthetic() + this.accessString() + this.attributes.browseSourceFile();
    }

    public String browseSuper() {
        if (this.superClass > 0) {
            return this.pool.browseString(this.superClass);
        }
        return "";
    }

    public static void dump(DataInputStream ios, int length) {
        try {
            String a = "";
            int i = 0;
            int j = 0;
            while (i < length) {
                String s;
                int val = ios.read();
                if (val < 0) {
                    System.exit(0);
                }
                if (j == 0) {
                    System.out.println("  " + a);
                    a = "";
                    s = Integer.toHexString(i);
                    s = String.valueOf(s) + "      ".substring(s.length());
                    System.out.print(String.valueOf(s) + "  ");
                }
                if (j == 8) {
                    System.out.print("  ");
                }
                if ((s = Integer.toHexString(val)).length() < 2) {
                    s = "0" + s;
                }
                System.out.print(String.valueOf(s) + " ");
                a = val > 32 && val < 128 ? String.valueOf(a) + (char)val : String.valueOf(a) + ' ';
                if (++j == 16) {
                    j = 0;
                }
                ++i;
            }
            System.out.println("");
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private String[] getClassPath() {
        String javaHome;
        Vector<String> x = new Vector<String>();
        String classPath = System.getProperty("java.class.path");
        String s = "";
        int i = 0;
        while (i < classPath.length()) {
            if (classPath.charAt(i) == ';') {
                x.add(s);
                s = "";
            } else {
                s = String.valueOf(s) + classPath.charAt(i);
            }
            ++i;
        }
        if (!s.equals("")) {
            x.add(s);
        }
        if ((javaHome = System.getProperty("java.home")) != null) {
            x.add(String.valueOf(javaHome) + File.separatorChar + "lib" + File.separatorChar + "rt.jar");
        }
        Object[] retVal = new String[x.size()];
        x.copyInto(retVal);
        return retVal;
    }

    public void jasmin() {
        try {
            String name = String.valueOf(this.browseClass()) + ".j";
            String fileName = String.valueOf(ClassFile.parseFileDir(name)) + ClassFile.parseFileName(name) + "." + ClassFile.parseFileExt(name);
            if (!ClassFile.parseFileDir(name).equals("")) {
                File f = new File("jasper.out" + File.separatorChar + ClassFile.parseFileDir(name));
                fileName = "jasper.out" + File.separatorChar + fileName;
                if (!f.exists()) {
                    f.mkdirs();
                }
            }
            PrintStream out = new PrintStream(new FileOutputStream(fileName));
            this.attributes.jasmin(out);
            if ((this.accessFlags & 0x200) > 0) {
                out.print(ClassFile.pad(".interface", 25));
            } else {
                out.print(ClassFile.pad(".class", 25));
            }
            out.println(String.valueOf(this.accessString()) + this.pool.toString(this.thisClass));
            if (this.superClass > 0) {
                out.println(String.valueOf(ClassFile.pad(".super", 25)) + this.pool.toString(this.superClass));
            }
            this.interfaces.jasmin(out);
            out.println("");
            this.fields.jasmin(out);
            out.println("");
            this.methods.jasmin(out);
            System.out.println("Generated: " + fileName);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public static String pad(int n, int pad) {
        return ClassFile.pad(String.valueOf(n), pad);
    }

    public static String pad(String s, int pad) {
        StringBuffer a = new StringBuffer(pad);
        int i = 0;
        while (i < pad) {
            a = a.append(" ");
            ++i;
        }
        return String.valueOf(s) + a.substring(s.length());
    }

    public static String parseFileDir(String s) {
        String fileDir = s;
        fileDir = fileDir.replace('/', File.separatorChar);
        int i = (fileDir = fileDir.replace('\\', File.separatorChar)).lastIndexOf(46);
        if (i > 0) {
            fileDir = String.valueOf(fileDir.substring(0, i).replace('.', File.separatorChar)) + fileDir.substring(i);
        }
        fileDir = fileDir.lastIndexOf(File.separatorChar) >= 0 ? fileDir.substring(0, fileDir.lastIndexOf(File.separatorChar) + 1) : "";
        if (!(fileDir = fileDir.replace('.', File.separatorChar)).equals("") && fileDir.charAt(fileDir.length() - 1) != File.separatorChar) {
            fileDir = String.valueOf(fileDir) + File.separatorChar;
        }
        return fileDir;
    }

    public static String parseFileExt(String s) {
        String fileExt = s;
        fileExt = fileExt.lastIndexOf(".") >= 0 ? fileExt.substring(fileExt.lastIndexOf(".") + 1) : "class";
        return fileExt;
    }

    public static String parseFileName(String s) {
        String fileName = s;
        fileName = fileName.replace('/', File.separatorChar);
        int i = (fileName = fileName.replace('\\', File.separatorChar)).lastIndexOf(46);
        if (i > 0) {
            fileName = String.valueOf(fileName.substring(0, i).replace('.', File.separatorChar)) + fileName.substring(i);
        }
        if (fileName.lastIndexOf(File.separatorChar) >= 0) {
            fileName = fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1);
        }
        if (fileName.lastIndexOf(".") >= 0) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }
}

