;**********************************************************************
;                                                                     *
;    Filename:	    AGCVER00.asm                                      *
;    Date:          Jul. 7th, 2005                                    *
;    File Version:   0v0                                              *
;    Files required:        None                                      *
;                                                                     *
;    Author:         Solder                                           *
;    Company:        Fuckin` Good Company                             *
;                                                                     *
;**********************************************************************
;   This file uses a basic code template for PICmicro PIC12F683.      *
;   If interrupts are not used all code presented between the ORG     *
;   0x004 directive and the label main can be removed. In addition    *
;   the variable assignments for 'w_temp' and 'status_temp' can       *
;   be removed.                                                       *
;   Refer to the MPASM User's Guide for additional information on     *
;   features of the assembler (Document DS33014).                     *
;**********************************************************************
; Notes:                                                           
;                 ----__----
;          VDD 1-|*         |-8 VSS
;  GPIO_5/OSC1 2-|          |-7 GPIO_0/AN0
;  GPIO_4/OSC2 3-|  12F683  |-6 GPIO_1/AN1
;  GPIN_3/MCLR 4-|          |-5 GPIO_2/AN2
;                 ----------
;ys`z
;	|[g		pr
;	SIFINT		SIF̐ߌopX܂@iオGbWŊ݁j
;	SELBIAS	o	oCAXσVtg̑IiHoCAXdAL=rfIMj
;	SELGAIN	o	QC̐؂ւ܂iH=1{AL0.5{j
;	CLAMP	o	xfX^NvpMiHNvj
;	SELBYP	o	CWP[^[óiH=m[}AL=r𓮍ԁj
;	OFSADJ		^C~OpŒg}[d
;		o	(ACG[v}ł̏ꍇjPxS/Hp̐M
;
;                 ----__----
;          VDD 1-|*         |-8 VSS
;  GPIO_5/OSC1 2-|          |-7 GPIO_0/AN0
;  GPIO_4/OSC2 3-|  12F683  |-6 GPIO_1/AN1
;  GPIN_3/MCLR 4-|          |-5 GPIO_2/AN2
;                 ----------
;
;yϐz
;	LCOUNT	8bit	݂̑̈ʒuJEg
;	ADCVAL	10bit	ADϊœǂݎlۑ
;	INTERV	16bit	O݂̊Ō̂肱݂܂łTimer1JEgl
;	LASTSIF	8bit	O|[OƂ̒l
;
;y萔z
;	OFFSET	16bit	ؑփpX̔x
;	BIASWL	8bit	oCAXdo͂pX̕iBetween Gain Up)
;	BIASWR	8bit	oCAXdo͂pX̕ (Between Gain Down)
;	HWIDTH	16bit	HSYNC؂ւspX̕
;	VWIDTH	16bit	VSYNC؂ւspX̕
;	CLAMPD	16bit	QCؑւĂyfX^NvJn܂ł̃ItZbg
;	CLAMPW	8bit	yfX^NvpX̕
;**********************************************************************

	list      p=12F683        ; list directive to define processor
	#include <p12F683.inc>    ; processor specific variable definitions

	errorlevel  -302          ; suppress message 302 from list file

	__CONFIG   _FCMEN_ON & _IESO_OFF & _CP_OFF & _CPD_OFF & _BOD_OFF & _MCLRE_OFF & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT 

; '__CONFIG' directive is used to embed configuration word within .asm file.
; The lables following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.


;***************************************************
; ϐ`ƃWX^t
;***************************************************
COUNT1 		EQU	0x20 	; [vJE^1
COUNT2 		EQU	0x21 	; [vJE^2
COUNT3 		EQU	0x22 	; [vJE^3
COUNT4 		EQU	0x23 	; [vJE^4

COUNT 		EQU 	0x24
LCOUNT		EQU	0x25	; ̃JEgl
ADCVALL		EQU	0x26	; ADC̒lۑiʁj
ADCVALH		EQU	0x27	; ADC̒lۑi)
INTERVL		EQU	0x28	; SIF݊Ԋȗliʁj
INTERVH		EQU	0x29	; SIF݊Ԋȗli)
SIFCOPY		EQU	0x2A	; OSIFDET̒l

WBUF 		EQU 	0x70    ; variable used for context saving
SBUF 		EQU 	0x71    ; variable used for context saving



;***************************************************
; }N`
;***************************************************

	;****************
	; Horizontal Lines
	;****************
#define	LINEMAX	D'226'		; Number of the Bottom H-Line
#define	SIFPORT	GPIO,2		; GP2 pin as SIF Detector
#define	LASTSIF	SIFCOPY,2		; Bitfield of Lasttime SIFDET
#define	SIF_HI	B'00000100'	; Same Value as SIFDET
#define	SIF_LO	0	
	;****************
	; SELECT BANK1
	;****************
BANK1	MACRO
	BSF	STATUS,RP0
	ENDM

	;****************
	; SELECT BANK0 	(Should Selct After BANK1 Changed )
	;****************
BANK0	MACRO
	BCF	STATUS,RP0
	ENDM

	;****************
	; CLAMP CONTROL	(H=Clamping, L=Free)
	;****************
CLAMP_ON	MACRO
	BSF	GPIO,1
	ENDM

CLAMP_OFF	MACRO
	BCF	GPIO,1
	ENDM

	;****************
	; GAIN CONTROL 	(H=x1.6,   L=x0.8)
	;****************
GAIN_HI	MACRO
	BSF	GPIO,4
	ENDM
GAIN_LO	MACRO
	BCF	GPIO,4
	ENDM

	;****************
	; Y FIX CONTROL 	(H=FixedBias, L=Video)
	;****************
YFIX_ON	MACRO
	BSF	GPIO,5
	ENDM
YFIX_OFF	MACRO
	BCF	GPIO,5
	ENDM




;**********************************************************************
;Zbg̏
;**************************************************
	ORG     0x000             ; processor reset vector
	GOTO    main              ; go to beginning of program

;**************************************************
;ݏ
;**************************************************
	ORG     0x004             ; interrupt vector location
INTPROC	
	;**************************************************
	; WX^ޑޔ
	;**************************************************
	MOVWF WBUF	; save off current W register contents
	MOVF STATUS,W	; move status register into W register
	BCF STATUS,RP0
	MOVWF SBUF	; save off contents of STATUS register

	;CJEglZbg
	MOVLW	LINEMAX	; 
	MOVWF	LCOUNT	; JEgl

	;**************************************************
	; ^C}[0ăX^[g
	;**************************************************
	MOVLW	D'192'	; ReloadValue=255-64
	MOVWF	TMR0	; Set Timer0
QUIT	
	;**************************************************
	;  S荞݃tONA
	;**************************************************
	MOVLW	B'11111000'
	ANDWF	INTCON,F

	;**************************************************
	; WX^ޕA
	;**************************************************
	SWAPF SBUF,W 
	MOVWF STATUS
	SWAPF WBUF,F
	SWAPF WBUF,W
	RETFIE
	;**************************************************



;**********************************************************************
; CvO
;**********************************************************************
main
	;**************************************************
	; o̓WX^[֌W
	;**************************************************

	;  oNPWX^[Q̐ݒ

	BANK1 			; Bank 1 ֐ؑ

	;NbN\[X̐ݒ
	MOVLW	B'01110001'	; Internal 8MHz Clock
	MOVWF	OSCCON		; Set It

	; ̐ݒ
	MOVLW	B'00000000'	; Indivisual PullUp, Fall Edge INT
	MOVWF	OPTION_REG	; Set INT Edge Direction

	; ADCNbNƃ|[g̃[hݒ
	MOVLW	B'01110000'	; ADC0 uses RC Clock
	MOVWF	ANSEL		; Set ADC0 as Analog Input

	; |[g̃RtBO[V
	MOVLW	B'00001100'	; GP2 and GP3 are Inputs, others are Outputs		
	MOVWF	TRISIO		; Set it

	MOVLW	B'00110111'	; All Pullup function enabled
	MOVWF	WPU		; Set it

	;**************************************************

	;  oN0WX^[Q̐ݒ

	BANK0	 		; Bank 0 ֖߂

	; ADC̏
	;MOVLW	B'10000011'	; ADC0 ref=VDD
	;MOVWF	ADCON0		; Set it

	; ^C}[Ppr̐ݒ
	;MOVLW	B'00000101'	; Timer1 as Capture Mode
	;MOVWF	CCP1CON		; RiseEdge GP2 Set it

	MOVLW	B'00000000'	; Internal Clock Source
	MOVWF	T1CON		; Set It

	; |[gl̏o
	MOVLW	B'00111111'	; Initial Output Port Value
	MOVWF	GPIO		; S|[g=H


	;**************************************************
	; ݂ݒisj
	;**************************************************
	MOVLW	B'00100000'	; Disable Timer0 INT
	MOVWF	INTCON

	;**************************************************
	; [N̈̏
	;**************************************************
	MOVLW	LINEMAX	; 
	MOVWF	LCOUNT	; JEgl
	CLRF	INTERVH	; SIFԊul̃NA
	CLRF	INTERVL	

	;**************************************************
	; ^C}[PZbg
	;**************************************************
	;CLRF	TMR1L
	;CLRF	TMR1H	


	;**************************************************
	; MoHoCpXԂɐݒ
	;**************************************************
	YFIX_OFF		; Bypass = ON
	GAIN_HI

	;**************************************************
	; H肷܂5b҂
	;**************************************************
	CALL 	TIME1S ; Pb҂
	CLAMP_OFF
	CALL 	TIME1S ; Pb҂
	CLAMP_ON
	CALL 	TIME1S ; Pb҂
	CLAMP_OFF
	CALL 	TIME1S ; Pb҂
	CLAMP_ON
	CALL 	TIME1S ; Pb҂
	CLAMP_OFF

	;**************************************************
	; ADCl̓ǂݎƕϐւ̃Zbg
	;**************************************************
	;BSF	ADCON0,GO	; ϊX^[g
	;BTFSC	ADCON0,GO	; I`FbN
	;GOTO	$-1	; Not Completed Check Again
	; ϐ֕ϊlZbg
	;MOVF	ADRESH,W	; Read Upper 2bits
	;MOVWF	ADCVALH
	;BANK1		; Select Bank1
	;MOVF	ADRESL,W	; Read Lower 8bits
	;MOVWF	ADCVALL
	;BANK0		; Select Bank0


	;**************************************************
	; ݂
	;**************************************************
	MOVLW	B'10100000'	; Enable Timer0 INT and Clear Flag
	MOVWF	INTCON

;**********************************************************************

MLOOP	;**************************************************
	; SIFGbWo i6 Cycles Loopj
	;**************************************************
	BTFSS	SIFPORT	; if (SIFPORT==L)
	GOTO	STORESIF	; 	then jump 

	BTFSS	LASTSIF	; else if (SIFPORT==H && LAST==L)
	GOTO	HSYNC	; 	then jump

	BSF	LASTSIF	; save H
	GOTO	MLOOP

STORESIF	BCF	LASTSIF	; save L
	GOTO	MLOOP


	;**************************************************
	; H-Sync
	;**************************************************

HSYNC	;ɎԂ|̂ŎɓǂނƂɂSIFPORTLɑJڂĂƉ

	;**************************************************
	; ^C}[0ăZbg
	;**************************************************
	MOVLW	D'192'	; ReloadValue=255-64
	MOVWF	TMR0	; Set Timer0

	NOP
	NOP

	CLAMP_ON	; yfX^NvpMo
	NOP
	CLAMP_OFF
	
	NOP
	NOP
	NOP
	NOP
	NOP	; Ԋu̒

	YFIX_ON	;oCAXI

	GAIN_LO	;QC(x0.8)0.5{ɐ؂ւ
	
	YFIX_OF	;oCAXI


	; Wait 49S̒x
	MOVLW	D'31'	; 1 cycle
	MOVWF	COUNT4	; 1 cycle
	NOP
	NOP
	NOP
	NOP
LOOP49U
	DECFSZ	COUNT4,F	; 15+2 cycles
	GOTO	LOOP49U	; 15x2 cycles
			; Total 49cycles

	YFIX_ON	;oCAXI

	GAIN_HI	;QC1{(x1.6)ɐ؂ւ

	YFIX_OFF	;oCAXI

	;CJEglfNg
	DECFSZ	LCOUNT,f	; (ŉCłȂ)Ȃ
	GOTO	MLOOP	; 	SIFGbW҂
			; Ȃ
	;GOTO	VSYNC	;	ȂuVSYNCv

	;**************************************************
	; ŉCɑVSYNC̏
	;**************************************************
VSYNC	
	;CJEglZbg
	MOVLW	LINEMAX	; 
	MOVWF	LCOUNT	; JEgl

	;CLAMPJn܂ł̊Ԗ1000uSxiЂ܂Ԃj
	MOVLW	D'255'	; 1 cycle
	MOVWF	COUNT4	; 1 cycle
LOOP999U
	NOP		; 254 cycle
	NOP		; 254 cycle
	NOP		; 254 cycle
	NOP		; 254 cycle
	NOP		; 254 cycle
	DECFSZ	COUNT4,F	; 254+2 cycles
	GOTO	LOOP999U	; 2x254 cycles
			; Total 2036 cycle

	;**************************************************
	; ADCl̓ǂݎƕϐւ̃Zbg
	;**************************************************
	;BSF	ADCON0,GO	; ϊX^[g
	;BTFSC	ADCON0,GO	; I`FbN
	;GOTO	$-1	; Not Completed Check Again
	; ϐւ̃Zbgi
	;MOVF	ADRESH,W	; Read Upper 2bits
	;MOVWF	ADCVALH
	;BANK1		;Bank1
	;MOVF	ADRESL,W	; Read Lower 8bits
	;MOVWF	ADCVALL
	;BANK0


	GOTO	MLOOP

;**********************************************************************



	;**************************************************
	; Non-SCR
	;**************************************************
NONSCR

	MOVLW	0x80
	MOVWF	TMR1H	; Force to Stop Timer1

	;QCHighɐ؂ւ
	GAIN_HI	; x1.6
	RETURN


;**********************************************************************
; Tu[`Q
;**********************************************************************

;**************************************************
; Wait 0.5 Second new 1000000 cicle
;**************************************************
TIME1S
	MOVLW D'167' ; A7H=167
	MOVWF COUNT1
LOOP20
	MOVLW D'8' ; 08H=8
	MOVWF COUNT2
LOOP21
	MOVLW D'248' ; F8H=248
	MOVWF COUNT3
LOOP22
	DECFSZ COUNT3,F
	GOTO LOOP22
	DECFSZ COUNT2,F
	GOTO LOOP21
	DECFSZ COUNT1,F
	GOTO LOOP20
	NOP
	RETURN


;**************************************************
; Wait 125uS SI[_[̃EFCg
;**************************************************
TIME100US
	MOVLW	D'82'	; 1 cycle
	MOVWF	COUNT4	; 1 cycle
	NOP		; 1 cycle
LOOP100U
	DECFSZ	COUNT4,F	; 1x81+2 cycles
	GOTO	LOOP100U	; 2x81 cycles
	RETURN		; 2 cycles
			; Total 250 cycles

;**************************************************
; Wait 10uS S̃EFCg
;**************************************************
TIME10US
	MOVLW	4	; 1 cycle
	MOVWF	COUNT4	; 1 cycle
	NOP		; 1 cycle
	NOP		; 1 cycle
LOOP10U
	DECFSZ	COUNT4,F	; 1x4+2 cycles
	GOTO	LOOP10U	; 2x4 cycles
	RETURN		; 2 cycles
			; Total 20 cycles

;**************************************************
; Wait 500nS * (5+3W) S̃EFCg W=p[^
;**************************************************
TIMEWUS
			; Wreg should set before call
	MOVWF	COUNT4	; 1 cycle
LOOPWU
	DECFSZ	COUNT4,F	; W+2 cycles
	GOTO	LOOPWU	; 2W cycles
	RETURN		; 2 cycles
			; Total 5+3W cycles
	; remaining code goes here



; initialize eeprom locations

	;ORG	0x2007
	;DE	0x00, 0x01, 0x02, 0x03


;**********************************************************************
	END                       ; directive 'end of program'
;**********************************************************************

