/* ==== waveforms.h ==== */


typedef enum {
   BITDEPTH_8=0,
   BITDEPTH_16=1
} bitdepthEnum;

typedef enum {
   WVFM_SINE,
   WVFM_RC_CYCLE, /* waveform for resistor-capacitor charge/discharge cycle */
   WVFM_TRI,
   WVFM_SAW,
     /* 0-3 */
   WVFM_REVSAW, /* sawtooth with positive pulse and downward slope */
   WVFM_SQUARE,
   WVFM_PULSE17, /* pulse for 1/8 of cycle */
   WVFM_PULSE71, /* drop for 1/8 of cycle */
     /* 4-7 */
   WVFM_PINK, /* pink noise */
   WVFM_WHITE, /* white noise */
     /* 8-9 */
   WVFM_TOT /* last+1, purely a marker! */
} waveformEnum;

typedef enum {
   SIGRNG_FULL,
   SIGRNG_01,
   SIGRNG_TOPHALF
} waveRangeEnum;

/* macros for accessing waves based on fullscale (32-bit) index; also
   declarations for the tables and the table population function */

/*#define WLEN (1<<32)
-* Does that equal 2^32? */
#define WLEN 4294967296LL
#define HALFLEN (1<<31)
/* HAD said <<31, but testing... */
#define WTO4096 20
/* 4096 is 2^12, W is 2^32. 2^12*2^20 is 2^32 */
#define WTO128K 15
/* 128K is 2^17 W is 2^32. 2^17*2^15 is 2^32 */
#define WTO2048 21
/* 2048 is 2^11, W is 2^32. 2^11*2^21 is 2^32 */
#define WTO1024 22
/* #define WTO??? ?? */

#define GETSIN8(i) (sintab8[i>>WTO4096])
#define GETSIN16(i) (sintab16[(i)>>WTO4096])

#define GETSQUARE8(i)  ( (i< (HALFLEN) )? 127:-127 )
#define GETSQUARE16(i) ( (i< (HALFLEN) )? 32767:-32767 )

#define GETPULSE(i,pulsepos,level,pulselevel)\
   ( ((i>>29)==pulsepos)  ?  (pulselevel):(level)  )

#define GETTRIANGLE8(i) (i&0x7F)
/* fake functions */

/* 00 01 10 11 Slope rises in quadrants 00 and 11, falls in 01 and 10
   Slope is +ve in quadrants 00 and 01, -ve in 10 and 11 */
#define GETTRIANGLE16(i)\
   ((\
      ( (i & 0x40000000)==( (i & 0x80000000) >>1) ) ?\
       ((i>>15)&0x7FFF) /* quadrant 00 or 11 */\
      :32767-((i>>15)&0x7FFF)\
    )-(\
      32767*(i>>31))\
   )


#define GETSAW8(i)\
   (\
      (i< (HALFLEN) ) ?\
        ( (i>>24)& 0x7F )\
       :( (signed) (0x7F & \
         ((( i>>24 )& 0x7F) -1)\
           ) )-127\
   )
#define GETSAW16(i)\
   (\
      (i< (HALFLEN) ) ?\
        ( (i>>16)& 0x7FFF )\
       :( (signed) (0x7FFF & \
         ((( i>>16 )& 0x7FFF) -1)\
           ) )-32767\
   )
/* --Sawtooths */

#define GETPINK8(i) (pinktab8[i>>WTO2048])
#define GETPINK16(i) (pinktab16[i>>WTO128K])

#define GETWHITE8(i) (whitetab8[i>>WTO4096])
#define GETWHITE16(i) (whitetab16[i>>WTO1024])


extern short sintab16[];
extern signed char sintab8[];

/* pink noise */
extern signed short pinktab16[];
extern signed char pinktab8[];

/*white noise */
extern short whitetab16[];
extern signed char whitetab8[];

/* protos */
void fillSinTab();

/* void fillNoiseTab(); */
void fillPink16Tab(unsigned short seed);
void fillPink8Tab(unsigned short seed);
void fillWhite16Tab(unsigned short seed);
void fillWhite8Tab(unsigned short seed);

/* === end of waveforms.h === */
