/* ==== waveforms.c ==== */
/* Part of the Patel synthesizer program */

#include <math.h>
#include "pseudorandom.h"
short sintab16[4096];
signed char sintab8[4096];

/* rising ramps with instantaneous fallback; sometimes referred to as triangle*/
short sawtoothtab16[4096];
signed char sawtoothtab8[4096];

/* symmetric up-and-down ramps; sometimes referred to as sawtooth */
/* 
short triangletab16[4096];
signed char triangletab8[4096];
--now done algorithmically */

/* wouldn't it be pretty simple to reconstruct squaretab16 elements from
   squaretab8 ones? For that matter, couldn't they be given in a very very
   simple expression, like ((n<2048)?(+MAX):(-MAX))   ? */
/* short squaretab16[4096];
signed char squaretab8[4096]; */

/* Also at RC-forms, to model resistor-capacitor voltage levels? */

short pinktab16[131072];
signed char pinktab8[2048];
/* what would be appropriate lengths for these?!
 Well, must be at least *double* number of bits representable in storage
 space, so that MSB is able to *change* without having to change it at the
 start, which would be wrong. */

short whitetab16[4096];
signed char whitetab8[1024];
/* or these? */

/* Ok, we should use simple macros to get relevant values for these, perhaps?
   Yes, but they'd be in a header :) */

/* The synthesizing routine accesses the waves by a 32-bit index; the full
   32-bit range of which represents *1 wavelength*. To access the ~12bit
   tables, you do a *shift* to keep only the most significant bits. In this
   way, different frequencies can be represented by integer increments to
   the index, and the waveforms come out pretty much the right length :) */

/* Each sample-width tick, the index is incremented by f*(2^32)/r
   where f is frequency and r is the samplerate of the output
   (usually 44,100 on PC soundcards, but maybe 32000, 48000, or for some
   old workstations, 8000); 2^32 is still equivalent to 1 wavelength */

void fillSinTab() {
   int i;
   for(i=0;i<4096;i++) {
       sintab16[i]=32767*sin((i*M_PI)/2048);
       sintab8[i]=127*sin((i*M_PI)/2048);
   }
}

/* void fillNoiseTab() */
   /* Should get several *banks* each of pink and white noise; perhaps
   one for each channel or something, whether the banks would be tied to
   the channel or to specific voices. But it'd then be possible to set a
   different seed for each bank, which could plausibly give somewhat
   different noises (probably only in the lower octaves) */

   /* First sample of pink noise table must be only 1 bit changed from the
   *last* sample, so there isn't a big spike across all octaves! How to do
   this? -- NO!! First sample of pink noise table must be *EXACTLY THE SAME*
   as the last sample!! See elsewhere */

/* --- */
void fillPink16Tab(unsigned short seed) {
   signed short currentMask16=~0;
   signed short currentNoise16=0; /* first sample starts as 0, and is
                                     replaced on 2nd pass using mask */
   signed short mask16[32768]; /* for first half of pink noise table */
   signed short bitPos, bitSelector16;
   unsigned long counter;
   struct pr_bitSeed bitSeed;
   /* -- */
   randomiseBitgen(&bitSeed,seed);
   for(counter=1;counter<131072;counter++) {
      for(bitPos=0;bitPos<16;bitPos++) {
         bitSelector16=(unsigned short)1<<bitPos;
         /* could we just bitSelector<<=1 or something?*/
         if((counter & bitSelector16) >0) {
            /*bit bitPos is set in counter */
            if(counter<32768) { /* first half */
              currentMask16&=~(bitSelector16);
              mask16[counter]=currentMask16;
              /* switch off bit bitPos in mask (for 2nd pass) */
            }
            currentNoise16&=~(bitSelector16);
            /*currentNoise16|=(bitSelector16*randBit(&bitSeed));
            */
            currentNoise16|=(bitSelector16*(rand()&0x1));
            pinktab16[counter]=currentNoise16;
            /* set bit bitPos of noise to random bit */
            break; /* exit bitPos loop */
         }
      } /* At this point, is bitPos 16? */
   }
   /* wrap around pink16 */
   /*
   bitSelector16=1<<16; -* modify MSB to put in sample 0 *-
   currentNoise16&=~(bitSelector16);
   currentNoise16|=(bitSelector16*randBit());
    The reason we *don't* do that is that it would put the MSB in the same
    octave as the next bit. Seriously. We just leave it *unchanged* instead. */
   pinktab16[0]=currentNoise16;
   for(counter=1;counter<32768;counter++) {
      /* replace untouched bits of first half with bits of sample 0 */
      pinktab16[counter]|=(currentNoise16 & mask16[counter]);
   }
}

void fillPink8Tab(unsigned short seed) {
   signed char currentMask8=~0;
   signed char currentNoise8=0; /* see currentNoise16 */
   unsigned char mask8[128]; /* for first half of pink noise table */
   unsigned short counter,bitPos;
   signed char bitSelector8;
   struct pr_bitSeed bitSeed;
   /* -- */
   randomiseBitgen(&bitSeed,seed);
   for(counter=1;counter<2048;counter++) {
      pinktab8[counter]=currentNoise8;
      /* default to no change in case of fall-through */
      for(bitPos=0;bitPos<8;bitPos++) {
         bitSelector8=(unsigned char)1<<bitPos;
         if((counter & bitSelector8)>0) {
            /* bit bitPos is set in counter */
            if(counter<128) { /* in first segment */
               currentMask8&=~(bitSelector8);
               mask8[counter]=currentMask8;
               /* switch off bit bitPos in mask (for 2nd pass) */
            }
            currentNoise8&=~(bitSelector8);
            currentNoise8|=(bitSelector8*randBit(&bitSeed));
            pinktab8[counter]=currentNoise8;
            /* set bit bitPos of noise with random bit */
            break; /* EXIT the bitPos loop, which I forgot to do before :D */
         }
      }
   }
   /* wrap around pink8 */
   /* bitSelector8=1<<8; -* modify MSB to put in sample 0 *-
   currentNoise8&=~(bitSelector8);
   currentNoise8|=(bitSelector8*randBit() );
     See explanation in fillPink16Tab() and at declarations for tables above */
   pinktab8[0]=currentNoise8;
   for(counter=1;counter<128;counter++) { /* second pass, short */
      pinktab8[counter]|=(currentNoise8 & mask8[counter]);
   }
}

void fillWhite8Tab(unsigned short seed) {
   unsigned short counter;
   struct pr_numSeed numSeed;
   randomiseNumgen(&numSeed,seed);
   for(counter=0;counter<1024;counter++) {
      whitetab8[counter]=randNum8(&numSeed);
   }
}

void fillWhite16Tab(unsigned short seed) {
   unsigned short counter;
   struct pr_numSeed numSeed;
   randomiseNumgen(&numSeed,seed);
   for(counter=0;counter<4096;counter++) {
      whitetab16[counter]=randNum16(&numSeed);
   }
}

/* === end of waveforms.c === */
