#!/usr/bin/perl -w
# Reads in a simple score for one instrument on one channel, turns it into
# a PPF file for the Patel synthesizer.
# Score format:
# .  no change
# A0-G6, A#0-G#6, etc   start note
# ^  release/cut note
# Newlines and space are ignored.
# The PPF format is described elsewhere, but is what most of the CLI tools
# that I made for Patel work on.
# PPF output uses instrument 0, channel 0 for everything, and has a
# default instrument definition (simple sine wave, no harmonics/envelope etc).
# Header defines 4 channels and 1 instrument, for lowest-common denominator.

$note=0; #don't support any other PPF variables here

print "c4\ni00\nI\n"; #header
print "D\n"; #sole instrument

print "c0\ni00\n"; #only channel and instrument for this PPF

while(<>) { #read stdin or set of files
  while (s/^\s*([.^]|[A-G]\#?[0-7])//) {
     $cmd=$1;
     #print "$cmd\n";
     if($cmd eq '^') {
        print "R\nL\n"; #release, should work unless instrument needs "cut" :P
        #Yes, instruments that require "cut" is a bug.
        next;
     }
     if($cmd eq '.') {
        print "L\n";
        next;
     }
     $newNote=getNoteNumber($cmd);
     if($newNote!=$note) {
        $note=$newNote;
        setNote($note);
     }
     print "P\nL\n";
  }
  unless(/^\s$/) {
     die "Bad line of score data: $_\n";
  }
}

sub setNote {
  my($note)=@_;
  $hex=uc(sprintf("%02x",$note));
  print"n$hex\n";
}

sub getNoteNumber {
  my($noteSym)=@_;
  my($octave,$noteNum,$sharpness,$retVal);
  $noteSym =~ /([A-G])(\#?)([0-7])/;
  $noteNum=(0,2, -9,-7,-5,-4,-2)[(ord($1))-(ord("A"))];
  #0,2,3,5,7,8,10
  $sharpness=($2 eq '#')?1:0;
  $octave=$3;
  #print "NOTE: $1 -> $noteNum $2 -> $sharpness $3 -> $octave\n";
  $retVal=($octave*12)+$noteNum+$sharpness;
  if($retVal<0 || $retVal>83) {
    die "Note $noteSym out of range!\n";
  }
  return $retVal;
}

#end
