/* ==== update.h ==== */
/* called every N samples to start+stop notes, etc based
   on input from file (might change later to get it from
   array, and later still to get from buffers) */

/* duration of a line should be determined (like in other trackers) by
   combination of "tempo" and BPM and of samplerate.
   125 BPM translates to 125/60 beats per second; don't know how tempo
   comes into play.
   At 44100 samples/s, 1 BPS is every 44100 samples.
   2 BPS is every 22050 samples. 125/60 BPS is a beat every
   (44100*60)/125 samples.
   ISTR that lower tempo makes tracks play faster, higher makes them slower.
   But how does the beat frequency give the *line* frequency?

   NB: Usual speed of 6/125 in mikmod seems ~equivalent to 1/8 second
   per line, which is 5512.5 samples. Now, how do we deal with *half*
   samples? Maybe use fixed-point counters, with say 2 or 3 fractional
   bits. When the counter meets or *exceeds* the target value, decrement
   it by the target value; in this way, every few lines, there will be a
   "leap sample" ;) It still has limited accuracy, but what can you do?
   *ponder* Ok, as we'd be counting with longs and max samplerate is 44,100,
   there's at most *16* bits that could be used for fractions. So let's use
   about 6 bits. If we use *too* many, it's a problem if someone wants to
   have *superlong* lines :-O If using 6 bits for fractions, maximum duration
   of a line is 1024 seconds :D I think it's longer if lower samplerates
   are used, but that gets messy... */

int update();

/* === end of update.h === */
