/* ==== update.c ==== */
/* called every N samples to start+stop notes, etc based
   on input from file (might change later to get it from
   array, and later still to get from buffers) */

#include <stdio.h> /* temporary */
#include "waveforms.h" /* for instrument */
#include "instrument.h" /* for note */
#include "note.h"
#include "parser.h"

modeDesc_t playmode={{
   {0,0,0}, /* a */
   {0,0,0}, /* b */
   {1,0,7}, /* c==channel */
   {0,0,0}, /* d */
   {0,0,0}, /* e */
   {0,0,0}, /* f */

   {0,0,0}, /* g */
   {0,0,0}, /* h */
   {2,0,255}, /* i==instrument; had thought 128 instruments, don't know why*/
   {0,0,0}, /* j */
   {0,0,0}, /* k */
   {0,0,0}, /* l */
   {0,0,0}, /* m */

   {2,0,84}, /* n==note/tone */
   {0,0,0}, /* o */
   {1,0,14}, /* p==panning; odd number of values so centre selectable */
   {0,0,0}, /* q */
   {0,0,0}, /* r */
   {0,0,0}, /* s */

   {0,0,0}, /* t */
   {0,0,0}, /* u */
   {2,0,255}, /* v==volume; could have 0 illegal, use sepearate stop command?*/
   {0,0,0}, /* w */
   {0,0,0}, /* x */
   {0,0,0}, /* y */
   {0,0,0} /* z */
}};

/* duration of a line should be determined (like in other trackers) by
   combination of "tempo" and BPM and of samplerate.
   125 BPM translates to 125/60 beats per second; don't know how tempo
   comes into play.
   At 44100 samples/s, 1 BPS is every 44100 samples.
   2 BPS is every 22050 samples. 125/60 BPS is a beat every
   (44100*60)/125 samples.
   ISTR that lower tempo makes tracks play faster, higher makes them slower.
   But how does the beat frequency give the *line* frequency? */

int update() {
   char comChar;
   int endLine=0;
   static commandPacket_t commandPacket= {
      'a',0,
     {0,0,0,0, 0,0,0,0, 0,0,0,0,0,
      0,0,0,0, 0,0,0,0, 0,0,0,0,0}
   };
   /* how do we store the state variables? Static? global? Pointer to
      struct as an argument, to be reentrant or whatever? Meh, I don't
      think *that* is much concern here, just go for static I think. */
   /* Now the state variables are in a static struct, haha :) */

   /* start loop here, which ends when line-end command given */
   while(!endLine) {
      if(-1==getCmd(&playmode, &commandPacket)) {
         /* ERROR! Might at some point put details in command packet? */
         /* Now "type" gives error if any */
         if(commandPacket.type!=PARSED_EOF) {
            displayError(commandPacket.type);
         }
         return(1); /* HAVEN'T YET DECIDED THIS? */
      }
      if(commandPacket.type==1) {
         switch(commandPacket.cmd) {
           /* lower case chars are variable-setting, and have args;
              upper case chars are updating commands, and have no args.
              Now, the parser deals with that, we just check which updating
              commands are used.*/
           case 'P': playNote(getVar('c'),getVar('i'),getVar('n'));
                     break;
           case 'C': cutNote(getVar('c'));
                     break;
           case 'R': releaseNote(getVar('c'));
                     break;
           case 'L': endLine=1;
                     break;
           default: fprintf(stderr,"ERROR in parsing song: Unknown command\n");
                    return(1); /* Is this appropriate value? */
         }
      }
      /* if it was type 0, parser has dealt with it already ^_^ */
   }
   /* if command was to finish the line, return now */
   return(0); /* good, but should it be 0, 1, -1? */
   /* return value is whether or not song has finished. Must work
      out what is interpretation of value */
}

/* === end of update.c === */
