/* ==== pseudorandom.c ==== */
/* outputs not-really random bits and bytes */

#include <stdlib.h>
#include "pseudorandom.h"

unsigned int randBit(struct pr_bitSeed *seed) {
   unsigned int bit,flip,idx;
   bit=seed->lastBit;
   idx=seed->idx;
   flip=((seed->num) & (1<<idx)) >0;
   bit^=flip;
   seed->lastBit=bit;
   (idx<15)?(seed->idx)++ : ((seed->idx)=0);
   return((rand()&1048576)>0);
   return (bit);
}


unsigned char randNum8(struct pr_numSeed *seed) {
   static rm_bits=(4*sizeof(RAND_MAX))-8;
   return(rand()>>rm_bits);
}

unsigned short randNum16(struct pr_numSeed *seed) {
   static rm_bits=(4*sizeof(RAND_MAX))-16;
   return(rand()>>rm_bits);
}

void randomiseNumgen(struct pr_numSeed *seedBox, unsigned short seed) {
   seedBox->num=seed;
}
void randomiseBitgen(struct pr_bitSeed *seedBox, unsigned short seed) {
   seedBox->num=seed;
   seedBox->lastBit=0;
   seedBox->idx=0;
}
/* ===end of pseudorandom.c === */
