/* ==== process.h ==== */
/* macros for use in process.c and other places? */

#define SETSIGNAL(var,bitdepth,bias,waveform, index) \
  macrotempvar=waveform+(WVFM_TOT*bitdepth);\
  switch(macrotempvar) { \
     case WVFM_SINE:\
        var=GETSIN8(index);\
        break;\
     case WVFM_RC_CYCLE:\
        var=0;\
        break;\
     case WVFM_TRI:\
        var=GETTRIANGLE8(index);\
        break;\
     case WVFM_SAW:\
        var=GETSAW8(index);\
        break;\
     case WVFM_REVSAW:\
        var=0;\
        break;\
     case WVFM_SQUARE:\
        var=GETSQUARE8(index);\
        break;\
     case WVFM_PULSE17:\
        /* i,pos, base level, pulse level */\
        var=GETPULSE(index,1,-127,127);\
        break;\
     case WVFM_PULSE71:\
        var=GETPULSE(index,5,127,-127);\
        break;\
     case WVFM_PINK:\
        var=GETPINK8(index);\
        break;\
     case WVFM_WHITE:\
        var=GETWHITE8(index);\
        break;\
     /* --- Now 16 bit forms --- */\
     case WVFM_TOT+WVFM_SINE:\
        var=GETSIN16(index);\
        break;\
     case WVFM_TOT+WVFM_RC_CYCLE:\
        var=0;\
        break;\
     case WVFM_TOT+WVFM_TRI:\
        var=GETTRIANGLE16(index);\
        break;\
     case WVFM_TOT+WVFM_SAW:\
        var=GETSAW16(index);\
        break;\
     case WVFM_TOT+WVFM_REVSAW:\
        var=0;\
        break;\
     case WVFM_TOT+WVFM_SQUARE:\
        var=GETSQUARE16(index);\
        break;\
     case WVFM_TOT+WVFM_PULSE17:\
        var=GETPULSE(index,1,-32767,32767);\
        break;\
     case WVFM_TOT+WVFM_PULSE71:\
        var=GETPULSE(index,5,32767,-32767);\
        break;\
     case WVFM_TOT+WVFM_PINK:\
        var=GETPINK16(index);\
        break;\
     case WVFM_TOT+WVFM_WHITE:\
        var=GETWHITE16(index);\
        break;\
     default:\
        madeBlooper(0); /* FIX */\
  } \
  /* END of macro */

/* === end of process.h === */
