/* ==== process.c ==== */
/* process waveform data into buffers */

#include <sndfile.h>
#include <assert.h>
#include <stdint.h>
#include "update.h"
#include "waveforms.h"
#include "instrument.h"
#include "note.h"
#include "process.h" /* for macros */

/* channelsUsed can be 4 or 8 */
/* unsigned int channelsUsed=4; -Now in note.[ch] */

/* is this function to be called for each set of samples output, or does
  it call state management functions itself every few samples and then
  continue? Which is better?
  AHA! It should *probably* call the state management functions *itself*,
  because it's easier for it to notice partway through a buffer, "Ah, it
  is time now to update the state" and do that and come back, than to be
  called in such a way as to process *part* of a buffer, return, then
  after state has been processed, be called again to process the rest
  of the buffer. Such an arrangement would be quite gnarly. */
void processData() {
   /*some sort of */ short buf[128];
   /* really, ought to have 2 buffers, for stereo sound;
   do panning later though, and figure out how to pass stereo
   data to libsndfile */
   int i,ch,finished=0;
   unsigned long lineCounter=0;
   unsigned long lineDur=5512*64;/*6-bit fixed-point fractions,1/8 sec lines*/
   unsigned long incr, freqMult;
   signed short fmDisplacement,unDisplacement;
   long mix;
   uint64_t temp64;
   unsigned int macrotempvar;
   signed short out[8]={0,0,0,0, 0,0,0,0};
   signed short signaltemp;
   unsigned short freqShift;
    /* right-shift to u64 product of incr*freqmult, needed to get effIncr */
   unsigned int mixShift=(channelsUsed==4)?2:3;
   unsigned short vol; /* volume multiplier */
   instrument_t *thisInstrument;
   SF_INFO soundinfo;
   SNDFILE *outwave;
   assert(channelsUsed==4||channelsUsed==8);
   soundinfo.samplerate=rate;
   soundinfo.channels=1;
   soundinfo.format=SF_FORMAT_WAV|SF_FORMAT_PCM_16;
   outwave=sf_open("synthoutput.wav",SFM_WRITE,&soundinfo);

#define chVar(elem) (channelData[ch].elem)
#define instrVar(elem) (thisInstrument->elem)

   while(!finished) {
      for(i=0;i<128;i++) {
        for(ch=0;ch<channelsUsed;ch++) {
          if(!chVar(playing) ) continue;  /* or use incr==0? */
          thisInstrument=instrumentData+chVar(instrumentNo);
          /* do stuff */
          SETSIGNAL(signaltemp, BITDEPTH_16, 0, instrVar(toneShape), chVar(toneIndex) )
/*          out[ch]=GETSIN16(chVar(toneIndex) ); */
          out[ch]=(signaltemp>>2)*3;
          /* now add harmonic+overtone, set to appropriate amplitude */
          SETSIGNAL(signaltemp, BITDEPTH_16, 0, instrVar(harmShape), chVar(harmIndex) )
          /* out[ch]+=(GETSIN16(chVar(harmIndex))>>2); */
          out[ch]+=(signaltemp>>2);
          /* --- */

          /* any FM mod to fundamental frequency (and to harmonic?) */
          if(chVar(fmIncr) >0) {
            SETSIGNAL(signaltemp,BITDEPTH_16, 0, instrVar(fmShape), chVar(fmIndex) )

            /* fmDisplacement=(instrVar(fmDepth)
               * GETSIN16( chVar(fmIndex) )
               )/32768; */
            fmDisplacement=(instrVar(fmDepth)*signaltemp)/32768;
            chVar(fmIndex)+=chVar(fmIncr);
            /* fmDisplacement is in pseudocents */
            /* extract octaves, 16ths, and pseudocents from that */
            /* --- */
            if(fmDisplacement!=chVar(fmDisplacement) ) {
              chVar(fmDisplacement)=fmDisplacement;
              if(fmDisplacement>=0) {
                  /* see note.[ch] */
                  freqMult=(
                   (fMultUp16s[(fmDisplacement& 0xF0)>>4])
                   * (fMultUpOctents[(fmDisplacement& 0xF)])
                  ); /* no longer includes shift */
                  /* positive displacement :  multiplier>=1 */
                  freqShift=31-(fmDisplacement>>8);
                  /* fmDisplacement>>8 is octaves up */
              } else {
                  unDisplacement=-fmDisplacement;
                  /* see note.[ch] */
                  freqMult=(
                   (fMultDwn16s[(unDisplacement& 0xF0)>>4])
                   * (fMultDwnOctents[(unDisplacement& 0xF)])
                  );  /* no longer includes shift */
                  /* negative displacement : multiplier<1 */
                  freqShift=31+(unDisplacement>>8);
                  /* unDisplacement>>8 is octaves down */
              }
              /* NOTE:  The above currently multiplies 2 shorts, then
              does a shift (left or right by sign), and stores the result
              in another short. This is not good.
              PROPOSED: store the product in a u32, don't do the shift yet;
              Then mutliply the increment by the multiplier into a u64,
              do the shift on that (should always work out rightwards as
              it will incorporate the shift to compensate for the fixed-
              point multiplier, not just shifting for the octave */

              /* freqMult will be 16 bit, MSB of it represents 1 */
              temp64=((unsigned long long)chVar(incr)*(unsigned long long)freqMult);
              chVar(effIncr)=temp64>>freqShift;
              /*
              printf("incr: %ld mult: %ld prod: %lld\n",chVar(incr),freqMult,temp64);
              printf("Shift: %d EffIncr: %d\n",freqShift,chVar(effIncr));
              */
              /* >>15 is division by MSB of freqMult? Not 100% sure */
            }
          } else {
            chVar(effIncr)=chVar(incr);
          }
          /* now increment toneIndex to give appropriate freq.*/
          chVar(toneIndex)+=chVar(effIncr);
          /* and harmIndex */
          chVar(harmIndex)+=(chVar(effIncr)*chVar(harmNum));

          /* Now amplitude modulation+envelopes (just multiplier
          on the signal amplitude) */
          switch(chVar(envType)) {
             case ENV_NONE: break;
             case ENV_ADSR: /* only one supported currently! */
                 switch(chVar(envState.adsr.stage)) {
                    case ADSR_STOPPED:
                    case ADSR_SUSTAIN: break;
                    case ADSR_ATTACK:
                        if((0x7F000000-chVar(envLevel))<=chVar(envGrad)) {
                           /* hit! */
                           chVar(envLevel)=0x7F000000;
                           chVar(envState.adsr.stage)=ADSR_DECAY;
                           /* stage++ would have been slower */
                           chVar(envTarget)=instrVar(envData.adsr.sustainLevel);
                           chVar(envGrad)=instrVar(envData.adsr.decayRate);
                        } else {
                           /* approach... */
                           chVar(envLevel)+=chVar(envGrad);
                        }
                        break;
                    case ADSR_DECAY:
                        if((chVar(envLevel)-chVar(envTarget))<=chVar(envGrad)) {
                           /* hit! */
                           chVar(envLevel)=chVar(envTarget);
                           /* which is ADSR_SUSTAIN, but this is faster */
                           chVar(envState.adsr.stage)=ADSR_SUSTAIN;
                           /* next target is hardcoded (0!) */
                           chVar(envGrad)=instrVar(envData.adsr.releaseRate);
                           /* set that rate even though it's a stage away */
                        } else {
                           /* approach */
                           /* gradients for ADSR are stored unsigned */
                           chVar(envLevel)-=chVar(envGrad);
                        }
                        break;
                    case ADSR_RELEASE:
                        if(chVar(envLevel)<=chVar(envGrad)) {
                           /* back to 0 */
                           chVar(envLevel)=0;
                           chVar(envState.adsr.stage)=ADSR_STOPPED;
                           /* no further target */
                           chVar(playing)=0;
                        } else {
                           /* approach 0 */
                           chVar(envLevel)-=chVar(envGrad);
                        }
                        break;
                    default:
                        madeBlooper(0); /* make new enumeration for this */
                 }
                 break;
             default: break;
          }
          /* Whichever envelope type (or none!) used, do
            out[ch]=(out[ch]*(envLevel>>24)) >>8 */
          vol=chVar(envLevel)>>24; /* also multiply by AM level when done */
          out[ch]=((signed long)out[ch]*vol) /128;

        }
        mix=0;
        for(ch=0;ch<channelsUsed;ch++) mix+=out[ch];
        /* could have done that at the previous loop, but... */
        /* buf[i]=(mix>>mixShift); */
        buf[i]=mix/channelsUsed; /* don't *really* want to do it that way..*/
        /* check if due for new line */
        lineCounter+=64;
        if(lineCounter>=lineDur) {
           /* get new line to process, see if we should stop at the
              end of the buffer */
           finished=update();
           lineCounter-=lineDur;
        }
      }
      if(sf_write_short(outwave,buf,128)!=128) {
          printf("Didn't output right number of items to wavefile!\n");
      }
      /* a(nother) bufferful has been output */
   }
   /* BYE-BYE! */
   sf_close(outwave);
}

/* === end of process.c === */
