/* ==== parser.h ==== */
/* simplistic command file parser for initial prototype version of patel */

/* depends on "commandPacket" being name of the var used */
#define getVar(var) (commandPacket.vars[var-'a'])

typedef enum {
   PARSED_VARSET=0, /* do nothing */
   PARSED_CMD=1, /* act on it */
   PARSED_EOF, /* finish */
   PARSED_BADCOM, /* malformed comment */
   PARSED_BADCMD, /* malformed command */
   PARSED_BUSYLINE, /* command followed by non-whitespace */
   PARSED_BADHEX, /* malformed hexadecimal chars in argument */
   PARSED_BADARG, /* wrong length in argument */
   PARSED_OUTOFRANGE /* argument out of allowed range */
} cmdTypeEnum;

/* stores a command or variable setting */
typedef struct {
   char cmd;
   cmdTypeEnum type; /* 1 for straight command, 0 for variable, others? */
/*   unsigned long val; No longer... */
   unsigned long vars[26]; /* yes, we store all the vars here */
} commandPacket_t;

/* range/scale for variable */
typedef struct {
   unsigned short bytes;
   unsigned long minval; /* do we need this? Could it be short? */
   unsigned long maxval;
} varDesc_t;
/* should be 1 of these for parsing instruments, 1 for parsing songs, and
1 for any other mode we need to parse with. */
typedef struct {
   varDesc_t var[26]; /* 1 entry for each variable */
} modeDesc_t;

int getCmd(modeDesc_t *mode,commandPacket_t *buffer);

void displayError(cmdTypeEnum error);

/* === end of parser.h === */
