/* ==== note.h ==== */


extern unsigned long incrForTone[];
  /* increment table for tones of top octave */
  /* later work out nice way of supporting more than 1 temperament
     within the same song */
extern unsigned short fMultUp16s[];
extern unsigned short fMultUpOctents[];
extern unsigned short fMultDwn16s[];
extern unsigned short fMultDwnOctents[];
/* similar to the incrForTone[] LUT, but for doing fm and/or portamento. */

extern unsigned short rate; /* samplerate in Hz */
extern unsigned int channelsUsed; /* should actually only be 4 or 8? */

typedef enum {
   ADSR_STOPPED=0,
   ADSR_ATTACK,
   ADSR_DECAY,
   ADSR_SUSTAIN,
   ADSR_RELEASE
} adsrStageEnum;

typedef struct {
   unsigned long level;
        /* calculate in range of a long, to catch over/underflow.
         Remap afterwards. MIGHT CHANGE THIS */
   adsrStageEnum stage;
} adsrState_t;
typedef struct {
   unsigned long index; /* in samples */
   unsigned short element; /* of the array that is currently being approached*/
   /* also add local copies of that element */
} graphState_t;


/* The channel datatype */
typedef struct {
   char playing;
   unsigned char instrumentNo; /* which instrument is/was playing now/last */
   unsigned long incr; /* normal increment for the current note */
   envelopeEnum envType; /* yes, duplicated from instrument */
   union {
      graphState_t graph;
      adsrState_t adsr;
   } envState;
   unsigned long envLevel; /* current level (in fixed point) for any envelope*/
   unsigned long envGrad; /* would this be signed for graphical envelopes? */
   unsigned long envTarget; /* level that gradient aims for */

   unsigned long toneIndex; /* index of current sample for fundamental freq */
   unsigned long harmIndex; /*  " " " " for harmonic */
   unsigned long overIndex; /*  " " " " for non-harmonic overtone */
   unsigned long amIndex; /*  " " " " for vibrato (AM) wave */
   unsigned long fmIndex; /*  " " " " for tremelo (FM) wave */
   /* frequency of those (duplicated for fast access) */
   /* - or not - */
   /* add portamento data some time */
   unsigned long fmIncr; /* used enough to put here */
   unsigned char harmNum; /* ditto */
   short fmDisplacement;
      /* *current* displacement (in 256ths of an octave) of tremelo */
      /* (used to see if effective frequency must be recalculated) */
   unsigned long effIncr; /* effective increment for tone, based on
          tremelo and portamento intervals */
} noteinfo_t;

extern noteinfo_t channelData[8];
/* No, we might not use all 8 channels, but... */

/* function protos */
void playNote(int channel, int instrument, int tone);
 /* instrument might be made unsigned char here, limit number of them */

void cutNote(int channel);
void releaseNote(int channel);
/*first stops note instantly, second puts ADSR envelopes in release stage.
  One of these should probably call the other in appropriate circumstances? */

void fillNoteTable(unsigned int rate);
 /* in future make provisions for other temperaments */

void fillFMultTable();
/* LUT tables for frequency modulation/portamento */

/* === end of note.h === */
