/* ==== note.c ==== */
/* start and stop notes playing */

#include <math.h>
#include "blooper.h"
#include "waveforms.h"
#include "instrument.h"
#include "note.h"

unsigned long incrForTone[12];
unsigned short fMultUp16s[16];
unsigned short fMultUpOctents[16];
unsigned short fMultDwn16s[16];
unsigned short fMultDwnOctents[16];

noteinfo_t channelData[8];
unsigned short rate;
unsigned int channelsUsed;

void playNote(int channel,int instrument,int tone) {
   /* tone is 0 for 27.5Hz, which is an A below C0;
      highest is ~84ish, for ~G6? */
   double fincr; /* used to calculate the increment, which involves an
      intermediate value of >2^32 */
   float freq;
   /* --- */
   channelData[channel].playing=1;

   /* Calculate the increment required for reaching the next sample */
/*   freq=27.5*pow(2, ((float)tone)/12); /* for other temperaments, /1200 could be
      used to calculate frequencies for them using cents */
/*   fincr=(freq*(double)WLEN)/rate;
   /* FIX this to use LUT instead!!! */
/*   channelData[channel].incr=(unsigned long) fincr; */
   channelData[channel].incr=
       (incrForTone[tone%12]) >>(6-tone/12);
   printf("Playing tone %d\n",tone);
   channelData[channel].fmIncr=instrumentData[instrument].fmIncr;

   channelData[channel].envType=instrumentData[instrument].envType;
   channelData[channel].harmNum=instrumentData[instrument].harmNum;
   switch(channelData[channel].envType) {
      case ENV_NONE:
          channelData[channel].envLevel=0x7F000000;
          /* full amplitude */
          break;
      case ENV_GR_COMPLEX:
      case ENV_GR_LONG:
          channelData[channel].envState.graph.index=0;
          /* are we using time-based indices, or array elements, level
          and target? Ehhh....
          THOUGHT: Time-based needs a level to increment and the index
          to check when to move onto the next element;
          level+target based AFAICT doesn't need an index apart from the
          array index, which I think the time-based would need *besides*
          the time index. */
          break;
      case ENV_ADSR:
          channelData[channel].envState.adsr.stage=ADSR_ATTACK; /* attack */
          if(instrument!=channelData[channel].instrumentNo) {
             channelData[channel].envLevel=0;
             /* only reset if changing instruments */
          }
          channelData[channel].envGrad=instrumentData[instrument].envData.adsr.attackRate;
          break;
      default:
          /* should have been caught in setup; otherwise a corruption */
          madeBlooper(BLOOP_BADENVTYPE);
   }
   channelData[channel].instrumentNo=instrument;
   /* end */
}

/* Argh, what if a channel has one type of instrument playing and then
   switches to another type, and one or the other is ADSR?! */

void cutNote(int channel) {
   channelData[channel].playing=0;
   channelData[channel].toneIndex=0;
   channelData[channel].harmIndex=0;
   channelData[channel].overIndex=0;
   channelData[channel].amIndex=0;
   /* in what circumstances do we reset fmIndex (to appropriate quadrant)? */
   /*channelData[channel].envIndex=0; ??? */
   /* Hmm, use index for graphical envelopes, and level+state for ADSR ones;
      level is used to determine when ADSR changes state; unlike in e2
      description, our ADSR's slopes will have constant *gradient*, not time;
      the time will be used to calculate the *normal* slope. */
}

void releaseNote(int channel) {
   switch (channelData[channel].envType) {
     case ENV_NONE:
         channelData[channel].playing=0;
         /* simply stop playing. Do *not* reset indices
         (except perhaps fmIndex where appropriate??
         Uh, and possibly amIndex if that is too) */
         break;
     case ENV_ADSR:
         channelData[channel].envState.adsr.stage=ADSR_RELEASE; /* release */
         /* call it adsrState instead? */
         /* if/when adsrLevel goes to 0 in this state, do cutNote */
         break;
     default:
         ; /* I don't bloody know */
   }
}

void fillNoteTable(unsigned int rate) {
   int i;
   double fincr,freq;
   /* these could also be "long doubles", and use "powl()" instead? */
   for(i=0;i<12;i++) {
      /* index 0 is for A, just because */
      /* (actually, it's because A is a known reference note, and
      it's easier to have the reference note the first, even if it's
      possible to calculate the table with it further on instead */

      /* calculate increments for top octave, with full precision; lower
       octaves can right shift to get values with surely as much precision
       as is available? */
      freq=1760*pow(2,((float)i)/12); /* 1760 is A5? */
      fincr=(freq*(double)WLEN)/rate;
      /* gives more than precision of a long anyway */
      incrForTone[i]=(unsigned long) fincr;
   }
}

/* similar function for "octents" (frequency multiplier) tables */
void fillFMultTables() {
   int i;
   /* LUT contents are fixed-point multipliers, with bit 15==1.0 */
   for(i=0;i<16;i++) {
      /* 16ths of an octave */
      fMultUp16s[i]=32768*pow(2,((double)i)/16);
      fMultDwn16s[i]=32768*pow(2,((double)-i)/16);
      /* "Octents" are bitop-friendly 256ths of an octave */
      fMultUpOctents[i]=32768*pow(2,((double)i)/256);
      fMultDwnOctents[i]=32768*pow(2,((double)-i)/256);
   }
}


/* === end of note.c === */
