/* ==== writeppf.c ==== */
/* State machine that takes packets of PPF commands, and writes the lines
of PPF file to the state machine's output file handle */

#include <assert.h>
#include <stdio.h>
#include "ppf.h"

static const char hexSym[]="0123456789ABCDEF";

int PPF_issueCommand(PPF_IOMachine_t *mach,PPF_commandPacket_t *buf) {
   int i,nybbleShift;
   int checkBounds=mach->checkBounds;
   FILE *stream=mach->stream;
   unsigned long tempvalid=buf->validity;
   unsigned long param,mask;
   PPF_modeDefs_t *currentDefs=(mach->firstDefs)+(mach->parseMode);
   PPF_varDesc_t *varDef=currentDefs->vars;

   if(mach->ioType!=PPF_WRITER) return -1;
   /* Just a loop through each parameter position... */
   for (i=0; i<26; i++,tempvalid>>=1,varDef++) {
      if( (tempvalid&1)&&
        (param=buf->params[i], mach->vars[i] != param) ) {
         if(checkBounds && (param < varDef->minval || param > varDef->maxval))
             return -1; /* bad! */
         putc('a'+i,stream);
         nybbleShift=(varDef->digits-1)*4;
         for(mask=0xF <<nybbleShift; mask!=0; nybbleShift-=4,mask>>=4) {
            putc(hexSym[(param&mask)>>nybbleShift], stream);
            /* Hold on, that's really really stupid */
         }
         putc('\n',stream);
         mach->vars[i]=param; /* update state machine */
         /* that parameter now dealt with */
      }
   }
   /* Now print the command letter */
   fprintf(stream,"%c\n",buf->commandChar);
   return 0; /* DONE */
}

/* === end of writeppf.c === */
