/* ==== ppfmachine.c ==== */
/* functions for initialising and changing mode of PPF state machine */

#include <assert.h> /* there's a couple of assertions for sanity */
#include <stdio.h> /* even though we don't do IO here, IOMachines use FILE * */
#include "ppf.h"

int PPF_setMode(PPF_IOMachine_t *mach, unsigned short newMode) {
   int idx,cmdIdx;
   unsigned long testBit;
   /* NB: We don't check newMode is valid. Don't know if we can do that.
   Arrangement of modes is caller's business really. */
   PPF_modeDefs_t *newDefs=mach->firstDefs+newMode;
   /* First, check if new mode is sane...
    -For each variable, see if the number of digits is more than 8
     (which would burst a long)
    -For each variable that has 0 digits, check all commands to see if
     one has that variable valid (we could simply ignore this I suppose...) */
   for(idx=0;idx<26;idx++) {
      if(newDefs->vars[idx].digits>8) {
         fprintf(stderr,"Var %c too big\n",idx+'a');
         return -1; /* var too big */
      }
      if(newDefs->vars[idx].digits==0) {
         testBit=1<<idx; /* test command bitfields against 2^idx */
         for(cmdIdx=0;cmdIdx<26;cmdIdx++) {
            if(newDefs->cmds[cmdIdx]&testBit) {
               fprintf(stderr,"Command %c returns empty var %c\n",cmdIdx+'A',idx+'a');
               return -1;
            }
            /* command no. cmdIdx returns empty var */
         }
      }
   }
   /* reset all vars */
   for(idx=0;idx<26;idx++) {
      mach->vars[idx]=0;
   }
   mach->parseMode=newMode;
   return 0; /* good */
}

void PPF_initMachine(PPF_IOMachine_t *mach,FILE *stream, PPF_IOType_t iotype, PPF_modeDefs_t *defs,int checkBounds) {
   assert (mach!=NULL && stream!=NULL && iotype!=PPF_DEADBEEF && defs!=NULL);
   /* Not sure how useful that is.  Perhaps a return value would be better?*/
   mach->currentState=PPFPS_NEW;
   mach->stream=stream;
   mach->ioType=iotype;
   mach->firstDefs=defs;
   mach->checkBounds=checkBounds;
}

/* === end of ppfmachine.c === */
