/* ==== ppf_internal.h ==== */
/* declarations needed for building the libPPF parser;
   nothing else should need these */

/* internal defs for parser */
typedef enum {
  PPFPC_DIGIT0=0, /* These are all basically the same, */
  PPFPC_DIGIT1=1, /* but for different hex digit characters. */
  PPFPC_DIGIT2=2, /* Having them as separate values makes it */
  PPFPC_DIGIT3=3, /* a little quicker to get the digit read */
  PPFPC_DIGIT4=4, /* without having to create yet another */
  PPFPC_DIGIT5=5, /* LUT to map ASCII values to ints: Each of */
  PPFPC_DIGIT6=6, /* the cases can be merged into the one operation, */
  PPFPC_DIGIT7=7, /* but an action that checks the value switched by. */
  PPFPC_DIGIT8=8, /* The rest of the operation is the most complex */
  PPFPC_DIGIT9=9, /* of the different op types: */
  PPFPC_DIGITA=10, /* Left shift value (by 4), add digit value */
  PPFPC_DIGITB=11, /* (see above), and decrement counter. */
  PPFPC_DIGITC=12, /* If counter is now 0, change state to CLOSEVAL */
  PPFPC_DIGITD=13,
  PPFPC_DIGITE=14,
  PPFPC_DIGITF=15,

  PPFPC_NOP, /* most transitions */
  PPFPC_PREPVAR, /* NEW->SETVAR : set lhs index, clear value buffer to 0 */
  PPFPC_SETCMD, /* NEW->CLOSEPKT */
  PPFPC_FAIL_SYM, /* All these accompany FAIL state; this means a bad char */
  PPFPC_FAIL_SHORT, /* This is a value terminated early */
  PPFPC_FAIL_LONG, /* This is a value that isn't terminated on time */
  PPFPC_EOF, /* Return EOF which isn't really a FAIL most of the time */
  /* PPFPC_DIGIT, -* Now PPFPC_DIGITx above */
  PPFPC_PUTVAL, /* CLOSEVAL->(SPACE/NEW) */
  PPFPC_RETURN /* CLOSEPKT->(SPACE/NEW): sort out params, return packet */
} PPF_parserCmd_t; /* separate primitive commands for state transitions */


typedef struct {
  PPF_parserState_t next/*[128]*/;
  PPF_parserCmd_t op/*[128]*/;
  /* there aren't *actually* 128 valid chars, but it's a lot less than 256! */
  /* NB: Should add 1 to char read such that EOF maps to one of these
     elements. Yes, could cast to signed int and have 256 elements each,
     but I think that'd be slower; So would handling EOF as a special case
     I think. */
}/* [128] */ PPF_parserTransition_t;
/* need one of these for each state enumeration; they should be filled in
by a script based on a LEX-like format describing the transitions for each
state and character class. I already have these worked out at least. */



/* === end of ppf_internal.h === */
