/* ==== ppf.h ==== */
/* include this to use libppf */

/* handy macro */
/* VARB(ch) gives bitfield corresponding to variable ch; to get
   this, define GET_VARB_MACRO. Not on by default because it's
   long and namespace polluting. */

/* In most cases you'll need to vaguely know this */
typedef struct {
  char commandChar; /* Also stores failed var if FAIL_SHORT or FAIL_LONG */
  int parseMode;
/*  unsigned int validity[26]:1; -* would this work?! ...NO! :D */
  /* if not, just use one single ulong, and do the maths by hand :P */
  unsigned long validity;
  unsigned long params[26];
} PPF_commandPacket_t;

/* You need to know the varDesc and modeDefs types, if you're going to
   define your own protocols; if using the protocol for Patel, you can
   use the prewritten defs (wherever I'll put those). I might later add
   functions for manipulating/setting up modeDefs, so if you've got a
   relatively small protocol and will be tweaking it a fair bit you
   wouldn't need to know these then either */
typedef struct {
  unsigned short digits;
  unsigned long minval;
  unsigned long maxval;
} PPF_varDesc_t;

typedef struct {
  /* similar to original PPF parser's modeDesc_t really,
  plus the command validity bitfields */
  PPF_varDesc_t vars[26];
  unsigned long cmds[26]; /* one of these gets copied into validity field */
} PPF_modeDefs_t;

typedef enum {
  PPF_DEADBEEF=0, /* vague way of checking for uninitialised machine */
  PPF_READER,
  PPF_WRITER
} PPF_IOType_t;

/* The following are needed for use of libPPF, but you don't need to know them.
   They could be put in a separate header, like "ppf_low.h" or something. */

typedef enum {
   PPFPS_NEW,
   PPFPS_COM,
   PPFPS_SPACE,
   PPFPS_SETVAR,
   PPFPS_CLOSEVAL,
   PPFPS_CLOSEPKT,
   PPFPS_FAIL,
   PPFPS_EOF
} PPF_parserState_t;

typedef struct {
   /* ALSO need to add filehandle or similar here!!! */
   FILE *stream; /* howzat? */
   PPF_IOType_t ioType; /* just whether a reader or a writer; this is
                   to generally stop people trying to read and write from
                   the same handle... */
   PPF_parserState_t currentState;
   int checkBounds; /* if nonzero, test range of every variable parsed  */
   unsigned long vars[26]; /* No we can't just use the packet's storage,
                           because that isn't persistent between calls!*/
   unsigned short parseMode; /* ditto, and we don't want to keep
                             setting it each time!*/
   PPF_modeDefs_t *firstDefs; /* pointer to element 0 of array of mode defs
      (allocated by caller) */
   char * errorPtr; /* pointer to any error message; will either be fixed
                       messages, or maybe printf format strings...
                       Alternatively, just make this a big buffer! */
} PPF_IOMachine_t;

/* Functions */
int PPF_fetchCommand(PPF_IOMachine_t *mach, PPF_commandPacket_t *buf);
int PPF_issueCommand(PPF_IOMachine_t *mach, PPF_commandPacket_t *buf);
int PPF_setMode(PPF_IOMachine_t *mach, unsigned short newMode);
void PPF_initMachine(PPF_IOMachine_t *mach,FILE *stream, PPF_IOType_t iotype, PPF_modeDefs_t *defs,int checkBounds);


#ifdef GET_VARB_MACRO
#define PPFVARCONSTa 0
#define PPFVARCONSTb 1
#define PPFVARCONSTc 2
#define PPFVARCONSTd 3
#define PPFVARCONSTe 4
#define PPFVARCONSTf 5
#define PPFVARCONSTg 6
#define PPFVARCONSTh 7
#define PPFVARCONSTi 8
#define PPFVARCONSTj 9
#define PPFVARCONSTk 10
#define PPFVARCONSTl 11
#define PPFVARCONSTm 12
#define PPFVARCONSTn 13
#define PPFVARCONSTo 14
#define PPFVARCONSTp 15
#define PPFVARCONSTq 16
#define PPFVARCONSTr 17
#define PPFVARCONSTs 18
#define PPFVARCONSTt 19
#define PPFVARCONSTu 20
#define PPFVARCONSTv 21
#define PPFVARCONSTw 22
#define PPFVARCONSTx 23
#define PPFVARCONSTy 24
#define PPFVARCONSTz 25
#define VARB(ch) (1<<(PPFVARCONST ## ch))
#endif


/* Internal defs for the parser are now in ppf_internal.h */

/* === end of ppf.h === */
