/* ==== parseppf.c ==== */
/* parser for PPF, done as a finite state machine thingy.
   Each PPF_IOMachine_t structure you give maintains one state machine
   to read* from a single file handle, and keeps its data separate from that
   of other machines. Unlike the version I tried to code in Perl X(
   (*- IOMachines can read and write, but each one may only read *or* write) */

#include <assert.h> /* there's a couple of assertions for sanity */
#include <stdio.h>
/* #define PPF_INTERNAL
-* or just put that stuff into ppf_internal.h :P */
#include "ppf.h"
#include "ppf_internal.h"
#include "ppf_tables.h" /* contains definitions rather than declarations! */

int PPF_fetchCommand(PPF_IOMachine_t *mach, PPF_commandPacket_t *buf){
   PPF_modeDefs_t *currentDefs=(mach->firstDefs)+(mach->parseMode);
   PPF_varDesc_t *varDef=NULL;
   int checkBounds=mach->checkBounds;
   unsigned int cmdIdx;
   unsigned int lhs; /* index of var to set with next val */
   unsigned int digitsLeft; /* when 0, transition SETVAR->CLOSEVAL in DIGIT op*/
   unsigned long valueBuffer,tempvalid;
   int sym,i;
   PPF_parserCmd_t op; /* little operation for each transition */

   if(mach->ioType!=PPF_READER) return -1;
   if(mach->currentState==PPFPS_EOF) return PPFPC_EOF; /* need better approach*/
   while(1) {
      sym=1+getc(mach->stream);
      if(sym<0) sym=0;
      if(sym>127) sym='!'; /* let the state machine trap it */
      op=parseTables[mach->currentState][sym].op;
      /* Yes we want to know op after the switch */
      mach->currentState=parseTables[mach->currentState][sym].next;
      switch(op) {
         case PPFPC_DIGIT0:
         case PPFPC_DIGIT1:
         case PPFPC_DIGIT2:
         case PPFPC_DIGIT3:
         case PPFPC_DIGIT4:
         case PPFPC_DIGIT5:
         case PPFPC_DIGIT6:
         case PPFPC_DIGIT7:
         case PPFPC_DIGIT8:
         case PPFPC_DIGIT9:
         case PPFPC_DIGITA:
         case PPFPC_DIGITB:
         case PPFPC_DIGITC:
         case PPFPC_DIGITD:
         case PPFPC_DIGITE:
         case PPFPC_DIGITF:valueBuffer<<=4;
                           valueBuffer+=op; /* hooray! */
                           digitsLeft--;
                           if(!digitsLeft) mach->currentState=PPFPS_CLOSEVAL;
                           break;

         case PPFPC_NOP:   break; /* heh */

         case PPFPC_PREPVAR: lhs=sym-'b'; /* no, not 'a', because we're offset*/
                           valueBuffer=0;
                           varDef=(currentDefs->vars)+lhs;
                           digitsLeft=varDef->digits;

                           /* Oh hey... */
                           if(!digitsLeft) mach->currentState=PPFPS_CLOSEVAL;
                           /* :P  Yes, we *do* have to check that, as
                           the input file could (invalidly) produce
                           such a situation.
                           OTOH, the mode-setting function elsewhere should
                           check that nothing can take >8 digit values;
                           here, we'll assume the modes are right, and
                           maybe have an assert() at most */
                           assert(digitsLeft<9); /* there ^_^ */
                           break;

         case PPFPC_SETCMD: buf->commandChar=sym-1;
                            cmdIdx=sym-'B';
                            /* could set tempValid here and ditch cmdIdx */
                            break;

         case PPFPC_FAIL_SYM:
         case PPFPC_FAIL_SHORT:
         case PPFPC_FAIL_LONG:
         case PPFPC_EOF: return -1; /*um... right, I haven't worked it out */

         case PPFPC_PUTVAL: /* set in machine, return op sets packet parms */
                         if(checkBounds &&
                           (valueBuffer<(varDef->minval) ||
                            valueBuffer>(varDef->maxval)) ) {
                              return -1; /* FAIL_RANGE */
                         }
                         assert(lhs>=0 && lhs<26);
                         mach->vars[lhs]=valueBuffer;
                         break;

         case PPFPC_RETURN: /* set "valid" bitfield,copy valid vars to packet */
                         buf->parseMode=mach->parseMode;
                         assert(cmdIdx>=0 && cmdIdx<26);
                         /* NB: Validity here != the validity of a variable
                         in general, but whether a variable is relevant to a
                         command. Hence you cannot use the number of digits
                         allowed in the variable as a direct indicator of
                         validity of this sort. */
                         tempvalid=currentDefs->cmds[cmdIdx];
                         buf->validity=tempvalid;

                         /* now copy each var that is valid, ignore others */
                         for(i=0;i<26;i++,tempvalid>>=1) {
                            if(tempvalid&1) {
                                buf->params[i]=mach->vars[i];
                                /* bingus! :) */
                            }
                         }
                         return 0; /* SUCCESS! */

         default: ; /* FOOBAR! */
      }
      /* Loop to get next char ad infinitum */
   }
   /* This point never reached */
}

/* IOMachine init+mode-setting functions are now in ppfmachine.c */

/* === end of parseppf.c === */
