#!/usr/bin/perl -w

open IN_DESC, "<PPF.dfa" or die "Couldn't open description file PPF.dfa!\n$!";

open OUT_TABLES, ">ppf_tables.h" or die "Couldn't open table header file ppf_tables.h for writing!\n$!";

#Characters in character classes; E and . are handled specially by sub
%classDescs=('_'=>" \t",
             '#'=>'\#',
             'n'=>"\n\r\f",
             'l'=>"abcdefghijklmnopqrstuvwxyz",
             'U'=>"ABCDEFGHIJKLMNOPQRSTUVWXYZ",
             'H'=>'0123456789ABCDEF');

@classes=();
@transitions=();
@actions=();
$state="";
%stateDescriptions=();
while(<IN_DESC>) {
   chomp;
   if(/^\s*$/ or /^\#.*$/) {
       #empty/comment
       next;
   }
   if(/^:([a-zA-Z]+)$/) {
       #New state description, whether we've written out the last or not!
       @classes=();
       @transitions=();
       @actions=();
       $state=$1;
       next;
   }
   if(/^ ([_#nlUH\.E]) ->([A-Z]+) ([A-Z_]+)\s*$/) {
       push @classes, $1;
       push @transitions, $2;
       push @actions, $3;
   }
   if(/^%%/) { #don't care if anything follows it
       #End of state description. Now here comes the complicated bit
       #First, go through the description *backwards*.
       @transTable=();
       @opTable=();
       @tableStrings=();
       print "Classes for $state are: @classes\n";
       while(@classes) {
          $class=pop @classes;
          $trans=pop @transitions;
          $op=pop @actions;
          #Now go through the tableArray and in all elements described
          #by $class, enter $trans and $op.
          foreach $i (getClassEntries($class)) {
             #print "Filling element $i\n";
             $transTable[$i]=$trans;
             $opTable[$i]=$op;
          }
       }
       #Now for each element of the array make a string...
       foreach $i (0..127) {
         if(!defined($transTable[$i])) {
            print "Transition $i undefined for state $state\n";
         }
         if(!defined($opTable[$i])) {
            die "Operation $i undefined for state $state\n";
         }
         $tableStrings[$i]='{PPFPS_'.$transTable[$i].', PPFPC_'.$opTable[$i];
         $tableStrings[$i].=($opTable[$i] eq 'DIGIT' ? (chr($i-1).'}'):'}');
       }
       #Now join into one big string that is the table for this state...
       #...and put that string into the hash.
       $stateDescriptions{$state}="{\n/*Table for PPFPS_$state */\n".(join ', ', @tableStrings)."\n}";
   }
}
close IN_DESC;
#Great. Now we have a hash of table strings, dump them in the right order
#with some appropriate headers and other wrapping, into the output file.
#NB: Don't do one for EOF!! Questionable whether to do one for FAIL actually
#but that might make sense if FAIL could be made recoverable.
   print OUT_TABLES <<EOH;
/* ==== ppf_tables.h ==== */
/* THIS FILE IS AUTOGENERATED by mkStateTables.pl, DO NOT edit by hand! */
/* The file 'PPF.dfa' provides the data the script works with. */
static const PPF_parserTransition_t parseTables[7][128]= {
EOH
@tableStrings=();#Yes, we're reusing it for a different purpose. Bite me.
foreach(qw/NEW COM SPACE SETVAR CLOSEVAL CLOSEPKT FAIL/) {
   push @tableStrings,$stateDescriptions{$_};
}
print OUT_TABLES join ',', @tableStrings;
print OUT_TABLES <<EOF;
};
/* End of tables. I'm very glad I didn't write them out by hand. */
/* In fact, that is the end of this header. */
/* Yes I'm bored. Goodbye now. */
/* === end of ppf_tables.h === */
EOF
close OUT_TABLES;
print "DONE\n";
#And that's that.

sub getClassEntries {
   my $class=shift;
   my ($i,$classString,$chr);
   my @elemList;
   #Special cases
   if($class eq 'E') {
      push @elemList,0;
      return @elemList;
   }
   if($class eq '.') {
      return (0..127);#Should I actually say 1..127?
   }
   #The rest
   $classString=$classDescs{$class};
   if (!defined($classString)) {
      print "No string for $class!\n";
   }
   foreach $i(0..( length($classString)-1 ) ) {
      $chr=substr($classString,$i,1);
      push @elemList, (ord($chr)+1);
      #Remember, each element i represents ASCII char i-1...
   }
   return @elemList;
}


#end
