/* ==== instrument.h ==== */
/* structures for instrument descriptions */

typedef enum {
   ENV_NONE,
   ENV_GR_COMPLEX,
   ENV_GR_LONG,
   ENV_ADSR
} envelopeEnum;

typedef struct {
   signed long incrPerTick;
/*   unsigned short duration; -* can be up to a second? */
   unsigned long target;
} complexGraphElement_t;
typedef struct {
   unsigned long duration;
   unsigned short elements;
   unsigned short first; /* height of first element, usually 0 */
   complexGraphElement_t graph[16];
} compEnv_t;

typedef struct {
   signed long incrPerTick;
/*   unsigned long duration; -* can be LONG */
   unsigned long target;
} longGraphElement_t;
typedef struct {
   unsigned long duration;
   unsigned short elements;
   unsigned short first; /* height of first element, usually 0 */
   longGraphElement_t graph[8];
} longEnv_t;

typedef struct {
   unsigned long attackRate; /* increment per tick for attack */
   unsigned long decayRate; /* decrement per tick for decay */
   unsigned long sustainLevel; /* level at which decay stops */
    /* specified as 7 bit number, stored as 32-bit for ease of calculation */
   unsigned long releaseRate; /* decrement per tick for release */
} adsrEnv_t;

/* THE MAIN INSTRUMENT TYPE */

typedef struct {
   /* tone */
   waveformEnum toneShape;
   /* harmonics */
   waveformEnum harmShape;
   unsigned char harmNum; /* frequency multiplier for harmonic; 0=none */
   unsigned char harmVol; /* volume multiplier for harmonic (255==full) */
   /* overtones (fixed frequency harmonics) */
   waveformEnum overtShape;
   unsigned long overtIncr; /* increment for frequency of overtone */
   unsigned char overtVol; /* volume multiplier for overtone (255==full) */

   /*--- Modulation and shaping ---*/

   /* am / vibrato */
   waveformEnum amShape; /* waveform to amplitude modulate by */
   unsigned long amIncr; /* increment for frequency of vibrato */
   waveRangeEnum amRange; /* range of values for vibrato wave */
   /* don't bother with am depth, I figure that range covers that ok */

   /* envelope data */
   envelopeEnum envType;
   union {
       compEnv_t complexGraph;
       longEnv_t longGraph;
       adsrEnv_t adsr;
   } envData; /* this way, can store relatively long envelopes in
         an array, and don't waste space for instruments that don't
         have envelopes (or have ADSR envelopes, which use much
         less storage); furthermore, it avoids having the list of
         instrument data excessively spread out, which would be
         bad for cache coverage? Hmm, not quite, because the
         envelope data would be separated from the instrument data
         that it would work with, which makes "spatial locality"
         worse, but still, I think cutting down on wasted space is
         a good thing.
         Actually, as the table of envelope data would only be
         required every few samples, we could (along with various
         other parts of the instrument data) copy the currently
         required entry of an envelope being used into the data
         structure for the channel playing it; now *that's* good
         for locality :) */

   /* fm / tremelo */
   waveformEnum fmShape; /* waveform to frequency modulate by */
   unsigned long fmIncr; /* increment for frequency of tremelo wave */
   waveRangeEnum fmRange; /* range of values for fm waveform */
   signed char fmReset; /* 0-3: reset tremelo wave to given quadrant
                               each time note is started; -1: no reset */
   unsigned short fmDepth; /* depth of tremelo effect (assuming wave
                               can go to maximum amplitude) in 256ths
                               of an octave */

   /* Is that all components of our instruments? */

} instrument_t;

extern instrument_t *instrumentData;
/* This should be an *array* of entries, dynamically allocated based on
   the initial declaration of the number of instruments */


/* === end of instrument.h === */
