/* ==== instrument.c ==== */
/* mostly for setting up instrument data on startup */

#include <stdio.h> /* temporary till 2nd error reporting thing done */
#include "blooper.h"
#include "waveforms.h"
#include "instrument.h"
#include "note.h"
#include "parser.h"

unsigned char maxInstrument;
instrument_t *instrumentData;

/* instrumentData should be allocated at very start, before parsing
   instrument list */

/* see typedefs in parser.h for info */
modeDesc_t confmode={{
   {0,0,0}, {0,0,0}, {1,4,8}, {0,0,0}, {0,0,0}, /* a-e; c=channels */
   {0,0,0}, {0,0,0}, {0,0,0}, {2,0,255}, {0,0,0}, /* f-j; i=maxInstrument */
   {0,0,0}, {0,0,0}, {0,0,0}, /* k,l,m */
   {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, /* n-r */
   {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, /* s-w */
   {0,0,0}, {0,0,0}, {0,0,0} /*x,y,z */
}};
modeDesc_t instrmode={{
   {4,1,16384}, {0,0,0}, {0,0,0}, {4,1,16384}, {1,ENV_GR_COMPLEX,ENV_GR_LONG},
        /* a-e; a=Attack, d=decay, e=graphical envelope type */
   {3,1,0xFFF}, {0,0,0}, {0,0,0}, {0xdead,0xdead,0xdead}, {0,0,0}, /* f-j */
        /* f=frequency, had been 3,1,0xFFF */
   {0,0,0}, {0,0,0}, {3,1,1024},  /* k,l,m m=fm mod depth (max 4 octaves?) */

   {2,1,128}, {0,0,0}, {1,0,SIGRNG_TOPHALF}, {1,0,4}, {4,1,16384},
        /* n-r: n=harmNum, p=position(range), q=quadrant (to reset to) */
   {2,0,127}, {0xdead,0xdead,0xdead}, {0,0,0}, {2,0,255}, {1,0,(WVFM_TOT-1)},
         /* s-w; s=sustain, t=env target, v=volume, w=waveform */
   {0,0,0}, {0,0,0}, {0,0,0}  /* x,y,z */
}};

void getConfig() {
   int done=0;
   commandPacket_t commandPacket= {
      'a',0,
     {0,0,0,0, 0,0,0,0, 0,0,0,0,0,
      0,0,0,0, 0,0,0,0, 0,0,0,0,0}
   };
   while(!done) {
       if(-1==getCmd(&confmode, &commandPacket)) {
          /* ERROR in parsing, might get details in packet eventually? */
          fprintf(stderr,"ERROR in parsing setup: %d\n",commandPacket.type);
          exit(1); /* Umm.... */
       }
       if(commandPacket.type==1) {
         if(commandPacket.cmd=='I') {
            maxInstrument=getVar('i');
            instrumentData=
              (instrument_t *)malloc((1+maxInstrument)*sizeof(instrument_t));
            channelsUsed=getVar('c');
            /* is it ok to have different number to 4 or 8, if <8? */
            /* samplerate, stereo-vs-mono, sample size, should be
               independent of song */
            done=1;
         } else {
            fprintf(stderr,"Unknown command found in parsing setup\n");
            exit(1); /*Hmm */
         }
       }
       /* command processed... */
   }
}

void setupInstruments() {
   int i,doneThis,elemno;
   instrument_t *thisInstrument;
   unsigned long sustainLevel;
   commandPacket_t commandPacket= {
      'a',0,
    {0,0,0,0, 0,0,0,0, 0,0,0,0,0,
     0,0,0,0, 0,0,0,0, 0,0,0,0,0}
   };
#define instrVar(elem) (thisInstrument->elem)
/* actually also used in process.c, but what the hey */
#define envData(elem) instrVar(envData.elem)

   thisInstrument=instrumentData;
   for(i=0;i<=maxInstrument;i++) {
      doneThis=0;
      /* set defaults that turn various effects off,
         for if parts not used by an instrument */
      instrVar(harmNum)=0; instrVar(overtIncr)=0;
      instrVar(amIncr)=0; instrVar(fmIncr)=0;
      instrVar(envType)=ENV_NONE;
      /* process instrument until done */
      while(!doneThis) {
         if(-1==getCmd(&instrmode,&commandPacket)) {
            /* ERROR in instrument list */
            fprintf(stderr,"ERROR in parsing instrument: %d\n",commandPacket.type);
            exit(1);
         }
         if(commandPacket.type==1) {
           switch(commandPacket.cmd) {
              case 'E': /* set ADSR envelope data */
                 /* t, e: type? */
                 /* a,d,s,r: adsr elements? */
                 if(instrVar(envType)!=ENV_NONE) {
                   exit(1);
                   /* can't go changing envelope type from one to another */
                 }
                 instrVar(envType)=ENV_ADSR;
                 envData(adsr.attackRate)=(0x7F000000)
                     / ((getVar('a')*rate)/1024);
                 sustainLevel=(0x01000000*getVar('s'));
                 envData(adsr.sustainLevel)=sustainLevel;
                 envData(adsr.decayRate)=(0x7F000000-sustainLevel)
                     / ((getVar('d')*rate)/1024);
                 envData(adsr.releaseRate)=sustainLevel
                     / ((getVar('r')*rate)/1024);
                 break;
              case 'G': /* start/append to GRAPHICAL envelope data */
                 /* -- GRAPHICAL ENVELOPES NOT YET USED -- */
                 /* e: subtype */
                 if(instrVar(envType)!=getVar('e') &&
                    instrVar(envType)!=ENV_NONE) {
                    /* can't go changing envelope type */
                    exit(1);
                 }
                 if(instrVar(envType)==ENV_NONE) {
                    switch(getVar('e')) {
                       case ENV_GR_LONG:
                          envData(longGraph.elements)=0;
                          envData(longGraph.first)=getVar('o');
                          break;
                       case ENV_GR_COMPLEX:
                          envData(complexGraph.elements)=0;
                          envData(complexGraph.first)=getVar('o');
                          break;
                       default:
                          madeBlooper(BLOOP_BADENVTYPE);
                    }
                 }
                 instrVar(envType)=getVar('e');
                 /* Have counter in graphdata to store number of entries? */
                 elemno=envData(longGraph.elements);
                 if(elemno ==
                    ( (getVar('e') ==ENV_GR_LONG)?8:16) ) {
                    /* Overflow! */
                    exit(1);
                 }
                 envData(longGraph.graph[elemno].incrPerTick)=getVar('i');
                 envData(longGraph.graph[elemno].target)=getVar('t');
                 envData(longGraph.elements)++;
                 break;
              case 'H': /* harmonic */
                 instrVar(harmShape)=getVar('w');
                 instrVar(harmNum)=getVar('n');
                 instrVar(harmVol)=getVar('v');
                 break;
              case 'O': /* overtone */
                 instrVar(overtShape)=getVar('w');
                 instrVar(overtIncr)=getVar('f');
                 instrVar(overtVol)=getVar('v');
                 break;
              case 'A': /* AM */
                 instrVar(amShape)=getVar('w');
                 instrVar(amRange)=getVar('p');
                 instrVar(amIncr)=getVar('f');
                 break;
              case 'F': /* FM */
                 printf("Setting up FM variables...\n");
                 instrVar(fmShape)=getVar('w');
                 instrVar(fmRange)=getVar('p');
                 instrVar(fmIncr)=((double)getVar('f')*(double)WLEN)/rate;
                 printf("fmIncr is %ld\n",instrVar(fmIncr));
                 instrVar(fmReset)=getVar('q');
                 instrVar(fmDepth)=getVar('m');
                 printf("fmDepth is %ld\n",instrVar(fmDepth));
                 break;
              case 'D': /* done this instrument */
                 instrVar(toneShape)=getVar('w');
                 doneThis=1;
                 break;
              default:
                 fprintf(stderr,"ERROR in parsing instrument: Unknown command\n");
                 exit(1);
           }
         }
         /* a command processed... */
      }
      /* instrument done */
      thisInstrument++;
   }
   /* ALL instruments done */
}

/* === end of instrument.c === */
