/* ==== blooper.c ==== */
/* Chiptune synths don't have internal errors, they have *bloopers*.
   No, this file doesn't have anything to do with making noise; it's one
   of the only parts that doesn't, in fact. */

#include <stdio.h>
#include "blooper.h"

void errify(char *desc) {
   fprintf(stderr,"BLOOP! %s",desc);
}

void madeBlooper(screwup_t bloop) {
   /* This routine is only for recognising *internal* errors, not bad
   arguments or faulty file formats or anything else. */
   switch(bloop) {
      case BLOOP_BADENVTYPE:
         errify("Patel found an instrument with a bad envelope type. Quitting.");
         break;
      default:
         errify("Patel had some internal error...\n...and the error didn't even have a valid error type!");
   }
   exit(1);
}

/* === end of blope*CRASH* === */
