#!/usr/bin/perl -w
# this process spiders the different directories named in
# dirs.ctrl, and for each of them, creates a file dir.targets,
# which will get (directly or indirectly) included by the
# Makefile.
#
# Actually, the "dirs.ctrl" file doesn't list directories, but
#  the path to the section.nav file for each one, from which
#  the directory can be extrapolated.
#
# Contents of these files:
#  -for each foo.layout, a line foo.html: (`echo foo.*.input`)
#  -full directory paths given for each of those files
#  -the rule (dirname)_dir_targets: crd=(path_to_root) cdir=(dirname)
#  -the rule (dirname)_dir_targets: (dirname)/*.html (dirname)/(section).nav
#
# Finally, for each of these files (dirname)/dir.targets, echo
#  include((dirname)/dir.targets)
#  rest_targets: (dirname)_dir_targets
# into the file rest.targets in the root directory.
#
#
# Not sure if we should consider the root directory separately,
# I think maybe we should? Hmm, why?
# Possibly because the root directory isn't really a section, and
# will probably have no section.nav file. OTOH it might have sepearate
# pages for older news in future?
# Ah. But then, the news would probably be filled in by separate
# input sections for *each day*, and these would get filled into
# separate pages by a clever algorithm to ensure that the "archive"
# (oldest) page had maybe 1/2 or 2/3 of the total news content (either
# by file size or by entries), with all the different pages having
# less or equal amounts than the one page older than them. EG: Page
# 2 has 2 items, page 3 has 3 items, page 4 has 4 items, archive
# page has from maybe 10 to 22 items.
# Preferably, there would be more than 6 pages in total once the
# number of news items was large enough. Of course, in this scheme,
# the page layout and navigation boxes for the root section would have
# to be automatically generated by that same script..
#
# So, to summarise, NO, this program shouldn't deal with the root
# directory, only the sections in subdirectories.
#


open CTRLFILE, "<dirs.ctrl" or die "cannot open control file dirs.ctrl: $!";
open RESTFILE, ">rest.targets";

while(<CTRLFILE>) {
   chomp;
   # $_ now contains a line (dirname)/(section).nav
   if (/(.*)\/([\.\w]+)$/){;
     print("dirname: $1  sectionfile: $2\n");
     $dirname=$1;$sectionfile=$2;
     open DIRTARGETS, ">$dirname/dir.targets";
     print(DIRTARGETS "# autogenerated by target_spider.pl\n");
     print(DIRTARGETS "# -do not edit!\n\n");
     print(RESTFILE "include $dirname/dir.targets\n");
     print(RESTFILE "rest_targets: ".$dirname."_dir_targets\n");
      # note, I had to put the template.m4 and site.nav prerequisites
      # here too as the ones for the *.html target didn't match the
      # targets in subdirectories!!
     print(DIRTARGETS "$dirname/*.html: $dirname/$sectionfile template.m4 site.nav site.cfg\n");
         # ---FIXME!---
         # the following is a kludge because I can't be arsed to
         # do it right (search for number of /'s in the string).
         # It'll work as long as subdirectories are all the same
         # depth (probably true) and we don't crawl the root directory
         # with this program.
     print(DIRTARGETS $dirname."_dir_targets: crd = ..\n"); # the kludge
     print(DIRTARGETS $dirname."_dir_targets: cdir = $dirname\n");
     #now find all occurrences of *.layout in ($dirname)
     foreach(glob "$dirname/*.layout") {
        #print "$_\n";
        /(.*).layout$/;
        $stem=$1;
        print (DIRTARGETS "$stem.html: ");
        print ( DIRTARGETS join(" ",glob "$stem.*.input"));
        print (DIRTARGETS "\n");
        print (DIRTARGETS $dirname."_dir_targets: $stem.html\n");
     }
     print(DIRTARGETS "\n#\n# end of $dirname/dir.targets\n\n");
     close DIRTARGETS;
   } else {
     warn("$_ line couldn't be interpreted! Ignoring.\n");
   }
}
# done? 
print "\n";
close RESTFILE;
close CTRLFILE;
# done.
