/* ==== lstring_defs.c ==== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "lstring_defs.h"

stringblock_t *outstring; /* start of string */
stringblock_t *stringblock; /* current block */

void initString() {
	outstring=nextBlock();
	/* outstring->Next=NULL; done */
	stringblock=outstring;
}

stringblock_t *nextBlock() {
	stringblock_t *this=(stringblock_t *)malloc(sizeof(stringblock_t));
	this->Block[0]='\0';
	this->Next=NULL;
	return (this);
}

void appendString(char *string){
	int remain;
	remain=23-strlen(stringblock->Block);
	if(remain/*==0*/<strlen(string)) {
		stringblock->Next=nextBlock();
		stringblock=stringblock->Next;
		remain=23;
	}
	/* SHOULD check string is small enough to fit in one block?
	  Split string up? Allocate several blocks in sequence? */
	strncat(stringblock->Block,string,remain);
}

void appendChar(char ch){
	int pos,remain;
	pos=strlen(stringblock->Block);
	remain=23-pos;
	if(remain==0) {
		stringblock->Next=nextBlock();
		stringblock=stringblock->Next;
		remain=23; pos=0;
	}
	sprintf((stringblock->Block)+pos,"%c",ch); /* does this add a /0? */
}

void appendEmptyRecord(int arity){
	/* ^{ (^,){arity-1}  ^} */
	int i=1;
	appendChar('^');appendChar('{');
	for(;i<arity;i++) appendChar('^'),appendChar(',');
	appendChar('^');appendChar('}');
}

void escPrint(char *string) {
	char *ptr=string;
	for(;;ptr++) {
		if (*ptr=='\0') break;
		switch (*ptr) {
			case '^':appendString("^^");break;
			case '\n':appendString("^n");break;
			default:appendChar(*ptr);
		}
	}
}

void finish() {
	stringblock=outstring;
	/* check for errors first?? */
	do {
		printf("%s",stringblock->Block);
		stringblock=stringblock->Next;
	} while(stringblock!=NULL);
	exit(0);
}

void error(char *string) {
	fprintf(stderr,"%s\n",string);
	printf("^{-1^}^{this is an error string^}");
	exit(1);
}

void usage(){
	fprintf(stderr, "%s: usage- %s [optype]...\n"
			"   %s [rR] recordnum fieldnum -output field\n"
			"   %s [wW] recordnum fieldnum newvalue -sets field\n"
			"   %s [iI] recordnum -inserts empty record\n"
			"   %s [aA] -appends empty record at end\n"
			"   %s [dD] recordnum -deletes record\n"
			"   %s [lL] -display number of records\n"
			" record and field numbers are numbered from 0.\n\n",
			prog,prog,  prog,prog,prog,prog,prog,prog);
	exit(1);
}

int yywrap() {
	return(1);
}
