%{
#include "lstring_defs.h"
%}
LDELIM \^\{
RDELIM \^\}
SEPAR \^,
CARET \^\^
ESCNL \^n
NUM 0|\-?[1-9][0-9]{0,3}
%s OUTER ARITY ENDARITY RECORD
%%
<INITIAL>{LDELIM}		{
					if(!wp_none)
						appendString("^{");
					BEGIN ARITY;
				}
<OUTER>{LDELIM}			{
					cfield=0;
					ontarget=(crecord==trecord &&
						(!p_fields||cfield==tfield));
					/* process according to other stuff*/

					if (opmode=='i'&& ontarget)
						appendEmptyRecord(arity);
					/* do we do this for 'd'? *-
					if(opmode=='d'&& ontarget)
						deletethis=1; */
					/* --
					if (opmode!='r'&& deletethis==0)
					-- */
					/* --???? -- */
					if (wp_all||(wp_gen&&(!ontarget)))
						appendString("^{");
					BEGIN RECORD;
					/*
					cfield=0; -* record++ at end *-
					if(opmode=='r' && crecord==trecord
						&& cfield==tfield) {
						ontarget=1;
						readthis=1;
					} */
					if(opmode=='w' && ontarget)
						escPrint(tstring);
					/*
					if(opmode=='w' && crecord==trecord
						&& cfield==tfield) {
						escPrint(tstring);
						ontarget=1;
					} */
				}
<ARITY>{LDELIM}			{
					error("Left delimiter found in place of header data");
				}
<RECORD>{LDELIM}		{
					error("Left delimiter found in place of record data");
				}

<ARITY>{NUM}			{
					if (!w_spec)
						appendString(yytext);
					arity=atoi(yytext);
					if(arity<1) error("Bad arity given in header");
					BEGIN ENDARITY;
				}
<ARITY>{RDELIM}			error("Empty header given");
<ENDARITY>{RDELIM}		{
					if (!wp_none)
						appendString("^}");
					BEGIN OUTER;
				}
<INITIAL,OUTER>{RDELIM}		error("Right delimiter found outside of header or record");

<RECORD>{CARET}			{
					/* --
					if(readthis==1)
						appendChar('^');
					else if (opmode!='r'&& !deletethis)
						appendString("^^");
					-- */
					if(w_all || (w_gen&&(!ontarget))
						|| (w_spec &&ontarget)) {
						opmode=='r'?appendChar('^')
							:appendString("^^");
					}
				}
<RECORD>{ESCNL}			{
					/* --
					if(readthis==1)
						appendChar('\n');
					else if (opmode!='r'&& !deletethis)
						appendString("^n");
					-- */
					if(w_all || (w_gen&&(!ontarget))
						|| (w_spec &&ontarget)) {
						opmode=='r'?appendChar('\n')
							:appendString("^n");
					}
				}
<RECORD>[^\^\n]			{
					/* --
					if(readthis==1||(opmode!='r'&& !deletethis))
						appendChar(yytext[0]);
					-- */
					if(w_all || (w_gen&&(!ontarget))
						|| (w_spec &&ontarget)) {
						appendChar(yytext[0]);
					}
				}
<RECORD>{SEPAR}			{
					/* --
					if(opmode!='r' && !deletethis)
						appendString("^,");
					-- */
					if (wp_all||(wp_gen&&(!ontarget)))
						appendString("^,");
					cfield++;
					if(cfield==arity) error("Too many fields found in record");
					if(p_fields) ontarget=(crecord==trecord
						&&cfield==tfield);
					/* --
					if(opmode=='r'&&crecord==trecord)
						readthis=(cfield==tfield);
					if(opmode=='w'&&crecord==trecord
						&&cfield==tfield) {
						escPrint(tstring);
						-* ignorerestoffield *-
					} -- */
					if(opmode=='w' && ontarget)
						escPrint(tstring);
				}
<RECORD>{RDELIM}		{
					/* --
					if(opmode!='r'&& !deletethis)
						appendString("^}");
					-- */
					if (wp_all||(wp_gen&&(!ontarget)))
						appendString("^}");
					if(cfield+1!=arity) error("Not enough fields found in record");
					crecord++;/*deletethis=0;readthis=0; */
					ontarget=0;
					BEGIN OUTER;
				}
<RECORD>\^.			{
					/* unknown escape */
					/* --
					if((opmode!='r'&& !deletethis)||readthis)
					-- */
					if(w_all || (w_gen&&(!ontarget))
						|| (w_spec&&ontarget))
						appendChar('?');
				}

<OUTER>\n			; /* do the end work when we return */

<OUTER>.			error("Unexpected character found looking for left delimiter or end of string");
<ARITY>.			error("Unexpected character found in place of header data");
<ENDARITY>.			error("Unexpected character found looking for close of header");

%%

/* C code goes here */
/* modes */
/* R-Read: Nop till find field, output field, Nop */
/* D-Delete record: output till find record, output after record */
/* I-Insert record: output till about to start record to insert at; output
   the new (empty) record; output rest */
/* A-Append record: output all,output new (empty) record) */
/* W-Write field: output till find field, output new field instead, output
   the rest*/
int crecord=0;
int cfield=0;

int deletethis=0,readthis=0; /*old form, replaced by: */

int ontarget=0; /* field or record to either include or exclude;
  ontarget=( crecord==trecord &&(!pfields||(cfield==tfield)) ) */
int trecord,tfield,arity;
char *tstring;
char opmode;
char *recstring;
char *fieldstring;
char *prog; /* name of this executable */

enum {ALL,GENERAL,SPECIFIC} writemode;
int w_all,w_gen,w_spec; /* flags set from writemode */
int wp_all,wp_gen,wp_none; /* write punctuation generally? */
int p_fields=0; /* process fields? */

int main (int argc, char *argv[]) {
	int args;
	prog=argv[0];
	/* Following args: [record no-R,D,I,W][field no-R,W][new field-W only]*/
	if (argc<2 || strlen(argv[1])>1) usage();
	opmode=argv[1][0];
	switch(opmode) {
		case 'r':
		case 'R': args=2; writemode=SPECIFIC; p_fields=1; break;
		case 'd':
		case 'D': args=1; writemode=GENERAL; break;
		case 'i':
		case 'I': args=1; writemode=ALL; break;
		case 'w':
		case 'W': args=3; writemode=GENERAL; p_fields=1; break;
		case 'a':
		case 'A': args=0; writemode=ALL; break;
		case 'l': /* LATE ADDITION: copies nothing, outputs num lines */
		case 'L': args=0;writemode=SPECIFIC;trecord=-1;break;/*actually wr=NONE*/
		default: usage();
	}
	w_all=(writemode==ALL);
	w_gen=(writemode==GENERAL);
	w_spec=(writemode==SPECIFIC);
	wp_all=(w_all||(w_gen&&p_fields));
	wp_gen=(w_gen&&(!p_fields));
	wp_none=(w_spec&&p_fields);
	/* -- still need this for *some* bits :P -- */
	opmode=opmode |32; /* lcase for ascii */
	if(args+2!=argc) usage();
	switch(args) {
		case 3: tstring=argv[4];
			/* fprintf(stderr,"Writing string %s\n",tstring); */
		case 2: fieldstring=argv[3];
			tfield=atoi(fieldstring);
			/* fprintf(stderr,"Field %d\n",tfield); */
		case 1: recstring=argv[2];
			trecord=atoi(recstring);
			/* fprintf(stderr,"Record %d\n",trecord); */
		case 0: break;
		default: fprintf(stderr,"lstring: STRANGE number of arguments...\n");
		exit(1);

	}
	/* check arg types, copy recstring->trecord, fieldstring->tfield */
	initString();

	yylex();
	/* found end of string */
	if(opmode=='a') appendEmptyRecord(arity);
	if(opmode=='l') {
		printf("%d",crecord); /* number of records parsed */
		exit(0);
	}
	finish();
	exit(0); /* doesn't finish() do this?  But this shuts up gcc. */
}
