#!/bin/bash
#
# store filename
if test 1 != $#;
   then
     echo $# arguments given to $0.
     echo
     echo usage: $0 CONFIGFILE
     echo opens CONFIGFILE for editing.
     echo 
     exit 1;
fi;
if test -e $1 ;
   then
      CONFIGFILE=$1;
   else
      echo Couldn\'t open config file $1;
      echo giving up.
      exit 1;
fi
# print a menu of keys in the file based on clipcode -l

#START OF LOOP
while 
   ALLKEYS=`clipcode -l $CONFIGFILE`
   DUPKEYS=`
   for KEY in $ALLKEYS ;
       do echo $KEY edit_key;
   done; echo "#ADD new_key"`
   TEMPFILE=`tempfile` # not strictly secure, but don't blame me!
   dialog --title "Keys in $CONFIGFILE" --menu "Pick a key to view/edit, or add a new key." 18 80 8 $DUPKEYS 2>$TEMPFILE;
do
   CHOSENKEY=`cat $TEMPFILE`
   rm $TEMPFILE;
   # now process choice:
   if test $CHOSENKEY = "#ADD";
   then
         TEMPFILE=`tempfile`
         if 
           dialog --title "Add a NEW key" --inputbox "Enter name for new key." 10 70 2>$TEMPFILE;
         then
           CHOSENKEY=`cat $TEMPFILE`
           clipcode -a $CONFIGFILE $CHOSENKEY;
         fi;
         rm $TEMPFILE;
   else
         KEYVALUE=`clipcode -r $CONFIGFILE $CHOSENKEY`
         # should trap errors here..
         # DAMMIT, it doesn't REALLY take \n, so I have to do ^V^J...
         if dialog --title "Value of $CHOSENKEY" --yesno "Key name: $CHOSENKEY
Key value: $KEYVALUE
Edit Key?" 10 60;
         then
            TEMPFILE=`tempfile`
            if dialog --title "Choose Operation" --menu "Edit value, delete key, or cancel." 12 70 2 edit key delete key 2>$TEMPFILE;
            then #we do something...
              OPERATION=`cat $TEMPFILE`
              rm $TEMPFILE;
              if test $OPERATION = "edit"
              then #edit
                 TEMPFILE=`tempfile`;
                 if dialog --title Edit\ Value --inputbox "Edit value for Key" 10 70 "$KEYVALUE" 2>$TEMPFILE;
                 then
                   KEYVALUE=`cat $TEMPFILE`
                   rm $TEMPFILE;
                   if clipcode -w $CONFIGFILE $CHOSENKEY "$KEYVALUE";
                   then :;
                   else 
                      dialog --title Key\ Modification --msgbox Operation\ Failed 8 50;
                   fi;
                   sleep 1;
                 else
                   rm $TEMPFILE;
                 fi;
              else #assume delete...
                 if clipcode -d $CONFIGFILE $CHOSENKEY
                 then
                   dialog --title Key\ Deleted --msgbox Operation\ Successful 8 50;
                 else
                   dialog --title Key\ Deletion --msgbox Operation\ Failed 8 50
                 fi
              fi;
            else
              rm $TEMPFILE; #cancelled
            fi;
         fi;
   # NOTE end of ^V^J stuff..
   fi;
done
#END OF LOOP
rm $TEMPFILE   #would be left over from where we exited.

#END OF PROGRAM.
