/* ==== clipcode_a2.c ==== */
/*   top-level functions of arity 2
   Tom Barnes-Lawrence  tomble@usermail.com
   http://www.angelfire.com/super2/duologue/
   */

#include <string.h>
#include <pcre.h>
#include "clipcode_defs.h"
#include "clipcode_protos.h"
#include "clipcode_globals.h"

void clipcode_read(const char *fname, const char *key) {
   /* int dfile_done=0; oh. */
   int length,scan_result;
   char *eptr;
   clipcode_open(fname);
   clipcode_checkkey(key);
   sprintf(search_string,"^%s:(.*)$",key);
   search_regexp= pcre_compile(search_string,0,&cc_errptr,&cc_eoffset,NULL);
   while(NULL!=fgets(cc_stringbuffer,CC_BUFSIZE,dfile)) {
      /* dfile_done=(NULL==fgets(cc_stringbuffer,CC_BUFSIZE,dfile)); */
      eptr = strchr(cc_stringbuffer,'\n');
      if(NULL==eptr && !feof(dfile))
        /* not at EOF so missing newline must mean ultra-long line! */
          clipcode_linetoolong();
      if(feof(dfile)) length=strlen(cc_stringbuffer);
      else length = eptr - cc_stringbuffer;
      scan_result=pcre_exec(search_regexp,NULL,cc_stringbuffer,length,0,0,cc_ovector,12);
      if(scan_result>0) {
           pcre_copy_substring(cc_stringbuffer, cc_ovector, scan_result, 1,cc_valuebuffer,CC_VALBUFSIZE);
           printf("%s",cc_valuebuffer); /* do we want that \n there?...no. */
           exit(EXIT_SUCCESS);
      }
   }
   exit(EXIT_FAILURE);
}

void clipcode_add(const char *fname, const char *key) {
   /* search for the string. If we find it, exit(0).
   if we DONT, reopen to append, and write the key (empty) at the end */
   int length,scan_result;
   char *eptr;
   clipcode_open(fname);
   clipcode_checkkey(key);
   sprintf(search_string,"^%s:(.*)$",key);
   search_regexp= pcre_compile(search_string,0,&cc_errptr,&cc_eoffset,NULL);
   while(NULL!=fgets(cc_stringbuffer,CC_BUFSIZE,dfile)) {
      eptr = strchr(cc_stringbuffer,'\n');
      if(NULL==eptr && !feof(dfile)) clipcode_linetoolong();
      if(feof(dfile)) length=strlen(cc_stringbuffer);
      else length = eptr - cc_stringbuffer;
      scan_result=pcre_exec(search_regexp,NULL,cc_stringbuffer,length,0,0,cc_ovector,12);
      if(scan_result>0) {
          exit(EXIT_SUCCESS); /* THAT simple!! */
      }
   }
   dfile=fopen(fname,"ab"); /* open to append */
   if(dfile==NULL) { /* only other way ADD can fail?? */
       perror("clipcode: can't add key to config file");
       exit(EXIT_FAILURE);
   }
   /* now append empty key */
   fprintf(dfile,"%s:\n",key);
   fclose(dfile); /* actually, check for errors here! */
   exit(EXIT_SUCCESS);
}

void clipcode_delete(const char *fname, const char *key) {
   /* much like clipcode_write(), but NOPs at the given line */
   FILE *tfile;
   int success=0;
   int length, scan_result;
   char *eptr;
   clipcode_open(fname);
   clipcode_checkkey(key);
   tfile=tmpfile();
   if(tfile==NULL) {
      perror("clipcode: couldn't open temporary file");
      exit(1);
   }
   sprintf(search_string,"^%s:(.*)$",key);
   search_regexp= pcre_compile(search_string,0,&cc_errptr,&cc_eoffset,NULL);
   while(NULL!=fgets(cc_stringbuffer,CC_BUFSIZE,dfile)) {
      eptr = strchr(cc_stringbuffer,'\n');
      if(NULL==eptr && !feof(dfile))
       clipcode_linetoolong();
      if(feof(dfile)) length=strlen(cc_stringbuffer);
      else length = eptr - cc_stringbuffer;
      scan_result=pcre_exec(search_regexp,NULL,cc_stringbuffer,length,0,0,cc_ovector,12);
      if(scan_result>0) {
         /* found the key! now, we don't want the value any more, do we? */
         /* nothing to see here, move along...*/
         success=1;
         break;
      } else  fputs(cc_stringbuffer,tfile);
   }
   if(!success) {
       fprintf(stderr,"%s: couldn't find key \"%s\" to delete\n",cmdname,key);
       exit(1);
   }
   while(NULL!=fgets(cc_stringbuffer,CC_BUFSIZE,dfile)) {
      eptr = strchr(cc_stringbuffer,'\n');
      if(NULL==eptr && !feof(dfile))
       clipcode_linetoolong();
      fputs(cc_stringbuffer,tfile); /* just copy it */
   }
   /* now rewind tfile, reopen (fname) to write, and copy tfile into it*/
   fclose(dfile); /* must check */
   dfile=fopen(fname,"wb"); /*rewrite*/
   if (dfile==NULL) {
       sprintf(cc_stringbuffer,"%s: couldn't modify file %s\n",cmdname,fname);
       perror(cc_stringbuffer);
       exit(1);
   }
   rewind(tfile);
   while(NULL!=fgets(cc_stringbuffer,CC_BUFSIZE,tfile)) {
      eptr = strchr(cc_stringbuffer,'\n');
      if(NULL==eptr && !feof(tfile)) clipcode_linetoolong();
      fputs(cc_stringbuffer,dfile);
   }
   fclose(dfile); /* must check this */
   /* succeeded? */
   exit(0);
}

/* ==== end of clipcode_a2.c ==== */
