#!/bin/bash
#
# takes a pair of keynames, renames first to second.
# if second name already existed, it is lost in the process.
if test 3 != $# ;
then
    echo $# arguments given to $0.
    echo
    echo usage: $0 CONFIGFILE SOURCEKEY TARGETKEY
    echo renames SOURCEKEY to TARGETKEY.
    echo \(TARGETKEY ends up with SOURCEKEY\'s value,
    echo  SOURCEKEY ends up deleted.\)
    echo
    exit 1;
fi
if test -e $1 ;
then
    CONFIGFILE=$1;
else
    echo Couldn\'t open config file $1;
    echo giving up.
    exit 1;
fi
SOURCEKEY=$2;TARGETKEY=$3;

if clipcode -r $CONFIGFILE $SOURCEKEY>/dev/null;
then
  clipcode -a $CONFIGFILE $TARGETKEY
  clipcode -w $CONFIGFILE $TARGETKEY `clipcode -r $CONFIGFILE $SOURCEKEY`
  clipcode -d $CONFIGFILE $SOURCEKEY
else
  echo $SOURCEKEY not found in $CONFIGFILE.
  echo Doing nothing.
  exit 1;
fi;
