#!/bin/bash
#
# takes a list prefix, and an element number to chop out of it.
# any following elements get moved to replace it.
if test 3 != $# ;
then
    echo $# arguments given to $0.
    echo
    echo usage: $0 CONFIGFILE LISTprefix TARGETKEY
    echo chops TARGETKEY out of LIST.
    echo \(other elements shift along\).
    echo
    exit 1;
fi
if test -e $1 ;
then
    CONFIGFILE=$1;
else
    echo Couldn\'t open config file $1;
    echo giving up.
    exit 1;
fi
LISTPFX=$2;TARGETKEY=$3;

function confirm {
   return clipcode -r $CONFIGFILE $1 >/dev/null;
}
function denylist {
   echo $LISTPFX doesn\'t seem to be a valid list.
   exit 1;
}

function checkelem {
   for FIELD in $FIELDS; do confirm "$(LISTPFX)$(FIELD)"; done;
}

if confirm "$(LISTPFX)IsAHLList";
then :; else denylist;
fi;
if confirm "$(LISTPFX)arity";
then :; else denylist;
fi;
if confirm "$(LISTPFX)length";
then :; else denylist;
fi;
if confirm "$(LISTPFX)fields";
then :; else denylist;
fi;
# now, get actual values for arity , length, and fields...
for ELEM in seq $LENGTH; do checkelem $ELEM; done;

# are we still here? must be a valid list then.


#
#
#NB- this is all old stuff:
if clipcode -r $CONFIGFILE $SOURCEKEY>/dev/null;
then
  clipcode -a $CONFIGFILE $TARGETKEY
  clipcode -w $CONFIGFILE $TARGETKEY `clipcode -r $CONFIGFILE $SOURCEKEY`
  clipcode -d $CONFIGFILE $SOURCEKEY
else
  echo $SOURCEKEY not found in $CONFIGFILE.
  echo Doing nothing.
  exit 1;
fi;
