/* ==== clipcode_protos.h ==== */

void clipcode_version(); /* prints version info */
void usage(); /* prints usage info */

void clipcode_open(const char *fname); /* opens global file pointer dfile, or
  says "file not found" and exits with (1) otherwise */

void clipcode_linetoolong();

void clipcode_checkkey(const char *key);
/* checks validity of key given as argument; exit(failure) if bad. */

void clipcode_read(const char *fname, const char *key);
/* looks for key in file fname. If file or key don't exist,
gives bad exit status. Prints value of key if found. */

void clipcode_add(const char *fname, const char *key);
/* tries to add key to file. If created, will be empty. If
already present, does nothing. */

void clipcode_delete(const char *fname, const char *key);
/* tries to delete first occurence of key from file. If a
key was deleted, returns success. */

void clipcode_write(const char *fname, const char*key, const char *value);
/* tries to write value to key in file. If key didn't exist, creates it...
hmm, or does it fail??? That'd make it simpler and make the add
command more worthwhile...*/

void clipcode_list(const char *fname);
/* lists all keynames parsed in order they are found. Doesn't cull dupes,
but does remove comments and blank lines. */

void clipcode_verify(const char *fname);
/* does sanity check of file. */

