/* ==== clipcode_helpers.c ==== */
/* -lower level helper functions */


#include <ctype.h>
#include <errno.h>
#include <pcre.h>
#include "clipcode_defs.h"
#include "clipcode_globals.h"


void clipcode_version() {
   fprintf(stderr,"clipcode version %s\n",CC_VERSION);
   fprintf(stderr," Please note \"clipcode\" is a working title!\n");
   fprintf(stderr," It may get renamed in future.\n");
   exit(0);
}

void usage() {
   fprintf(stderr,"clipcode- usage:\n");
   fprintf(stderr," %s [-r|-a|-d]  FILENAME  KEYNAME\n",cmdname);
   fprintf(stderr," %s -w FILENAME  KEYNAME  VALUE\n",cmdname);
   fprintf(stderr," %s {-l|-v} FILENAME\n",cmdname);
   fprintf(stderr," %s -V\n\n",cmdname);
   fprintf(stderr,"For more info, see the clipcode manpage.\n");
   exit(1);
}

void clipcode_open(const char *fname) {
   dfile=fopen(fname,"r");
   if(dfile==NULL) {
       sprintf(cc_stringbuffer,"%s: couldn't open file %s for reading",cmdname,fname);
       perror(cc_stringbuffer);
       exit(1);
   }
}

void clipcode_checkkey(const char *key) {
   /* first and foremost, is first character a #? */
   int length,i;
   char c;
   if(key[0]=='#') {
      fprintf(stderr,"%s: invalid key (equivalent to comment)\n",cmdname);
      exit(EXIT_FAILURE);
   }
   length=strlen(key);
   if(length>=CC_MAXKEYSIZE) {
      fprintf(stderr,"%s: Key length: %d. Max key length: %d.\n",cmdname,length, CC_MAXKEYSIZE);
      exit(1);
   }
   for(i=0;i<length;i++) {
       c=key[i];
       /* fprintf(stderr,"KEY character: %c\n",c); */
       if(isalnum(c)) continue;
       switch(c) {
          case '_':
          case '.':
          case '/':
          case '-':
          case '#': /* we allow it if it ISNT first char? */
          case '~':
          case ',':
          case '+':continue; /* all those were OK */
          /* the following definitely aren't */
          case ' ':
             fprintf(stderr,"%s: invalid key \"%s\" (contains space)\n",cmdname,key);
             exit(1);
          case ':':
             fprintf(stderr,"%s: invalid key \"%s\" (contains colon)\n",cmdname,key);
             exit(1);
          default:
             fprintf(stderr,"%s: invalid key \"%s\" (contains illegal characters)\n",cmdname,key);
             exit(1);
       }
   }
}

void clipcode_linetoolong() {
   fprintf(stderr,"%s: line in file was too long\n",cmdname);
   exit(1);
}

/* ==== end of clipcode_helpers.c ==== */
