/* ==== clipcode_args.c ==== */
/*  -a simple CLI program for parsing config files/dictionaries,
  for use within scripts
  (c) Tom Barnes-Lawrence tomble@usermail.com
  http://www.angelfire.com/super2/duologue/
  */

#include <stdio.h>
#include <string.h>
#include <pcre.h>
#include "clipcode_defs.h"
#include "clipcode_protos.h"
#include "clipcode_globals.h"


FILE *dfile;
char cmdname[128]; /* I'm not bloody passing argv[0] around everywhere */
char cc_stringbuffer[CC_BUFSIZE];
char cc_valuebuffer[CC_VALBUFSIZE];
char search_string[CC_MAXKEYSIZE+4];
const char *cc_errptr; /* just a pointer, we don't allocate it */
int cc_eoffset;
int cc_ovector[12]; /* extra for luck... */
pcre *search_regexp;

int main(int argc, char *argv[]) {
/* argv[1] should be either a flag, or the filename.
   if argv[1] is a flag, argv[2] must be the filename. */
   if(strlen(argv[0])<126) {
      strcpy(cmdname, argv[0]); /* could use strncpy and truncate it...*/
   } else {
      sprintf(cmdname,"(clipcode)");
   }
   switch(argc) {
      case 0: /* huh? */
      case 1:
         usage();
         break;
      case 2:
         if(!strcmp(argv[1],"-V")) clipcode_version();
         else usage();
         break;
      case 3:
         /* argv[1] can only be either -v, -l, or FILE. */
         if(*argv[1]=='-') {
            /* got a flag. better be v or l. */
            switch(*(argv[1]+1)) {
               case 'v': clipcode_verify(argv[2]);
               case 'l': clipcode_list(argv[2]);
               default: usage();
            }
         } else {
            /* must be file. default of -r */
            clipcode_read(argv[1],argv[2]);
         }
         break;
      case 4:
         /* argv[1] can be -r, -a, or -d. */
         if(*argv[1]=='-') {
            switch(*(argv[1]+1)) {
               case 'r':clipcode_read(argv[2],argv[3]);
               case 'a':clipcode_add(argv[2],argv[3]);
               case 'd':clipcode_delete(argv[2],argv[3]);
               default: usage();
            }
         } else {
            usage();
         }
         break;
      case 5:
         /* argv[1] must be -w. */
         if(*argv[1]=='-') {
            if(*(argv[1]+1)=='w') {
                clipcode_write(argv[2],argv[3],argv[4]);
            } else usage();
         } else usage();
         break;
      default:
         usage();
         break;
   }
   exit(1); /*if we fell through to here, must have had bad usage? */
}

/* ==== end of clipcode_args.c ==== */
