/* ==== clipcode_a3.c ==== */
/*   top-level functions of arity 3
   Tom Barnes-Lawrence  tomble@usermail.com
   http://www.angelfire.com/super2/duologue/
   */

#include <string.h>
#include <pcre.h>
#include "clipcode_defs.h"
#include "clipcode_protos.h"
#include "clipcode_globals.h"

void clipcode_write(const char *fname, const char*key, const char *value) {
   FILE *tfile; /* a temporary file we write the end file into */
   int success=0;
   int length, scan_result;
   char *eptr;

   clipcode_open(fname);
   clipcode_checkkey(key);
   tfile=tmpfile();
   if(tfile==NULL) {
      perror("clipcode: couldn't open temporary file");
      exit(1);
   }
   sprintf(search_string,"^%s:(.*)$",key);
   search_regexp= pcre_compile(search_string,0,&cc_errptr,&cc_eoffset,NULL);
   while(NULL!=fgets(cc_stringbuffer,CC_BUFSIZE,dfile)) {
      eptr = strchr(cc_stringbuffer,'\n');
      if(NULL==eptr && !feof(dfile))
        /* not at EOF so missing newline must mean ultra-long line! */
          clipcode_linetoolong();
      if(feof(dfile)) length=strlen(cc_stringbuffer);
      else length = eptr - cc_stringbuffer;
      scan_result=pcre_exec(search_regexp,NULL,cc_stringbuffer,length,0,0,cc_ovector,12);
      if(scan_result>0) {
           /* found the key! now, we don't want the value any more, do we? */
           sprintf(cc_stringbuffer,"%s:%s\n",key,value);
           /* do we need a /n? ...looks like it.*/
           fputs(cc_stringbuffer,tfile);
           success=1;
           break;
      } else {
           /* just copy the whole line to temp file */
           fputs(cc_stringbuffer,tfile);
           /* does that add an extra \n to the file? */

      }
   }
   if(!success) {
       fprintf(stderr,"clipcode: couldn't find key \"%s\" to modify\n",key);
       exit(1);
   }
   /* now just copy everything till EOF. */
   while(NULL!=fgets(cc_stringbuffer,CC_BUFSIZE,dfile)) {
      eptr = strchr(cc_stringbuffer,'\n');
      if(NULL==eptr && !feof(dfile))
        /* not at EOF so missing newline must mean ultra-long line! */
          clipcode_linetoolong();
      fputs(cc_stringbuffer,tfile); /* just copy it */
   }
   /* now rewind tfile, reopen (fname) to write, and copy tfile into it*/
   fclose(dfile);
   dfile=fopen(fname,"wb"); /*rewrite*/
   rewind(tfile);
   while(NULL!=fgets(cc_stringbuffer,CC_BUFSIZE,tfile)) {
      /*tfile_done=(NULL==fgets(cc_stringbuffer,CC_BUFSIZE,tfile)); */
      eptr = strchr(cc_stringbuffer,'\n');
      if(NULL==eptr && !feof(tfile)) clipcode_linetoolong();
      fputs(cc_stringbuffer,dfile);
   }
   fclose(dfile);
   exit(0); /* tfile will self destruct in 5...4...3..*/
}

/* nothing else... */

/* ==== end of clipcode_a3.c ==== */
