$APPTYPE CONSOLE    
$TYPECHECK ON
$INCLUDE "RSocket.INC"

DIM Sock as RSocket
DIM RemoteName as STRING, ip$ As STRING, port$ As STRING
Dim S as LONG, ret as LONG

PRINT "This is a proof-of-concept program example."
PRINT "IF you use a known www site and port 80 this will"
PRINT "return the header info for that www site."
PRINT "The HOST is a dotted IP address in the form a.b.c.d"
PRINT "or input a host name here and get the dotted IP address!"

INPUT "Remote Host Name = "; RemoteName
ip$ = Sock.AddrByName(RemoteName)
PRINT "Bingo, the Remote IP address is ";ip$; " or null if not found."
PRINT "You can use that dotted IP adddress below if you want."
PRINT

S = Sock.S  'create socket
PRINT "Socket S= ";S; " from RSocket"
IF S <=0 THEN Goto Done:    'failed to create socket!

ret = Sock.NonBlock(S)
PRINT "Nonblocking returned "; ret; " where 0 = it worked."
PRINT

PRINT "Enter a host and/or port that does NOT exist to see non-blocking"
PRINT "shown by the short time between the Connecting and Sleeping messages."
PRINT "Example: HOST = 127.0.0.1 and PORT = 90 if no server there."
INPUT "HOST = "; ip$    'in form a.b.c.d
INPUT "PORT = "; port$
PRINT "Connecting at ";str$(timer)
ret = Sock.Connect(S,ip$,val(port$))
PRINT "Connect returned "; ret; " and should be -1"

'If Last Error = 10035, socket is working (would block)
PRINT "WSAGetLastError = ";Sock.LastError  

PRINT "Sleeping at ";str$(timer)
sleep 4     'any kind of timer mechanism could be used!!

'Here we don't even have to check if there is a connection.
'If there is, the write/read is implemented.
'This is just a quick example.  Your program should
'Check if there is a connection first, like this:

ret = Sock.IsConnected(S,0&)
PRINT "IsConnected says ";ret;" where 1 = yes and 0 = no."
If ret < 1& Then Goto NoConnection

ret = Sock.Block(S)     'set to blocking for write/read
PRINT "Block returned "; ret; " where 0 = OK, no error."
Sock.Writeline(S,"HEAD / HTTP/1.0")
Sock.Writeline(S,"")
Sock.Writeline(S,"")

'The following sleep instruction may not be necessary since sock is blocking.
'If the remote host sends nothing, your program hangs (see RSocket.txt)!

Sleep 1     'be charming and patient with the server
PRINT Sock.Read(S,16000&)
Sock.EndConnection(S)	'this stops socket I/O

NoConnection:
Sock.Close(S)
PRINT "Closed at ";str$(timer)
Done:
end
