/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;

public abstract class WindowWidget
extends WidgetContainer {
    protected Widget content;
    protected Dimension lastSetSize;
    private Boolean mockVisible;
    private static ThreadLocal encodingInProgress = new ThreadLocal();

    public void setBounds(Rectangle bounds) {
        if (encodingInProgress.get() != Boolean.TRUE && !this.component.isDisplayable()) {
            this.component.addNotify();
        }
        this.lastSetSize = new Dimension(bounds.width, bounds.height);
        this.component.setBounds(bounds);
        this.layoutChildren();
    }

    public Widget getContent() {
        return this.content;
    }

    public void setContent(Widget contentWidget) {
        if (this.content != null) {
            this.remove(this.content);
        }
        this.content = contentWidget;
        if (this.content != null) {
            if (this.content.getParent() != null) {
                this.content.getParent().remove(this.content);
            }
            JComponent contentPane = (JComponent)((RootPaneContainer)((Object)this.component)).getContentPane();
            contentPane.add(this.content.component);
            this.setAsParent(this.content);
        }
    }

    public void pack() {
        if (!this.component.isDisplayable()) {
            this.component.addNotify();
        }
        JComponent contentPane = (JComponent)((RootPaneContainer)((Object)this.component)).getContentPane();
        if (this.content == null) {
            contentPane.setPreferredSize(new Dimension(0, 0));
        } else {
            contentPane.setPreferredSize(this.content.getPreferredSize());
        }
        Dimension prefSize = this.getPreferredSize();
        Rectangle bounds = this.getBounds();
        this.setBounds(new Rectangle(bounds.x, bounds.y, prefSize.width, prefSize.height));
    }

    public void layoutChildren() {
        if (this.content != null) {
            this.component.validate();
            Dimension max = this.content.getMaximumSize();
            Dimension total = ((RootPaneContainer)((Object)this.component)).getContentPane().getSize();
            this.content.component.setBounds(0, 0, Math.min(max.width, total.width), Math.min(max.height, total.height));
            if (this.content instanceof WidgetContainer) {
                ((WidgetContainer)this.content).layoutChildren();
            }
        }
    }

    public void dispose() {
        ((Window)this.component).dispose();
    }

    public void toFront() {
        ((Window)this.getComponent()).toFront();
    }

    public void toBack() {
        ((Window)this.getComponent()).toBack();
    }

    public boolean isVisible() {
        if (this.mockVisible != null) {
            return this.mockVisible;
        }
        return this.component.isVisible();
    }

    public void setVisible(boolean visible) {
        if (encodingInProgress.get() == Boolean.TRUE) {
            this.mockVisible = visible ? Boolean.TRUE : Boolean.FALSE;
            return;
        }
        super.setVisible(visible);
    }
}

