/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.WidgetContainerPanel;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.ExplicitContainerDelegate;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;

public class ExplicitContainer
extends WidgetContainer {
    private ArrayList children;
    private ArrayList childBounds;
    private Dimension requiredSize;

    public ExplicitContainer() {
        this.component = new WidgetContainerPanel(this);
        this.children = new ArrayList();
        this.childBounds = new ArrayList();
        this.requiredSize = new Dimension(0, 0);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Widget getChild(int i) {
        return (Widget)this.children.get(i);
    }

    public Iterator getChildren() {
        return this.children.iterator();
    }

    public void layoutChildren() {
        for (int i = 0; i < this.children.size(); ++i) {
            Widget child = (Widget)this.children.get(i);
            Rectangle bounds = (Rectangle)this.childBounds.get(i);
            child.getComponent().setBounds(bounds);
            if (!(child instanceof WidgetContainer)) continue;
            ((WidgetContainer)child).layoutChildren();
        }
    }

    public void add(Widget widget, Rectangle bounds) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.children.add(widget);
        this.childBounds.add(bounds.clone());
        ((JPanel)this.component).add(widget.component);
        widget.component.setBounds(bounds);
        this.setAsParent(widget);
        this.requiredSize.width = Math.max(this.requiredSize.width, bounds.x + bounds.width);
        this.requiredSize.height = Math.max(this.requiredSize.height, bounds.y + bounds.height);
        this.invalidateSize();
    }

    public int getChildIndex(Widget widget) {
        return this.children.indexOf(widget);
    }

    public Rectangle getChildBounds(int index) {
        return (Rectangle)((Rectangle)this.childBounds.get(index)).clone();
    }

    public void setChildBounds(int index, Rectangle bounds) {
        this.childBounds.set(index, bounds.clone());
        this.findRequiredSize();
    }

    public Rectangle getChildBounds(Widget widget) {
        int index = this.children.indexOf(widget);
        if (index > -1) {
            return (Rectangle)((Rectangle)this.childBounds.get(index)).clone();
        }
        return null;
    }

    public void setChildBounds(Widget widget, Rectangle bounds) {
        int index = this.children.indexOf(widget);
        if (index > -1) {
            this.childBounds.set(index, bounds.clone());
            this.findRequiredSize();
        }
    }

    public void remove(Widget widget) {
        int index = this.children.indexOf(widget);
        if (index > -1) {
            ((JPanel)this.component).remove(widget.component);
            this.children.remove(index);
            this.childBounds.remove(index);
            this.removeAsParent(widget);
            this.findRequiredSize();
        }
    }

    public void removeAll() {
        ((JPanel)this.component).removeAll();
        for (int i = 0; i < this.children.size(); ++i) {
            this.removeAsParent((Widget)this.children.get(i));
        }
        this.children.clear();
        this.childBounds.clear();
        this.requiredSize.height = 0;
        this.requiredSize.width = 0;
        this.invalidateSize();
    }

    private void findRequiredSize() {
        this.requiredSize.height = 0;
        this.requiredSize.width = 0;
        for (int i = this.childBounds.size() - 1; i >= 0; --i) {
            Rectangle r = (Rectangle)this.childBounds.get(i);
            this.requiredSize.width = Math.max(this.requiredSize.width, r.x + r.width);
            this.requiredSize.height = Math.max(this.requiredSize.height, r.y + r.height);
        }
        this.invalidateSize();
    }

    public Dimension getMinimumSize() {
        return this.requiredSize;
    }

    public Dimension getPreferredSize() {
        return this.requiredSize;
    }

    static {
        WidgetEncoder.setPersistenceDelegate(ExplicitContainer.class, new ExplicitContainerDelegate());
    }
}

