/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.widget.BScrollPane;
import buoy.widget.TextWidget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Dimension;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class BTextArea
extends TextWidget {
    public static final WrapStyle WRAP_NONE = new WrapStyle();
    public static final WrapStyle WRAP_CHARACTER = new WrapStyle();
    public static final WrapStyle WRAP_WORD = new WrapStyle();

    public BTextArea() {
        this(null, 0, 0);
    }

    public BTextArea(String text) {
        this(text, 0, 0);
    }

    public BTextArea(int rows, int columns) {
        this(null, rows, columns);
    }

    public BTextArea(String text, int rows, int columns) {
        this.component = this.createComponent();
        JTextArea ta = (JTextArea)this.component;
        ta.setText(text);
        ta.setRows(rows);
        ta.setColumns(columns);
        ta.addCaretListener(this.caretListener);
        ta.getDocument().addDocumentListener(this.documentListener);
    }

    protected JTextArea createComponent() {
        return new JTextArea();
    }

    public int getRows() {
        return ((JTextArea)this.component).getRows();
    }

    public void setRows(int rows) {
        ((JTextArea)this.component).setRows(rows);
        this.invalidateSize();
    }

    public int getColumns() {
        return ((JTextArea)this.component).getColumns();
    }

    public void setColumns(int columns) {
        ((JTextArea)this.component).setColumns(columns);
        this.invalidateSize();
    }

    public int getLineCount() {
        return ((JTextArea)this.component).getLineCount();
    }

    public WrapStyle getWrapStyle() {
        JTextArea ta = (JTextArea)this.component;
        if (!ta.getLineWrap()) {
            return WRAP_NONE;
        }
        if (ta.getWrapStyleWord()) {
            return WRAP_WORD;
        }
        return WRAP_CHARACTER;
    }

    public void setWrapStyle(WrapStyle style) {
        JTextArea ta = (JTextArea)this.component;
        if (style == WRAP_NONE) {
            ta.setLineWrap(false);
        } else if (style == WRAP_CHARACTER) {
            ta.setLineWrap(true);
            ta.setWrapStyleWord(false);
        } else if (style == WRAP_WORD) {
            ta.setLineWrap(true);
            ta.setWrapStyleWord(true);
        }
        this.invalidateSize();
    }

    public int getTabSize() {
        return ((JTextArea)this.component).getTabSize();
    }

    public void setTabSize(int size) {
        ((JTextArea)this.component).setTabSize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String text) {
        try {
            ++this.suppressEvents;
            ((JTextArea)this.component).append(text);
        }
        finally {
            --this.suppressEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(String text, int pos) {
        try {
            ++this.suppressEvents;
            ((JTextArea)this.component).insert(text, pos);
        }
        finally {
            --this.suppressEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceRange(String text, int start, int end) {
        try {
            ++this.suppressEvents;
            ((JTextArea)this.component).replaceRange(text, start, end);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public Dimension getMinimumSize() {
        Dimension min = super.getMinimumSize();
        if (this.getWrapStyle() != WRAP_NONE) {
            min.width = 0;
        }
        return min;
    }

    protected void textChanged() {
        super.textChanged();
        if (this.getParent() instanceof BScrollPane) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BTextArea.this.getParent().layoutChildren();
                }
            });
        }
    }

    static {
        WidgetEncoder.setPersistenceDelegate(WrapStyle.class, new StaticFieldDelegate(BTextArea.class));
    }

    public static class WrapStyle {
        private WrapStyle() {
        }
    }
}

