/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.ValueChangedEvent;
import buoy.internal.SingleWidgetPanel;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.BSplitPaneDelegate;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class BSplitPane
extends WidgetContainer {
    private Widget[] child;
    private int suppressEvents;
    public static final Orientation HORIZONTAL = new Orientation(1);
    public static final Orientation VERTICAL = new Orientation(0);

    public BSplitPane() {
        this(HORIZONTAL, null, null);
    }

    public BSplitPane(Orientation orient) {
        this(orient, null, null);
    }

    public BSplitPane(Orientation orient, Widget child1, Widget child2) {
        this.component = this.createComponent();
        ((JSplitPane)this.component).addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                BSplitPane.this.layoutChildren();
                if (BSplitPane.this.suppressEvents == 0) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            1.access$200(this.this$1).dispatchEvent(new ValueChangedEvent(1.access$200(this.this$1)));
                        }
                    });
                }
            }

            static /* synthetic */ BSplitPane access$200(1 x0) {
                return x0.BSplitPane.this;
            }
        });
        this.child = new Widget[2];
        if (child1 != null) {
            this.add(child1, 0);
        }
        if (child2 != null) {
            this.add(child2, 1);
        }
        this.setOrientation(orient);
    }

    protected JSplitPane createComponent() {
        return new JSplitPane(1, false);
    }

    public int getDividerLocation() {
        return ((JSplitPane)this.component).getDividerLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDividerLocation(int location) {
        try {
            ++this.suppressEvents;
            ((JSplitPane)this.component).setDividerLocation(location);
        }
        finally {
            --this.suppressEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDividerLocation(double location) {
        try {
            ++this.suppressEvents;
            ((JSplitPane)this.component).setDividerLocation(location);
        }
        finally {
            --this.suppressEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetToPreferredSizes() {
        try {
            ++this.suppressEvents;
            ((JSplitPane)this.component).resetToPreferredSizes();
        }
        finally {
            --this.suppressEvents;
        }
    }

    public Orientation getOrientation() {
        return ((JSplitPane)this.component).getOrientation() == 1 ? HORIZONTAL : VERTICAL;
    }

    public void setOrientation(Orientation orient) {
        ((JSplitPane)this.component).setOrientation(orient.value);
    }

    public boolean isContinuousLayout() {
        return ((JSplitPane)this.component).isContinuousLayout();
    }

    public void setContinuousLayout(boolean continuous) {
        ((JSplitPane)this.component).setContinuousLayout(continuous);
    }

    public boolean isOneTouchExpandable() {
        return ((JSplitPane)this.component).isOneTouchExpandable();
    }

    public void setOneTouchExpandable(boolean expandable) {
        ((JSplitPane)this.component).setOneTouchExpandable(expandable);
    }

    public double getResizeWeight() {
        return ((JSplitPane)this.component).getResizeWeight();
    }

    public void setResizeWeight(double weight) {
        ((JSplitPane)this.component).setResizeWeight(weight);
    }

    public int getChildCount() {
        int count = 0;
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] == null) continue;
            ++count;
        }
        return count;
    }

    public Iterator getChildren() {
        ArrayList<Widget> ls = new ArrayList<Widget>(2);
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] == null) continue;
            ls.add(this.child[i]);
        }
        return ls.iterator();
    }

    public Widget getChild(int index) {
        return this.child[index];
    }

    public void layoutChildren() {
        this.component.validate();
        for (int i = 0; i < this.child.length; ++i) {
            if (!(this.child[i] instanceof WidgetContainer)) continue;
            ((WidgetContainer)this.child[i]).layoutChildren();
        }
    }

    public void add(Widget widget, int index) {
        if (this.child[index] != null) {
            this.remove(index);
        }
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.child[index] = widget;
        if (index == 0) {
            ((JSplitPane)this.component).setLeftComponent(new SingleWidgetPanel(widget));
        } else {
            ((JSplitPane)this.component).setRightComponent(new SingleWidgetPanel(widget));
        }
        this.setAsParent(widget);
        this.invalidateSize();
    }

    public void remove(Widget widget) {
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] != widget) continue;
            this.remove(i);
            return;
        }
    }

    public void remove(int index) {
        if (this.child[index] == null) {
            return;
        }
        ((JSplitPane)this.component).remove(this.child[index].getComponent().getParent());
        this.removeAsParent(this.child[index]);
        this.child[index] = null;
        this.invalidateSize();
    }

    public void removeAll() {
        ((JSplitPane)this.component).removeAll();
    }

    public Dimension getMinimumSize() {
        Dimension dim0 = this.child[0] == null ? new Dimension() : this.child[0].getMinimumSize();
        Dimension dim1 = this.child[1] == null ? new Dimension() : this.child[1].getMinimumSize();
        int dividerWidth = ((JSplitPane)this.component).getDividerSize();
        if (this.getOrientation() == HORIZONTAL) {
            return new Dimension(dim0.width + dim1.width + dividerWidth, Math.max(dim0.height, dim1.height));
        }
        return new Dimension(Math.max(dim0.width, dim1.width), dim0.height + dim1.height + dividerWidth);
    }

    public Dimension getPreferredSize() {
        Dimension dim0 = this.child[0] == null ? new Dimension() : this.child[0].getPreferredSize();
        Dimension dim1 = this.child[1] == null ? new Dimension() : this.child[1].getPreferredSize();
        int dividerWidth = ((JSplitPane)this.component).getDividerSize();
        if (this.getOrientation() == HORIZONTAL) {
            return new Dimension(dim0.width + dim1.width + dividerWidth, Math.max(dim0.height, dim1.height));
        }
        return new Dimension(Math.max(dim0.width, dim1.width), dim0.height + dim1.height + dividerWidth);
    }

    static {
        WidgetEncoder.setPersistenceDelegate(BSplitPane.class, new BSplitPaneDelegate());
        WidgetEncoder.setPersistenceDelegate(Orientation.class, new StaticFieldDelegate(BSplitPane.class));
    }

    public static class Orientation {
        protected int value;

        private Orientation(int value) {
            this.value = value;
        }
    }
}

