/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.SelectionChangedEvent;
import buoy.widget.BScrollBar;
import buoy.widget.BScrollPane;
import buoy.widget.Widget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.BListDelegate;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BList
extends Widget {
    protected DefaultListModel defaultModel = new DefaultListModel();

    public BList() {
        this.component = this.createComponent();
        ((JList)this.component).addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                BList.this.dispatchEvent(new SelectionChangedEvent(BList.this, ev.getValueIsAdjusting()));
            }
        });
    }

    public BList(Object[] contents) {
        this();
        this.setContents(contents);
    }

    public BList(Collection[] contents) {
        this();
        this.setContents(contents);
    }

    public BList(ListModel model) {
        this();
        ((JList)this.component).setModel(model);
    }

    protected JList createComponent() {
        return new JList(this.defaultModel);
    }

    public void setContents(Object[] o) {
        this.defaultModel.clear();
        for (int i = 0; i < o.length; ++i) {
            this.defaultModel.addElement(o[i]);
        }
        this.updateScrollPane();
    }

    public void setContents(Collection c) {
        this.defaultModel.clear();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.defaultModel.addElement(it.next());
        }
        this.updateScrollPane();
    }

    public void add(Object o) {
        int index = this.defaultModel.size();
        this.defaultModel.addElement(o);
        this.updateScrollPane();
    }

    public void add(int index, Object o) {
        this.defaultModel.add(index, o);
        this.updateScrollPane();
    }

    public void replace(int index, Object o) {
        this.defaultModel.set(index, o);
        this.updateScrollPane();
    }

    public void remove(int index) {
        this.defaultModel.remove(index);
        this.updateScrollPane();
    }

    public void removeAll() {
        this.defaultModel.clear();
        this.updateScrollPane();
    }

    public ListModel getModel() {
        return ((JList)this.component).getModel();
    }

    public void setModel(ListModel model) {
        ((JList)this.component).setModel(model);
    }

    private void updateScrollPane() {
        this.invalidateSize();
        if (!(this.getParent() instanceof BScrollPane)) {
            return;
        }
        BScrollPane sp = (BScrollPane)this.getParent();
        BScrollBar sb = sp.getVerticalScrollBar();
        if (sb != null) {
            sb.setMaximum(this.component.getHeight());
        }
        if ((sb = sp.getHorizontalScrollBar()) != null) {
            sb.setMaximum(this.component.getWidth());
        }
    }

    public int getItemCount() {
        return ((JList)this.component).getModel().getSize();
    }

    public Object getItem(int index) {
        return ((JList)this.component).getModel().getElementAt(index);
    }

    public boolean isMultipleSelectionEnabled() {
        return ((JList)this.component).getSelectionMode() != 0;
    }

    public void setMultipleSelectionEnabled(boolean multiple) {
        ((JList)this.component).setSelectionMode(multiple ? 2 : 0);
    }

    public int getPreferredVisibleRows() {
        return ((JList)this.component).getVisibleRowCount();
    }

    public void setPreferredVisibleRows(int rows) {
        ((JList)this.component).setVisibleRowCount(rows);
        this.invalidateSize();
    }

    public boolean isSelected(int index) {
        return ((JList)this.component).isSelectedIndex(index);
    }

    public int getSelectedIndex() {
        return ((JList)this.component).getSelectedIndex();
    }

    public int[] getSelectedIndices() {
        return ((JList)this.component).getSelectedIndices();
    }

    public Object getSelectedValue() {
        return ((JList)this.component).getSelectedValue();
    }

    public Object[] getSelectedValues() {
        return ((JList)this.component).getSelectedValues();
    }

    public void clearSelection() {
        ((JList)this.component).clearSelection();
    }

    public void setSelected(int index, boolean selected) {
        if (selected) {
            ((JList)this.component).addSelectionInterval(index, index);
        } else {
            ((JList)this.component).removeSelectionInterval(index, index);
        }
    }

    public void scrollToItem(int index) {
        ((JList)this.component).ensureIndexIsVisible(index);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    static {
        WidgetEncoder.setPersistenceDelegate(BList.class, new BListDelegate());
    }
}

