/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.view;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.texture.TextureSpec;
import artofillusion.view.VertexShader;

public class SmoothVertexShader
implements VertexShader {
    private RGBColor meshColor;
    private RenderingMesh mesh;
    private Vec3 viewDir;
    private float[] light;

    public SmoothVertexShader(RenderingMesh mesh, Object3D object, double time, Vec3 viewDir) {
        this.mesh = mesh;
        this.viewDir = viewDir;
        TextureSpec spec = new TextureSpec();
        object.getTexture().getAverageSpec(spec, time, object.getAverageParameterValues());
        this.meshColor = new RGBColor((double)spec.diffuse.getRed() + 0.5 * (double)spec.specular.getRed(), (double)spec.diffuse.getGreen() + 0.5 * (double)spec.specular.getGreen(), (double)spec.diffuse.getBlue() + 0.5 * (double)spec.specular.getBlue());
        this.meshColor.clip();
        this.light = new float[mesh.norm.length];
    }

    public SmoothVertexShader(RenderingMesh mesh, RGBColor color, Vec3 viewDir) {
        this.mesh = mesh;
        this.meshColor = color;
        this.viewDir = viewDir;
        this.light = new float[mesh.norm.length];
    }

    public void getColor(int face, int vertex, RGBColor color) {
        int norm;
        switch (vertex) {
            case 0: {
                norm = this.mesh.triangle[face].n1;
                break;
            }
            case 1: {
                norm = this.mesh.triangle[face].n2;
                break;
            }
            default: {
                norm = this.mesh.triangle[face].n3;
            }
        }
        if (this.light[norm] == 0.0f) {
            float dot = (float)this.viewDir.dot(this.mesh.norm[norm]);
            this.light[norm] = 0.1f + 0.8f * (dot > 0.0f ? dot : -dot);
        }
        color.copy(this.meshColor);
        color.scale(this.light[norm]);
    }

    public boolean isUniformFace(int face) {
        RenderingTriangle tri = this.mesh.triangle[face];
        return tri.n1 == tri.n2 && tri.n1 == tri.n3;
    }
}

