/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.view;

import artofillusion.RenderingMesh;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.texture.TextureSpec;
import artofillusion.view.VertexShader;

public class FlatVertexShader
implements VertexShader {
    private RGBColor meshColor;
    private RenderingMesh mesh;
    private Vec3 viewDir;

    public FlatVertexShader(RenderingMesh mesh, Object3D object, double time, Vec3 viewDir) {
        this.mesh = mesh;
        this.viewDir = viewDir;
        TextureSpec spec = new TextureSpec();
        object.getTexture().getAverageSpec(spec, time, object.getAverageParameterValues());
        this.meshColor = new RGBColor((double)spec.diffuse.getRed() + 0.5 * (double)spec.specular.getRed(), (double)spec.diffuse.getGreen() + 0.5 * (double)spec.specular.getGreen(), (double)spec.diffuse.getBlue() + 0.5 * (double)spec.specular.getBlue());
        this.meshColor.clip();
    }

    public FlatVertexShader(RenderingMesh mesh, RGBColor color, Vec3 viewDir) {
        this.mesh = mesh;
        this.meshColor = color;
        this.viewDir = viewDir;
    }

    public void getColor(int face, int vertex, RGBColor color) {
        color.copy(this.meshColor);
        color.scale(0.1f + 0.8f * Math.abs((float)this.viewDir.dot(this.mesh.faceNorm[face])));
    }

    public boolean isUniformFace(int face) {
        return true;
    }
}

